/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekttyp Steuerung für die NBA Steuerung.
<p>
&lt;absatz&gt;
						Der Typ Steuerlogik ist ein persistentes dynamisches Objekt,
            das nicht vom Benutzer konfiguriert oder parametriert werden kann.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
            ???
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface NbaSteuerungLokal extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaSteuerung
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.nbaSteuerungLokal"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Menge der NbaUrsachenEinheiten an der lokalen Steuerung.
<p>

</p>

@return die Menge UrsachenEinheiten oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheit> getUrsachenEinheiten();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung der Ergebnisdaten Ursacheneinheit.
	<p>
	&lt;absatz&gt;
							Attributgruppe zur Speicherung der Ergebnisdaten pro Ursacheneinheit
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaUeSchaltbild.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeSchaltbild getPdNbaUeSchaltbild();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Status der Steuerung.
	<p>
	
	</p>
	@return der Datensatz NbaStrgStatus.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaStrgStatus getOdNbaStrgStatus();
	
	/**
	Attributgruppe für die Definition der zu berechnenden Ursacheneinheiten durch die Steuerung.
	<p>
	&lt;absatz&gt;
							Liste der Ursacheneinheit&#47;Algorithmuskombinationen die durch die Steuerung berechnet werden sollen .
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaStrgSteuerlogikLokal.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgSteuerlogikLokal getPdNbaStrgSteuerlogikLokal();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Zuordnung von AQ's zur Steuerung.
	<p>
	&lt;absatz&gt;
							Liste der Anzeigenquerschnitte die für die Steuerung relevant sind.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaStrgAqZuordnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgAqZuordnung getPdNbaStrgAqZuordnung();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Parameter für den Mischer Gesamt um die Bearbeitung der Befehle der netzweiten Steuerung ein- bzw. auszuschalten.
	<p>
	
	</p>
	@return der Datensatz NbaStrgParameterMischer.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterMischer getPdNbaStrgParameterMischer();
	
	/**
	Attributgruppe zur Parametrierung der Priorität.
	<p>
	&lt;absatz&gt;
	            Attributgruppe zur Parametrierung der Priorität
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaPrioritaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaPrioritaet getPdNbaPrioritaet();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
