/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekttyp für die netzweite Steuerung NBA.
<p>
&lt;absatz&gt;
						Der Typ Steuerlogik ist ein persistentes dynamisches Objekt,
            das nicht vom Benutzer konfiguriert oder parametriert werden kann.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
            ???
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public interface NbaSteuerungNetzweit extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaSteuerung
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.nbaSteuerungNetzweit"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Menge der zu verarbeitenden NbaEntscheidungspunkte.
<p>

</p>

@return die Menge ZuVerarbeitendeEntscheidungspunkte oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt> getZuVerarbeitendeEntscheidungspunkte();

/**
Menge der zu verarbeitenden NbaZiele.
<p>

</p>

@return die Menge ZuVerarbeitendeZiele oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel> getZuVerarbeitendeZiele();

/**
Menge der zu berechnenden NbaZiele.
<p>

</p>

@return die Menge ZuBerechnendeZiele oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel> getZuBerechnendeZiele();

/**
Menge der zu berechnenden NbaEntscheidungspunkte.
<p>

</p>

@return die Menge ZuBerechnendeEntscheidungspunkte oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt> getZuBerechnendeEntscheidungspunkte();

/**
Menge der zu berechnenden NbaRoutenStücke.
<p>

</p>

@return die Menge ZuBerechnendeRoutenStuecke oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> getZuBerechnendeRoutenStuecke();

/**
Menge der zu verarbeitenden NbaRoutenStücke.
<p>

</p>

@return die Menge ZuVerarbeitendeRoutenStuecke oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> getZuVerarbeitendeRoutenStuecke();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung der Ergebnisdaten Ursacheneinheit.
	<p>
	&lt;absatz&gt;
							Attributgruppe zur Speicherung der Ergebnisdaten pro Ursacheneinheit
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaUeSchaltbild.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeSchaltbild getPdNbaUeSchaltbild();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Status der Steuerung.
	<p>
	
	</p>
	@return der Datensatz NbaStrgStatus.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaStrgStatus getOdNbaStrgStatus();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Globale Parameter für die netzweite Steuerung.
	<p>
	&lt;absatz&gt;
							Globale Parameter für die netzweite Steuerung.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaStrgSteuerlogikNetzweit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgSteuerlogikNetzweit getPdNbaStrgSteuerlogikNetzweit();
	
	/**
	Parameter für die Steuerungslogik für die netzweite Beeinflussung Reisezeiten.
	<p>
	
	</p>
	@return der Datensatz NbaStrgParameterReisezeiten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterReisezeiten getPdNbaStrgParameterReisezeiten();
	
	/**
	Zuordnung von AQ's zur Steuerung.
	<p>
	&lt;absatz&gt;
							Liste der Anzeigenquerschnitte die für die Steuerung relevant sind.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaStrgAqZuordnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgAqZuordnung getPdNbaStrgAqZuordnung();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Alternative Bezeichungen für Location (richtungsabhängig) zur Anzeige der Anschlussstelle mit den Templates der Netzweiten Steuerung.
	<p>
	Für die angegebene Location, mit der Möglichkeit der Angabe einer Richtung, können mehrere alternative Bezeichungen versorgt werden.
	          Die im Array versorgten alternativen Bezeichungen werden in der Reihenfolge, in der sie im Array vorliegen abgearbeitet. D. h. die
	          alternative Bezeichnung mit dem Index 0 hat die höchste Priorität für die Verwendung zur Anzeige.
	          Somit können unterschiedliche alternativen Bezeichungen für unterschiedlich lange Wechseltextanzeigen zum Einsatz gebracht werden.
	          Beim ersten Einsatz wird nur die TmcRichtung "ohne Richtung" verwendet.
	</p>
	@return der Datensatz NbaLocationAlternativeBezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaLocationAlternativeBezeichnung getPdNbaLocationAlternativeBezeichnung();
	
	/**
	Parameter für den Mischer Gesamt um die Bearbeitung der Befehle der netzweiten Steuerung ein- bzw. auszuschalten.
	<p>
	
	</p>
	@return der Datensatz NbaStrgParameterMischer.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterMischer getPdNbaStrgParameterMischer();
	
	/**
	Attributgruppe zur Parametrierung der Priorität.
	<p>
	&lt;absatz&gt;
	            Attributgruppe zur Parametrierung der Priorität
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaPrioritaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaPrioritaet getPdNbaPrioritaet();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
