/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Globaler Datentyp der NBA.
<p>
&lt;absatz&gt;
						Das Objekt nbaGlobal ist ein persistentes dynamisches Objekt, das nicht vom Benutzer konfiguriert oder parametriert werden kann.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class NbaGlobalImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaGlobal { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public NbaGlobalImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public NbaGlobalImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein nbaGlobal.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterGanglinieTyp getPdNbaParameterGanglinieTyp() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterGanglinieTyp.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterStauanalyse getPdNbaParameterStauanalyse() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterStauanalyse.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterGanglinienAuswahl getPdNbaParameterGanglinienAuswahl() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterGanglinienAuswahl.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterFundamental getPdNbaParameterFundamental() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterFundamental.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaStrgDatenLokaleBeeinflussung getOdNbaStrgDatenLokaleBeeinflussung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaStrgDatenLokaleBeeinflussung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterFundamentalTyp getPdNbaParameterFundamentalTyp() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterFundamentalTyp.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterDifferenzGanglinieTyp getPdNbaParameterDifferenzGanglinieTyp() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterDifferenzGanglinieTyp.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterBaustellenMeldung getPdNbaParameterBaustellenMeldung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterBaustellenMeldung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterKapazitaetsermittlung getPdNbaParameterKapazitaetsermittlung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterKapazitaetsermittlung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaBedingungFundamental getPdNbaBedingungFundamental() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaBedingungFundamental.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaZwischenErgebnisseStau getOdNbaZwischenErgebnisseStau() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaZwischenErgebnisseStau.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterUeberwachungPrognoseErgebnisse getPdNbaParameterUeberwachungPrognoseErgebnisse() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterUeberwachungPrognoseErgebnisse.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterReisezeitenRoute getPdNbaStrgParameterReisezeitenRoute() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterReisezeitenRoute.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUmfeld getPdNbaUmfeld() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUmfeld.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterStauPrognose getPdNbaParameterStauPrognose() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterStauPrognose.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaFundamentaldiagramm getPdNbaFundamentaldiagramm() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaFundamentaldiagramm.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaGanglinie getPdNbaGanglinie() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaGanglinie.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterGanglinieGlobal getPdNbaParameterGanglinieGlobal() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterGanglinieGlobal.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterVerkehrsmodellGlobal getPdNbaParameterVerkehrsmodellGlobal() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterVerkehrsmodellGlobal.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterPrognoseGanglinie getPdNbaParameterPrognoseGanglinie() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterPrognoseGanglinie.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
