/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekttyp Steuerung für die NBA Steuerung.
<p>
&lt;absatz&gt;
						Der Typ Steuerlogik ist ein persistentes dynamisches Objekt,
            das nicht vom Benutzer konfiguriert oder parametriert werden kann.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
            ???
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class NbaSteuerungLokalImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaSteuerungLokal { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public NbaSteuerungLokalImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public NbaSteuerungLokalImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein nbaSteuerungLokal.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheit> ursachenEinheiten;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheit> getUrsachenEinheiten() {
		if (ursachenEinheiten == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("UrsachenEinheiten") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			ursachenEinheiten = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheit>(getObjektFactory(), (MutableSet)ko.getObjectSet("UrsachenEinheiten"), 0, 0, this);
		}
		return ursachenEinheiten;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeSchaltbild getPdNbaUeSchaltbild() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeSchaltbild.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaStrgStatus getOdNbaStrgStatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaStrgStatus.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgSteuerlogikLokal getPdNbaStrgSteuerlogikLokal() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgSteuerlogikLokal.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgAqZuordnung getPdNbaStrgAqZuordnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgAqZuordnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterMischer getPdNbaStrgParameterMischer() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterMischer.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaPrioritaet getPdNbaPrioritaet() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaPrioritaet.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
