/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekttyp für die netzweite Steuerung NBA.
<p>
&lt;absatz&gt;
						Der Typ Steuerlogik ist ein persistentes dynamisches Objekt,
            das nicht vom Benutzer konfiguriert oder parametriert werden kann.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
            ???
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class NbaSteuerungNetzweitImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaSteuerungNetzweit { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public NbaSteuerungNetzweitImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public NbaSteuerungNetzweitImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein nbaSteuerungNetzweit.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt> zuVerarbeitendeEntscheidungspunkte;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt> getZuVerarbeitendeEntscheidungspunkte() {
		if (zuVerarbeitendeEntscheidungspunkte == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("ZuVerarbeitendeEntscheidungspunkte") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("ZuVerarbeitendeEntscheidungspunkte").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt) getObjektFactory().getModellobjekt(so));
			}
			zuVerarbeitendeEntscheidungspunkte = Collections.unmodifiableCollection(menge);
		}
		return zuVerarbeitendeEntscheidungspunkte;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel> zuVerarbeitendeZiele;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel> getZuVerarbeitendeZiele() {
		if (zuVerarbeitendeZiele == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("ZuVerarbeitendeZiele") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("ZuVerarbeitendeZiele").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel) getObjektFactory().getModellobjekt(so));
			}
			zuVerarbeitendeZiele = Collections.unmodifiableCollection(menge);
		}
		return zuVerarbeitendeZiele;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel> zuBerechnendeZiele;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel> getZuBerechnendeZiele() {
		if (zuBerechnendeZiele == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("ZuBerechnendeZiele") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("ZuBerechnendeZiele").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel) getObjektFactory().getModellobjekt(so));
			}
			zuBerechnendeZiele = Collections.unmodifiableCollection(menge);
		}
		return zuBerechnendeZiele;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt> zuBerechnendeEntscheidungspunkte;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt> getZuBerechnendeEntscheidungspunkte() {
		if (zuBerechnendeEntscheidungspunkte == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("ZuBerechnendeEntscheidungspunkte") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("ZuBerechnendeEntscheidungspunkte").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt) getObjektFactory().getModellobjekt(so));
			}
			zuBerechnendeEntscheidungspunkte = Collections.unmodifiableCollection(menge);
		}
		return zuBerechnendeEntscheidungspunkte;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> zuBerechnendeRoutenStuecke;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> getZuBerechnendeRoutenStuecke() {
		if (zuBerechnendeRoutenStuecke == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("ZuBerechnendeRoutenStücke") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("ZuBerechnendeRoutenStücke").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck) getObjektFactory().getModellobjekt(so));
			}
			zuBerechnendeRoutenStuecke = Collections.unmodifiableCollection(menge);
		}
		return zuBerechnendeRoutenStuecke;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> zuVerarbeitendeRoutenStuecke;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> getZuVerarbeitendeRoutenStuecke() {
		if (zuVerarbeitendeRoutenStuecke == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("ZuVerarbeitendeRoutenStücke") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("ZuVerarbeitendeRoutenStücke").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck) getObjektFactory().getModellobjekt(so));
			}
			zuVerarbeitendeRoutenStuecke = Collections.unmodifiableCollection(menge);
		}
		return zuVerarbeitendeRoutenStuecke;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeSchaltbild getPdNbaUeSchaltbild() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeSchaltbild.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaStrgStatus getOdNbaStrgStatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaStrgStatus.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgSteuerlogikNetzweit getPdNbaStrgSteuerlogikNetzweit() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgSteuerlogikNetzweit.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterReisezeiten getPdNbaStrgParameterReisezeiten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterReisezeiten.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgAqZuordnung getPdNbaStrgAqZuordnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgAqZuordnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaLocationAlternativeBezeichnung getPdNbaLocationAlternativeBezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaLocationAlternativeBezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterMischer getPdNbaStrgParameterMischer() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterMischer.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaPrioritaet getPdNbaPrioritaet() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaPrioritaet.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
