/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zufahrtsrichtung-Ziel für die Netzweite Steuerung.
<p>
&lt;absatz&gt;
						Wenn das eigentliche Ziel nicht durch eine einzige Position (StraßenKnoten) im Straßen-Netz bestimmt 
            werden kann, dann werden mit diesem Typ Zufahrtsrichtungsabhängige Ziele definiert.
            Wenn die Route dann aus der entsprechenden Richtung kommt, bilden diese Ziele das Ende der Route.
            Durch diese Vorgehensweise enden nicht alle Routen die zu einem Ziel führen, in einem Punkt.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 32
 */
public class NbaZielZufahrtRichtungImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZielZufahrtRichtung { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public NbaZielZufahrtRichtungImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public NbaZielZufahrtRichtungImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein Zufahrtsrichtung-Ziel netzweite Steuerung.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> ausnahmeRoutenStuecke;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> getAusnahmeRoutenStuecke() {
		if (ausnahmeRoutenStuecke == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("AusnahmeRoutenStücke") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("AusnahmeRoutenStücke").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck) getObjektFactory().getModellobjekt(so));
			}
			ausnahmeRoutenStuecke = Collections.unmodifiableCollection(menge);
		}
		return ausnahmeRoutenStuecke;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaZielZufahrtRichtungParameter getPdNbaZielZufahrtRichtungParameter() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaZielZufahrtRichtungParameter.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaZielZufahrtRichtung getKdNbaZielZufahrtRichtung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdNbaZielZufahrtRichtung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
