/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Analysedaten für die Steuerungslogik für die lokale Beeinflussung Algorithmus 7(Stausituation abschnittsbezogen).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class OdNbaStrgDatenStausituationAlgorithmus7 extends AbstractOnlineDatensatz<OdNbaStrgDatenStausituationAlgorithmus7.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Analyse,
				};
			}
	
			/**
			 * Analysewerte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Analyse = new Aspekte("Analyse", "asp.analyse");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _kombinationAGueltig
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _kombinationBGueltig
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
				 _logik
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStausituationAlgorithmus7
				 _kombinationA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStausituationAlgorithmus7
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStausituationAlgorithmus7
				 _kombinationB
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStausituationAlgorithmus7
				()
				;
		
			/**
			Kennzeichnung, ob die Stausituationen der Kombination von Stauindikatoren gültig ist.
			            Prüfung: Stauindikator gleich STAU.
			<p>
			
			</p>
			
			@return der Wert von KombinationAGueltig.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getKombinationAGueltig() {
				return _kombinationAGueltig;
			}
		
			/**
			Kennzeichnung, ob die Stausituationen der Kombination von Stauindikatoren gültig ist.
			            Prüfung: Stauindikator gleich STAU.
			<p>
			
			</p>
			
			@param _kombinationAGueltig der neue Wert von KombinationAGueltig.
			*/
			public void setKombinationAGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _kombinationAGueltig) {
				this._kombinationAGueltig = _kombinationAGueltig;
			}
		
			/**
			Kennzeichnung, ob die Stausituationen der Kombination von Stauindikatoren gültig ist.
			            Prüfung: Stauindikator ungleich STAU.
			<p>
			
			</p>
			
			@return der Wert von KombinationBGueltig.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getKombinationBGueltig() {
				return _kombinationBGueltig;
			}
		
			/**
			Kennzeichnung, ob die Stausituationen der Kombination von Stauindikatoren gültig ist.
			            Prüfung: Stauindikator ungleich STAU.
			<p>
			
			</p>
			
			@param _kombinationBGueltig der neue Wert von KombinationBGueltig.
			*/
			public void setKombinationBGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _kombinationBGueltig) {
				this._kombinationBGueltig = _kombinationBGueltig;
			}
		
			/**
			Länge des Stau.
			<p>
			
			</p>
			
			@return der Wert von Logik.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
				 getLogik() {
				return _logik;
			}
		
			/**
			Länge des Stau.
			<p>
			
			</p>
			
			@param _logik der neue Wert von Logik.
			*/
			public void setLogik(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
			 _logik) {
				this._logik = _logik;
			}
		
			/**
			Analysedaten Stauindikatoren der Kombination A.
			<p>
			
			</p>
			
			@return der Wert von KombinationA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStausituationAlgorithmus7
				 getKombinationA() {
				return _kombinationA;
			}
		
			/**
			Analysedaten Stauindikatoren der Kombination A.
			<p>
			
			</p>
			
			@param _kombinationA der neue Wert von KombinationA.
			*/
			public void setKombinationA(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStausituationAlgorithmus7
			 _kombinationA) {
				this._kombinationA = _kombinationA;
			}
		
			/**
			Analysedaten Stauindikatoren der Kombination A.
			<p>
			
			</p>
			
			@return der Wert von KombinationB.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStausituationAlgorithmus7
				 getKombinationB() {
				return _kombinationB;
			}
		
			/**
			Analysedaten Stauindikatoren der Kombination A.
			<p>
			
			</p>
			
			@param _kombinationB der neue Wert von KombinationB.
			*/
			public void setKombinationB(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStausituationAlgorithmus7
			 _kombinationB) {
				this._kombinationB = _kombinationB;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getKombinationAGueltig() != null) {
		                if (getKombinationAGueltig().isZustand()) {
		                    datum.getUnscaledValue("KombinationAGültig").setText(getKombinationAGueltig().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KombinationAGültig").set(getKombinationAGueltig().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKombinationBGueltig() != null) {
		                if (getKombinationBGueltig().isZustand()) {
		                    datum.getUnscaledValue("KombinationBGültig").setText(getKombinationBGueltig().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KombinationBGültig").set(getKombinationBGueltig().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLogik() != null) {
		                if (getLogik().isZustand()) {
		                    datum.getUnscaledValue("Logik").setText(getLogik().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Logik").set(getLogik().getValue());
		                }
					}
					// AttributListenDefinition
						getKombinationA().bean2Atl(datum.getItem("KombinationA"), factory);
					// AttributListenDefinition
						getKombinationB().bean2Atl(datum.getItem("KombinationB"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KombinationAGültig").isState()) {
								setKombinationAGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("KombinationAGültig").getText()));
							} else {
							setKombinationAGueltig(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("KombinationAGültig").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KombinationBGültig").isState()) {
								setKombinationBGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("KombinationBGültig").getText()));
							} else {
							setKombinationBGueltig(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("KombinationBGültig").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Logik").isState()) {
								setLogik(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
								.getZustand(daten.getScaledValue("Logik").getText()));
							} else {
							setLogik(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
							(daten.
								getUnscaledValue
							("Logik").
									byteValue
							()));
							}
					// AttributListenDefinition
						getKombinationA().atl2Bean(daten.getItem("KombinationA"), factory);
					// AttributListenDefinition
						getKombinationB().atl2Bean(daten.getItem("KombinationB"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setKombinationAGueltig(getKombinationAGueltig());
							klon.setKombinationBGueltig(getKombinationBGueltig());
							klon.setLogik(getLogik());
							klon._kombinationA = getKombinationA().clone();
							klon._kombinationB = getKombinationB().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaStrgDatenStausituationAlgorithmus7";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdNbaStrgDatenStausituationAlgorithmus7(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
