/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnisdaten Überwachung der Reisezeitprognose.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 40
 */
public class OdNbaUeberwachungReisezeitPrognose extends AbstractOnlineDatensatz<OdNbaUeberwachungReisezeitPrognose.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Analyse,
				};
			}
	
			/**
			 * Analysewerte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Analyse = new Aspekte("Analyse", "asp.analyse");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	Zeitstempel
				 _zeitstempel
				;
				private 	RelativerZeitstempel
				 _prognoseHorizont
				;
				private 	RelativerZeitstempel
				 _rZprog
				;
				private 	RelativerZeitstempel
				 _rZakt
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _abweichung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _abweichungProzent
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _grenzwert
				;
		
			/**
			Zeitstempel des geprüften Datensatzes.
			<p>
			
			</p>
			
			@return der Wert von Zeitstempel.
			*/
				public 	Zeitstempel
				 getZeitstempel() {
				return _zeitstempel;
			}
		
			/**
			Zeitstempel des geprüften Datensatzes.
			<p>
			
			</p>
			
			@param _zeitstempel der neue Wert von Zeitstempel.
			*/
			public void setZeitstempel(	Zeitstempel
			 _zeitstempel) {
				this._zeitstempel = _zeitstempel;
			}
		
			/**
			Prognosehorizont des Wertes.
			<p>
			
			</p>
			
			@return der Wert von PrognoseHorizont.
			*/
				public 	RelativerZeitstempel
				 getPrognoseHorizont() {
				return _prognoseHorizont;
			}
		
			/**
			Prognosehorizont des Wertes.
			<p>
			
			</p>
			
			@param _prognoseHorizont der neue Wert von PrognoseHorizont.
			*/
			public void setPrognoseHorizont(	RelativerZeitstempel
			 _prognoseHorizont) {
				this._prognoseHorizont = _prognoseHorizont;
			}
		
			/**
			Reisezeitprognose.
			<p>
			
			</p>
			
			@return der Wert von RZprog.
			*/
				public 	RelativerZeitstempel
				 getRZprog() {
				return _rZprog;
			}
		
			/**
			Reisezeitprognose.
			<p>
			
			</p>
			
			@param _rZprog der neue Wert von RZprog.
			*/
			public void setRZprog(	RelativerZeitstempel
			 _rZprog) {
				this._rZprog = _rZprog;
			}
		
			/**
			Reisezeit aktuell.
			<p>
			
			</p>
			
			@return der Wert von RZakt.
			*/
				public 	RelativerZeitstempel
				 getRZakt() {
				return _rZakt;
			}
		
			/**
			Reisezeit aktuell.
			<p>
			
			</p>
			
			@param _rZakt der neue Wert von RZakt.
			*/
			public void setRZakt(	RelativerZeitstempel
			 _rZakt) {
				this._rZakt = _rZakt;
			}
		
			/**
			Abweichung absolut.
			<p>
			
			</p>
			
			@return der Wert von Abweichung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAbweichung() {
				return _abweichung;
			}
		
			/**
			Abweichung absolut.
			<p>
			
			</p>
			
			@param _abweichung der neue Wert von Abweichung.
			*/
			public void setAbweichung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _abweichung) {
				this._abweichung = _abweichung;
			}
		
			/**
			Abweichung in Prozent.
			<p>
			
			</p>
			
			@return der Wert von AbweichungProzent.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAbweichungProzent() {
				return _abweichungProzent;
			}
		
			/**
			Abweichung in Prozent.
			<p>
			
			</p>
			
			@param _abweichungProzent der neue Wert von AbweichungProzent.
			*/
			public void setAbweichungProzent(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _abweichungProzent) {
				this._abweichungProzent = _abweichungProzent;
			}
		
			/**
			Grenzwert in Prozent.
			<p>
			
			</p>
			
			@return der Wert von Grenzwert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getGrenzwert() {
				return _grenzwert;
			}
		
			/**
			Grenzwert in Prozent.
			<p>
			
			</p>
			
			@param _grenzwert der neue Wert von Grenzwert.
			*/
			public void setGrenzwert(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _grenzwert) {
				this._grenzwert = _grenzwert;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("Zeitstempel").setMillis(getZeitstempel().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("PrognoseHorizont").setMillis(getPrognoseHorizont().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("RZprog").setMillis(getRZprog().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("RZakt").setMillis(getRZakt().getTime());
					// GanzzahlAttributTyp
					if (getAbweichung() != null) {
		                if (getAbweichung().isZustand()) {
		                    datum.getUnscaledValue("Abweichung").setText(getAbweichung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Abweichung").set(getAbweichung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbweichungProzent() != null) {
		                if (getAbweichungProzent().isZustand()) {
		                    datum.getUnscaledValue("AbweichungProzent").setText(getAbweichungProzent().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AbweichungProzent").set(getAbweichungProzent().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGrenzwert() != null) {
		                if (getGrenzwert().isZustand()) {
		                    datum.getUnscaledValue("Grenzwert").setText(getGrenzwert().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Grenzwert").set(getGrenzwert().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setZeitstempel(new
							Zeitstempel
							(daten.getTimeValue("Zeitstempel").getMillis()));
					// ZeitstempelAttributTyp
						setPrognoseHorizont(new
							RelativerZeitstempel
							(daten.getTimeValue("PrognoseHorizont").getMillis()));
					// ZeitstempelAttributTyp
						setRZprog(new
							RelativerZeitstempel
							(daten.getTimeValue("RZprog").getMillis()));
					// ZeitstempelAttributTyp
						setRZakt(new
							RelativerZeitstempel
							(daten.getTimeValue("RZakt").getMillis()));
					// GanzzahlAttributTyp
							setAbweichung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Abweichung").
									longValue
							()));
					// GanzzahlAttributTyp
							setAbweichungProzent(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("AbweichungProzent").
									longValue
							()));
					// GanzzahlAttributTyp
							setGrenzwert(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("Grenzwert").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setZeitstempel(getZeitstempel());
							klon.setPrognoseHorizont(getPrognoseHorizont());
							klon.setRZprog(getRZprog());
							klon.setRZakt(getRZakt());
							klon.setAbweichung(getAbweichung());
							klon.setAbweichungProzent(getAbweichungProzent());
							klon.setGrenzwert(getGrenzwert());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaUeberwachungReisezeitPrognose";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdNbaUeberwachungReisezeitPrognose(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
