/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Betriebs-Parameter des Entscheidungspunktes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class PdNbaEntscheidungspunktBetriebsParameter extends AbstractParameterDatensatz<PdNbaEntscheidungspunktBetriebsParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaEntscheidungspunktBetriebsart
				 _betriebsart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _stauanzeigeAktiv
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _baustellenanzeigeAktiv
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _unfallanzeigeAktiv
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Betriebsart des Entscheidungspunktes.
			<p>
			
			</p>
			
			@return der Wert von Betriebsart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaEntscheidungspunktBetriebsart
				 getBetriebsart() {
				return _betriebsart;
			}
		
			/**
			Betriebsart des Entscheidungspunktes.
			<p>
			
			</p>
			
			@param _betriebsart der neue Wert von Betriebsart.
			*/
			public void setBetriebsart(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaEntscheidungspunktBetriebsart
			 _betriebsart) {
				this._betriebsart = _betriebsart;
			}
		
			/**
			Festlegung, ob am Entscheidungspunkt Stauanzeigen erfolgen.
			<p>
			
			</p>
			
			@return der Wert von StauanzeigeAktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getStauanzeigeAktiv() {
				return _stauanzeigeAktiv;
			}
		
			/**
			Festlegung, ob am Entscheidungspunkt Stauanzeigen erfolgen.
			<p>
			
			</p>
			
			@param _stauanzeigeAktiv der neue Wert von StauanzeigeAktiv.
			*/
			public void setStauanzeigeAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _stauanzeigeAktiv) {
				this._stauanzeigeAktiv = _stauanzeigeAktiv;
			}
		
			/**
			Festlegung, ob am Entscheidungspunkt Baustellenanzeigen erfolgen.
			<p>
			
			</p>
			
			@return der Wert von BaustellenanzeigeAktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getBaustellenanzeigeAktiv() {
				return _baustellenanzeigeAktiv;
			}
		
			/**
			Festlegung, ob am Entscheidungspunkt Baustellenanzeigen erfolgen.
			<p>
			
			</p>
			
			@param _baustellenanzeigeAktiv der neue Wert von BaustellenanzeigeAktiv.
			*/
			public void setBaustellenanzeigeAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _baustellenanzeigeAktiv) {
				this._baustellenanzeigeAktiv = _baustellenanzeigeAktiv;
			}
		
			/**
			Festlegung, ob am Entscheidungspunkt Unfallanzeigen erfolgen.
			<p>
			
			</p>
			
			@return der Wert von UnfallanzeigeAktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getUnfallanzeigeAktiv() {
				return _unfallanzeigeAktiv;
			}
		
			/**
			Festlegung, ob am Entscheidungspunkt Unfallanzeigen erfolgen.
			<p>
			
			</p>
			
			@param _unfallanzeigeAktiv der neue Wert von UnfallanzeigeAktiv.
			*/
			public void setUnfallanzeigeAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _unfallanzeigeAktiv) {
				this._unfallanzeigeAktiv = _unfallanzeigeAktiv;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getBetriebsart() != null) {
		                if (getBetriebsart().isZustand()) {
		                    datum.getUnscaledValue("Betriebsart").setText(getBetriebsart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Betriebsart").set(getBetriebsart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStauanzeigeAktiv() != null) {
		                if (getStauanzeigeAktiv().isZustand()) {
		                    datum.getUnscaledValue("StauanzeigeAktiv").setText(getStauanzeigeAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StauanzeigeAktiv").set(getStauanzeigeAktiv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBaustellenanzeigeAktiv() != null) {
		                if (getBaustellenanzeigeAktiv().isZustand()) {
		                    datum.getUnscaledValue("BaustellenanzeigeAktiv").setText(getBaustellenanzeigeAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BaustellenanzeigeAktiv").set(getBaustellenanzeigeAktiv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getUnfallanzeigeAktiv() != null) {
		                if (getUnfallanzeigeAktiv().isZustand()) {
		                    datum.getUnscaledValue("UnfallanzeigeAktiv").setText(getUnfallanzeigeAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("UnfallanzeigeAktiv").set(getUnfallanzeigeAktiv().getValue());
		                }
					}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Betriebsart").isState()) {
								setBetriebsart(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaEntscheidungspunktBetriebsart
								.getZustand(daten.getScaledValue("Betriebsart").getText()));
							} else {
							setBetriebsart(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaEntscheidungspunktBetriebsart
							(daten.
								getUnscaledValue
							("Betriebsart").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("StauanzeigeAktiv").isState()) {
								setStauanzeigeAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("StauanzeigeAktiv").getText()));
							} else {
							setStauanzeigeAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("StauanzeigeAktiv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BaustellenanzeigeAktiv").isState()) {
								setBaustellenanzeigeAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("BaustellenanzeigeAktiv").getText()));
							} else {
							setBaustellenanzeigeAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("BaustellenanzeigeAktiv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("UnfallanzeigeAktiv").isState()) {
								setUnfallanzeigeAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("UnfallanzeigeAktiv").getText()));
							} else {
							setUnfallanzeigeAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("UnfallanzeigeAktiv").
									byteValue
							()));
							}
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setBetriebsart(getBetriebsart());
							klon.setStauanzeigeAktiv(getStauanzeigeAktiv());
							klon.setBaustellenanzeigeAktiv(getBaustellenanzeigeAktiv());
							klon.setUnfallanzeigeAktiv(getUnfallanzeigeAktiv());
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaEntscheidungspunktBetriebsParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdNbaEntscheidungspunktBetriebsParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
