/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Prioritäten für die Hinweisanzeige an den AnzeigeQuerschnitten des Entscheidungspunktes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class PdNbaEntscheidungspunktHinweisPrioritaet extends AbstractParameterDatensatz<PdNbaEntscheidungspunktHinweisPrioritaet.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
				 _stauanzeigePrioritaet
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
				 _baustellenanzeigePrioritaet
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
				 _unfallanzeigePrioritaet
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Priorität der Stauanzeigen am Entscheidungspunkt (höhere Zahl entspricht höherer Priorität).
			<p>
			
			</p>
			
			@return der Wert von StauanzeigePrioritaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
				 getStauanzeigePrioritaet() {
				return _stauanzeigePrioritaet;
			}
		
			/**
			Priorität der Stauanzeigen am Entscheidungspunkt (höhere Zahl entspricht höherer Priorität).
			<p>
			
			</p>
			
			@param _stauanzeigePrioritaet der neue Wert von StauanzeigePrioritaet.
			*/
			public void setStauanzeigePrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 _stauanzeigePrioritaet) {
				this._stauanzeigePrioritaet = _stauanzeigePrioritaet;
			}
		
			/**
			Priorität der Baustellenanzeigen am Entscheidungspunkt (höhere Zahl entspricht höherer Priorität).
			<p>
			
			</p>
			
			@return der Wert von BaustellenanzeigePrioritaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
				 getBaustellenanzeigePrioritaet() {
				return _baustellenanzeigePrioritaet;
			}
		
			/**
			Priorität der Baustellenanzeigen am Entscheidungspunkt (höhere Zahl entspricht höherer Priorität).
			<p>
			
			</p>
			
			@param _baustellenanzeigePrioritaet der neue Wert von BaustellenanzeigePrioritaet.
			*/
			public void setBaustellenanzeigePrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 _baustellenanzeigePrioritaet) {
				this._baustellenanzeigePrioritaet = _baustellenanzeigePrioritaet;
			}
		
			/**
			Priorität der Unfallanzeigeanzeigen am Entscheidungspunkt (höhere Zahl entspricht höherer Priorität).
			<p>
			
			</p>
			
			@return der Wert von UnfallanzeigePrioritaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
				 getUnfallanzeigePrioritaet() {
				return _unfallanzeigePrioritaet;
			}
		
			/**
			Priorität der Unfallanzeigeanzeigen am Entscheidungspunkt (höhere Zahl entspricht höherer Priorität).
			<p>
			
			</p>
			
			@param _unfallanzeigePrioritaet der neue Wert von UnfallanzeigePrioritaet.
			*/
			public void setUnfallanzeigePrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 _unfallanzeigePrioritaet) {
				this._unfallanzeigePrioritaet = _unfallanzeigePrioritaet;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getStauanzeigePrioritaet() != null) {
		                if (getStauanzeigePrioritaet().isZustand()) {
		                    datum.getUnscaledValue("StauanzeigePriorität").setText(getStauanzeigePrioritaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StauanzeigePriorität").set(getStauanzeigePrioritaet().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBaustellenanzeigePrioritaet() != null) {
		                if (getBaustellenanzeigePrioritaet().isZustand()) {
		                    datum.getUnscaledValue("BaustellenanzeigePriorität").setText(getBaustellenanzeigePrioritaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BaustellenanzeigePriorität").set(getBaustellenanzeigePrioritaet().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getUnfallanzeigePrioritaet() != null) {
		                if (getUnfallanzeigePrioritaet().isZustand()) {
		                    datum.getUnscaledValue("UnfallanzeigePriorität").setText(getUnfallanzeigePrioritaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("UnfallanzeigePriorität").set(getUnfallanzeigePrioritaet().getValue());
		                }
					}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("StauanzeigePriorität").isState()) {
								setStauanzeigePrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
								.getZustand(daten.getScaledValue("StauanzeigePriorität").getText()));
							} else {
							setStauanzeigePrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
							(daten.
								getUnscaledValue
							("StauanzeigePriorität").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BaustellenanzeigePriorität").isState()) {
								setBaustellenanzeigePrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
								.getZustand(daten.getScaledValue("BaustellenanzeigePriorität").getText()));
							} else {
							setBaustellenanzeigePrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
							(daten.
								getUnscaledValue
							("BaustellenanzeigePriorität").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("UnfallanzeigePriorität").isState()) {
								setUnfallanzeigePrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
								.getZustand(daten.getScaledValue("UnfallanzeigePriorität").getText()));
							} else {
							setUnfallanzeigePrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
							(daten.
								getUnscaledValue
							("UnfallanzeigePriorität").
									intValue
							()));
							}
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setStauanzeigePrioritaet(getStauanzeigePrioritaet());
							klon.setBaustellenanzeigePrioritaet(getBaustellenanzeigePrioritaet());
							klon.setUnfallanzeigePrioritaet(getUnfallanzeigePrioritaet());
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaEntscheidungspunktHinweisPriorität";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdNbaEntscheidungspunktHinweisPrioritaet(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
