/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für die Berechnung der Stauprognose.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class PdNbaParameterStauPrognose extends AbstractParameterDatensatz<PdNbaParameterStauPrognose.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _abstand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vMaxStau
				;
				private 	RelativerZeitstempel
				 _pzr
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _fzgLaenge
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer1
				 _tNettoStau
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Abstand von der Stauwurzel.
			<p>
			
			</p>
			
			@return der Wert von Abstand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getAbstand() {
				return _abstand;
			}
		
			/**
			Abstand von der Stauwurzel.
			<p>
			
			</p>
			
			@param _abstand der neue Wert von Abstand.
			*/
			public void setAbstand(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _abstand) {
				this._abstand = _abstand;
			}
		
			/**
			maximale Geschwindigkeit im Stau.
			<p>
			
			</p>
			
			@return der Wert von VMaxStau.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVMaxStau() {
				return _vMaxStau;
			}
		
			/**
			maximale Geschwindigkeit im Stau.
			<p>
			
			</p>
			
			@param _vMaxStau der neue Wert von VMaxStau.
			*/
			public void setVMaxStau(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vMaxStau) {
				this._vMaxStau = _vMaxStau;
			}
		
			/**
			Prognosezeitraum.
			<p>
			
			</p>
			
			@return der Wert von Pzr.
			*/
				public 	RelativerZeitstempel
				 getPzr() {
				return _pzr;
			}
		
			/**
			Prognosezeitraum.
			<p>
			
			</p>
			
			@param _pzr der neue Wert von Pzr.
			*/
			public void setPzr(	RelativerZeitstempel
			 _pzr) {
				this._pzr = _pzr;
			}
		
			/**
			durchschnittliche Fahrzeuglänge.
			<p>
			
			</p>
			
			@return der Wert von FzgLaenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getFzgLaenge() {
				return _fzgLaenge;
			}
		
			/**
			durchschnittliche Fahrzeuglänge.
			<p>
			
			</p>
			
			@param _fzgLaenge der neue Wert von FzgLaenge.
			*/
			public void setFzgLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _fzgLaenge) {
				this._fzgLaenge = _fzgLaenge;
			}
		
			/**
			durchschnittliche Nettozeitlücke im Stau.
			<p>
			
			</p>
			
			@return der Wert von TNettoStau.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer1
				 getTNettoStau() {
				return _tNettoStau;
			}
		
			/**
			durchschnittliche Nettozeitlücke im Stau.
			<p>
			
			</p>
			
			@param _tNettoStau der neue Wert von TNettoStau.
			*/
			public void setTNettoStau(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer1
			 _tNettoStau) {
				this._tNettoStau = _tNettoStau;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getAbstand() != null) {
		                if (getAbstand().isZustand()) {
		                    datum.getUnscaledValue("Abstand").setText(getAbstand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Abstand").set(getAbstand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVMaxStau() != null) {
		                if (getVMaxStau().isZustand()) {
		                    datum.getUnscaledValue("vMaxStau").setText(getVMaxStau().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vMaxStau").set(getVMaxStau().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Pzr").setMillis(getPzr().getTime());
					// GanzzahlAttributTyp
					if (getFzgLaenge() != null) {
		                if (getFzgLaenge().isZustand()) {
		                    datum.getUnscaledValue("FzgLänge").setText(getFzgLaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FzgLänge").set(getFzgLaenge().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTNettoStau() != null) {
		                if (getTNettoStau().isZustand()) {
		                    datum.getUnscaledValue("tNettoStau").setText(getTNettoStau().toString());
		                } else {
							datum.
							getScaledValue
		                	("tNettoStau").set(getTNettoStau().getValue());
		                }
					}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Abstand").isState()) {
								setAbstand(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("Abstand").getText()));
							} else {
							setAbstand(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("Abstand").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vMaxStau").isState()) {
								setVMaxStau(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vMaxStau").getText()));
							} else {
							setVMaxStau(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vMaxStau").
									shortValue
							()));
							}
					// ZeitstempelAttributTyp
						setPzr(new
							RelativerZeitstempel
							(daten.getTimeValue("Pzr").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FzgLänge").isState()) {
								setFzgLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("FzgLänge").getText()));
							} else {
							setFzgLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("FzgLänge").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("tNettoStau").isState()) {
								setTNettoStau(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer1
								.getZustand(daten.getScaledValue("tNettoStau").getText()));
							} else {
							setTNettoStau(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer1
							(daten.
								getScaledValue
							("tNettoStau").
								doubleValue
							()));
							}
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbstand(getAbstand());
							klon.setVMaxStau(getVMaxStau());
							klon.setPzr(getPzr());
							klon.setFzgLaenge(getFzgLaenge());
							klon.setTNettoStau(getTNettoStau());
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaParameterStauPrognose";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdNbaParameterStauPrognose(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
