/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für die Stauanalyse.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class PdNbaParameterStauanalyse extends AbstractParameterDatensatz<PdNbaParameterStauanalyse.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _intervalldauer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _laengeMinute
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _abstandNachbar
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _abstandStau
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _abstandKeinStau
				;
				private 	RelativerZeitstempel
				 _timeoutTrennung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
				 _guete
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Intervalldauer für die Bestimmung der Stauanalyse. In jedem Zyklus wird die Liste der Stauobjekte neu bestimmt.
			<p>
			
			</p>
			
			@return der Wert von Intervalldauer.
			*/
				public 	RelativerZeitstempel
				 getIntervalldauer() {
				return _intervalldauer;
			}
		
			/**
			Intervalldauer für die Bestimmung der Stauanalyse. In jedem Zyklus wird die Liste der Stauobjekte neu bestimmt.
			<p>
			
			</p>
			
			@param _intervalldauer der neue Wert von Intervalldauer.
			*/
			public void setIntervalldauer(	RelativerZeitstempel
			 _intervalldauer) {
				this._intervalldauer = _intervalldauer;
			}
		
			/**
			Länge pro Minute der Intervalldauer zur Bestimmung der Anfangsstaulänge.
			<p>
			
			</p>
			
			@return der Wert von LaengeMinute.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getLaengeMinute() {
				return _laengeMinute;
			}
		
			/**
			Länge pro Minute der Intervalldauer zur Bestimmung der Anfangsstaulänge.
			<p>
			
			</p>
			
			@param _laengeMinute der neue Wert von LaengeMinute.
			*/
			public void setLaengeMinute(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laengeMinute) {
				this._laengeMinute = _laengeMinute;
			}
		
			/**
			Grenzwert Abstand zum Nachbar.
			<p>
			
			</p>
			
			@return der Wert von AbstandNachbar.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getAbstandNachbar() {
				return _abstandNachbar;
			}
		
			/**
			Grenzwert Abstand zum Nachbar.
			<p>
			
			</p>
			
			@param _abstandNachbar der neue Wert von AbstandNachbar.
			*/
			public void setAbstandNachbar(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _abstandNachbar) {
				this._abstandNachbar = _abstandNachbar;
			}
		
			/**
			Grenzwert Abstand zum prognostizierten Stau.
			<p>
			
			</p>
			
			@return der Wert von AbstandStau.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getAbstandStau() {
				return _abstandStau;
			}
		
			/**
			Grenzwert Abstand zum prognostizierten Stau.
			<p>
			
			</p>
			
			@param _abstandStau der neue Wert von AbstandStau.
			*/
			public void setAbstandStau(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _abstandStau) {
				this._abstandStau = _abstandStau;
			}
		
			/**
			Grenzwert Abstand zum Stauindikator mit freiem Verkehr.
			<p>
			
			</p>
			
			@return der Wert von AbstandKeinStau.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getAbstandKeinStau() {
				return _abstandKeinStau;
			}
		
			/**
			Grenzwert Abstand zum Stauindikator mit freiem Verkehr.
			<p>
			
			</p>
			
			@param _abstandKeinStau der neue Wert von AbstandKeinStau.
			*/
			public void setAbstandKeinStau(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _abstandKeinStau) {
				this._abstandKeinStau = _abstandKeinStau;
			}
		
			/**
			Timeout für die Trennung von Stauobjekten.
			<p>
			
			</p>
			
			@return der Wert von TimeoutTrennung.
			*/
				public 	RelativerZeitstempel
				 getTimeoutTrennung() {
				return _timeoutTrennung;
			}
		
			/**
			Timeout für die Trennung von Stauobjekten.
			<p>
			
			</p>
			
			@param _timeoutTrennung der neue Wert von TimeoutTrennung.
			*/
			public void setTimeoutTrennung(	RelativerZeitstempel
			 _timeoutTrennung) {
				this._timeoutTrennung = _timeoutTrennung;
			}
		
			/**
			Grenzwert Güte für den Stauindikator.
			<p>
			
			</p>
			
			@return der Wert von Guete.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
				 getGuete() {
				return _guete;
			}
		
			/**
			Grenzwert Güte für den Stauindikator.
			<p>
			
			</p>
			
			@param _guete der neue Wert von Guete.
			*/
			public void setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 _guete) {
				this._guete = _guete;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("Intervalldauer").setMillis(getIntervalldauer().getTime());
					// GanzzahlAttributTyp
					if (getLaengeMinute() != null) {
		                if (getLaengeMinute().isZustand()) {
		                    datum.getUnscaledValue("LängeMinute").setText(getLaengeMinute().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LängeMinute").set(getLaengeMinute().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbstandNachbar() != null) {
		                if (getAbstandNachbar().isZustand()) {
		                    datum.getUnscaledValue("AbstandNachbar").setText(getAbstandNachbar().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AbstandNachbar").set(getAbstandNachbar().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbstandStau() != null) {
		                if (getAbstandStau().isZustand()) {
		                    datum.getUnscaledValue("AbstandStau").setText(getAbstandStau().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AbstandStau").set(getAbstandStau().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbstandKeinStau() != null) {
		                if (getAbstandKeinStau().isZustand()) {
		                    datum.getUnscaledValue("AbstandKeinStau").setText(getAbstandKeinStau().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AbstandKeinStau").set(getAbstandKeinStau().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("TimeoutTrennung").setMillis(getTimeoutTrennung().getTime());
					// GanzzahlAttributTyp
					if (getGuete() != null) {
		                if (getGuete().isZustand()) {
		                    datum.getUnscaledValue("Güte").setText(getGuete().toString());
		                } else {
							datum.
							getScaledValue
		                	("Güte").set(getGuete().getValue());
		                }
					}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setIntervalldauer(new
							RelativerZeitstempel
							(daten.getTimeValue("Intervalldauer").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LängeMinute").isState()) {
								setLaengeMinute(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("LängeMinute").getText()));
							} else {
							setLaengeMinute(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("LängeMinute").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AbstandNachbar").isState()) {
								setAbstandNachbar(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("AbstandNachbar").getText()));
							} else {
							setAbstandNachbar(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("AbstandNachbar").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AbstandStau").isState()) {
								setAbstandStau(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("AbstandStau").getText()));
							} else {
							setAbstandStau(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("AbstandStau").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AbstandKeinStau").isState()) {
								setAbstandKeinStau(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("AbstandKeinStau").getText()));
							} else {
							setAbstandKeinStau(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("AbstandKeinStau").
									longValue
							()));
							}
					// ZeitstempelAttributTyp
						setTimeoutTrennung(new
							RelativerZeitstempel
							(daten.getTimeValue("TimeoutTrennung").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Güte").isState()) {
								setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
								.getZustand(daten.getScaledValue("Güte").getText()));
							} else {
							setGuete(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
							(daten.
								getScaledValue
							("Güte").
								doubleValue
							()));
							}
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setIntervalldauer(getIntervalldauer());
							klon.setLaengeMinute(getLaengeMinute());
							klon.setAbstandNachbar(getAbstandNachbar());
							klon.setAbstandStau(getAbstandStau());
							klon.setAbstandKeinStau(getAbstandKeinStau());
							klon.setTimeoutTrennung(getTimeoutTrennung());
							klon.setGuete(getGuete());
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaParameterStauanalyse";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdNbaParameterStauanalyse(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
