/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Speicherung der Ergebnisdaten Ursacheneinheit.
<p>
&lt;absatz&gt;
						Attributgruppe zur Speicherung der Ergebnisdaten pro Ursacheneinheit
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class PdNbaUeSchaltbild extends AbstractParameterDatensatz<PdNbaUeSchaltbild.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.MischerBefehle,
					Aspekte.Handschaltung,
					Aspekte.Sonderprogramm,
					Aspekte.AutomatikAlgorithmus4,
					Aspekte.AutomatikAlgorithmus5,
					Aspekte.AutomatikAlgorithmus7,
					Aspekte.HandschaltungVorgabe,
					Aspekte.AutomatikAlgorithmus2,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.AutomatikAlgorithmus1,
					Aspekte.MischerLokal,
					Aspekte.ParameterVorgabe,
					Aspekte.AutomatikAlgorithmus3,
					Aspekte.AutomatikAlgorithmus6,
					Aspekte.MischerNetz,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Ergebnis Mischer gesamt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MischerBefehle = new Aspekte("MischerBefehle", "asp.mischerBefehle");
			
			/**
			 * Handschaltung durch Bedienrechner.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Handschaltung = new Aspekte("Handschaltung", "asp.handschaltung");
			
			/**
			 * Sonderprogramm.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Sonderprogramm = new Aspekte("Sonderprogramm", "asp.sonderprogramm");
			
			/**
			 * Automatik Steuerlogik Algorithmus 4.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AutomatikAlgorithmus4 = new Aspekte("AutomatikAlgorithmus4", "asp.automatikAlgorithmus4");
			
			/**
			 * Automatik Steuerlogik Algorithmus 5.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AutomatikAlgorithmus5 = new Aspekte("AutomatikAlgorithmus5", "asp.automatikAlgorithmus5");
			
			/**
			 * Automatik Steuerlogik Algorithmus 7.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AutomatikAlgorithmus7 = new Aspekte("AutomatikAlgorithmus7", "asp.automatikAlgorithmus7");
			
			/**
			 * Handeingriff Vorgabe, Rückmeldung an Bedienrechner.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt HandschaltungVorgabe = new Aspekte("HandschaltungVorgabe", "asp.handschaltungVorgabe");
			
			/**
			 * Automatik Steuerlogik Algorithmus 2.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AutomatikAlgorithmus2 = new Aspekte("AutomatikAlgorithmus2", "asp.automatikAlgorithmus2");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Automatik Steuerlogik Algorithmus 1.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AutomatikAlgorithmus1 = new Aspekte("AutomatikAlgorithmus1", "asp.automatikAlgorithmus1");
			
			/**
			 * Ergebnis Mischer lokale Beeinflussung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MischerLokal = new Aspekte("MischerLokal", "asp.mischerLokal");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Automatik Steuerlogik Algorithmus 3.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AutomatikAlgorithmus3 = new Aspekte("AutomatikAlgorithmus3", "asp.automatikAlgorithmus3");
			
			/**
			 * Automatik Steuerlogik Algorithmus 6.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AutomatikAlgorithmus6 = new Aspekte("AutomatikAlgorithmus6", "asp.automatikAlgorithmus6");
			
			/**
			 * Ergebnis Mischer netzweite Beeinflussung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MischerNetz = new Aspekte("MischerNetz", "asp.mischerNetz");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUeSchaltbild
				> _anzeigen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUeSchaltbild
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Schaltbild der Ursacheneinheit.
			<p>
			
			</p>
			
			@return der Wert von Anzeigen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUeSchaltbild
				> getAnzeigen() {
				return _anzeigen;
			}
		
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasser Informationen.
			<p>
			
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayAnzeigen = datum.getArray("Anzeigen");
						arrayAnzeigen.setLength(getAnzeigen().size());
						for (int i = 0; i < arrayAnzeigen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUeSchaltbild
							 atl = getAnzeigen().get(i);
							atl.bean2Atl(arrayAnzeigen.getItem(i), factory);
		
						}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayAnzeigen = daten.getArray("Anzeigen");
						for (int i = 0; i < arrayAnzeigen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUeSchaltbild
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUeSchaltbild
							 ();
							atl.atl2Bean(arrayAnzeigen.getItem(i), factory);
							getAnzeigen().add(atl);
						}
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._anzeigen = getAnzeigen().clone();
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaUeSchaltbild";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdNbaUeSchaltbild(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
