/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Die Konfigurationsdaten eines Standorts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class KdStandort extends AbstractKonfigurationsDatensatz<KdStandort.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AttStandortArt
				 _standortArt
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				> _anzeigeQuerschnitte = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
				> _leeresProgramm = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
				>(0, true);
		
			/**
			Die Art des Standorts.
			<p>
			
			</p>
			
			@return der Wert von StandortArt.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AttStandortArt
				 getStandortArt() {
				return _standortArt;
			}
		
			/**
			Die Art des Standorts.
			<p>
			
			</p>
			
			@param _standortArt der neue Wert von StandortArt.
			*/
			public void setStandortArt(de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AttStandortArt
			 _standortArt) {
				this._standortArt = _standortArt;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.anzeigeQuerschnitt.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeQuerschnitte.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				> getAnzeigeQuerschnitte() {
				return _anzeigeQuerschnitte;
			}
		
		
			/**
			Ordnet einer Anzeige eine Anzeigeeigenschaft
								(Anzeigeinhalt) zu.
			<p>
			
			</p>
			
			@return der Wert von LeeresProgramm.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
				> getLeeresProgramm() {
				return _leeresProgramm;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getStandortArt() != null) {
		                if (getStandortArt().isZustand()) {
		                    datum.getUnscaledValue("StandortArt").setText(getStandortArt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StandortArt").set(getStandortArt().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAnzeigeQuerschnitte = datum.getReferenceArray("AnzeigeQuerschnitte");
						arrayAnzeigeQuerschnitte.setLength(getAnzeigeQuerschnitte().size());
						for (int i = 0; i < arrayAnzeigeQuerschnitte.getLength(); ++i) {
							final Object soAnzeigeQuerschnitte = getAnzeigeQuerschnitte().get(i);
							final SystemObject tmpAnzeigeQuerschnitte;
							if (soAnzeigeQuerschnitte instanceof SystemObject) {
								tmpAnzeigeQuerschnitte = (SystemObject)soAnzeigeQuerschnitte;
							} else if(soAnzeigeQuerschnitte instanceof SystemObjekt){
								tmpAnzeigeQuerschnitte = ((SystemObjekt)soAnzeigeQuerschnitte).getSystemObject();
							} else{
								tmpAnzeigeQuerschnitte = null;
							}
							arrayAnzeigeQuerschnitte.getReferenceValue(i).setSystemObject(tmpAnzeigeQuerschnitte);
						}
					// AttributListenDefinition
						final Data.Array arrayLeeresProgramm = datum.getArray("LeeresProgramm");
						arrayLeeresProgramm.setLength(getLeeresProgramm().size());
						for (int i = 0; i < arrayLeeresProgramm.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
							 atl = getLeeresProgramm().get(i);
							atl.bean2Atl(arrayLeeresProgramm.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("StandortArt").isState()) {
								setStandortArt(de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AttStandortArt
								.getZustand(daten.getScaledValue("StandortArt").getText()));
							} else {
							setStandortArt(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AttStandortArt
							(daten.
								getUnscaledValue
							("StandortArt").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAnzeigeQuerschnitte = daten.getReferenceArray("AnzeigeQuerschnitte");
						for (int i = 0; i < arrayAnzeigeQuerschnitte.getLength(); ++i) {
							final long idAnzeigeQuerschnitte = daten.getReferenceArray("AnzeigeQuerschnitte").getReferenceValue(i).getId();
							final SystemObjekt tmpAnzeigeQuerschnitte;
							if (idAnzeigeQuerschnitte == 0) {
								tmpAnzeigeQuerschnitte = null;
							} else {
								final SystemObject soAnzeigeQuerschnitte = factory.getDav().getDataModel().getObject(idAnzeigeQuerschnitte);
								if (soAnzeigeQuerschnitte == null) {
										tmpAnzeigeQuerschnitte = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeQuerschnittUngueltig(idAnzeigeQuerschnitte);
								} else {
									tmpAnzeigeQuerschnitte = factory.getModellobjekt(soAnzeigeQuerschnitte);
								}
							}
								getAnzeigeQuerschnitte().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
								) tmpAnzeigeQuerschnitte);
						}
					// AttributListenDefinition
						final Data.Array arrayLeeresProgramm = daten.getArray("LeeresProgramm");
						for (int i = 0; i < arrayLeeresProgramm.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanprogramm.attribute.AtlNbaProgrammAnzeigeEigenschaft
							 ();
							atl.atl2Bean(arrayLeeresProgramm.getItem(i), factory);
							getLeeresProgramm().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setStandortArt(getStandortArt());
						klon._anzeigeQuerschnitte = getAnzeigeQuerschnitte().clone();
						klon._leeresProgramm = getLeeresProgramm().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.standort";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdStandort(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
