/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahanschaltung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Befehl an den NBA-Schaltprogrammserver.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AttNbaSchaltBefehl extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	ein Programm soll angelegt werden.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltBefehl ZUSTAND_1_ANLEGEN = new AttNbaSchaltBefehl("Anlegen", 		Byte
	.valueOf("1"));

	/**
	Eine deaktivierte Schaltung wieder online gehen lassen.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltBefehl ZUSTAND_2_SPEICHERN = new AttNbaSchaltBefehl("Speichern", 		Byte
	.valueOf("2"));

	/**
	Loescht die Programmschaltung mit der uebergebenen ID
								komplett.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltBefehl ZUSTAND_3_LOESCHEN = new AttNbaSchaltBefehl("Loeschen", 		Byte
	.valueOf("3"));

	/**
	Aktiviert die Programmschaltung mit der uebergebenen ID,
								wenn es möglich ist.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltBefehl ZUSTAND_4_AKTIVIEREN = new AttNbaSchaltBefehl("Aktivieren", 		Byte
	.valueOf("4"));

	/**
	Deaktiviert die Programmschaltung mit der uebergebenen ID,
								wenn es möglich ist.
	<p>
	
	</p>
	*/
	public static final AttNbaSchaltBefehl ZUSTAND_5_DEAKTIVIEREN = new AttNbaSchaltBefehl("Deaktivieren", 		Byte
	.valueOf("5"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttNbaSchaltBefehl getZustand(final 		Byte
	 value) {
		for (AttNbaSchaltBefehl e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttNbaSchaltBefehl getZustand(final String value) {
		for (AttNbaSchaltBefehl e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttNbaSchaltBefehl> getZustaende() {
		List<AttNbaSchaltBefehl> list = new ArrayList<AttNbaSchaltBefehl>();
		list.add(ZUSTAND_1_ANLEGEN);
		list.add(ZUSTAND_2_SPEICHERN);
		list.add(ZUSTAND_3_LOESCHEN);
		list.add(ZUSTAND_4_AKTIVIEREN);
		list.add(ZUSTAND_5_DEAKTIVIEREN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut NbaSchaltBefehl.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttNbaSchaltBefehl(final 		Byte
	 value) {
		super(value);
	}
	
	private AttNbaSchaltBefehl(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
