/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbahansymbole.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ein WZG-Grafikinhalt fuer ein dynamisch versorgbares
					(Symbol-) Bild.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface WzgInhaltGrafikSymbol extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WzgInhaltGrafik
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.wzgInhaltGrafikSymbol"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz WzgInhaltGrafik.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdWzgInhaltGrafik getKdWzgInhaltGrafik();
	
	/**
	Ueber diese Parameterattributgruppe koennen (Symbol-Name,
						Symbol-Bitmap)-Tupels
						jeweils pro Objekt vom Typ
						typ.wzgInhaltGrafikSymbol bzw. implizit pro
						WVZ-Inhalt
						(und damit pro
						Schaltcode) abgespeichert werden. Ein sog.
						Symbolsynchronisierungs-Server ist parallel
						auf diese Attributgruppe
						(Parametervorgabe) angemeldet und übernimmt
						die Versorgung
						der
						Streckenstation bzw. DE mit dem entsprechenden Symbol (also den
						Upload des Bildes
						auf die Streckenstation und die
						Schaltcode-Bild-Name-Assoziation).
	<p>
	
	</p>
	@return der Datensatz WzgInhaltGrafikSymbol.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahansymbole.parameter.PdWzgInhaltGrafikSymbol getPdWzgInhaltGrafikSymbol();
	
	/**
	Gibt den Versorgungszustand der Streckenstation mit dem
						aktuell parametrierten Bild	an.
	<p>
	
	</p>
	@return der Datensatz WzgInhaltGrafikSymbolVersorgungsZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbahansymbole.onlinedaten.OdWzgInhaltGrafikSymbolVersorgungsZustand getOdWzgInhaltGrafikSymbolVersorgungsZustand();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
