/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält alle Prozesse.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlProzess implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _prozessID
			= new String
			()
			;
			private String
			 _name
			= new String
			()
			;
			private String
			 _ausfuehrbareDatei
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlMakros
			> _makros = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlMakros
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlAufrufParameter
			> _aufrufParameter = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlAufrufParameter
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartArt
			 _startArt
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartArt
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartBedingung
			> _startBedingung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartBedingung
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStoppBedingung
			> _stoppBedingung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStoppBedingung
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStandardAusgabe
			 _standardAusgabe
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStandardAusgabe
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlFehlerAusgabe
			 _fehlerAusgabe
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlFehlerAusgabe
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartVerhaltenFehler
			 _startVerhaltenFehler
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartVerhaltenFehler
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStoppVerhaltenFehler
			 _stoppVerhaltenFehler
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStoppVerhaltenFehler
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _simulationsVariante
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
			 _zustand
			;
			private String
			 _startZeitpunkt
			= new String
			()
			;
			private String
			 _stoppZeitpunkt
			= new String
			()
			;
			private String
			 _initialisierungsZeitpunkt
			= new String
			()
			;
			private String
			 _naechsterStartZeitpunkt
			= new String
			()
			;
	
		/**
		Id des Prozesses.
		<p>
		
		</p>
		
		@return der Wert von ProzessID.
		*/
			public String
			 getProzessID() {
			return _prozessID;
		}
	
		/**
		Id des Prozesses.
		<p>
		
		</p>
		
		@param _prozessID der neue Wert von ProzessID.
		*/
		public void setProzessID(String
		 _prozessID) {
			if (_prozessID.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._prozessID = _prozessID;
		}
	
		/**
		Name der Anwendung oder einer Anwendungsgruppe.
		                    Wichtig für den Start des Kernsystems: 
		                    Alle Anwendungen die für das Kernsystem gebraucht werden, 
		                    müssen mit diesem Namen versehen werden.
		                    Diese Gruppe wird dann als erstes gestartet.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name der Anwendung oder einer Anwendungsgruppe.
		                    Wichtig für den Start des Kernsystems: 
		                    Alle Anwendungen die für das Kernsystem gebraucht werden, 
		                    müssen mit diesem Namen versehen werden.
		                    Diese Gruppe wird dann als erstes gestartet.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Pfad und Dateiname der auszuführenden Datei.
		<p>
		
		</p>
		
		@return der Wert von AusfuehrbareDatei.
		*/
			public String
			 getAusfuehrbareDatei() {
			return _ausfuehrbareDatei;
		}
	
		/**
		Pfad und Dateiname der auszuführenden Datei.
		<p>
		
		</p>
		
		@param _ausfuehrbareDatei der neue Wert von AusfuehrbareDatei.
		*/
		public void setAusfuehrbareDatei(String
		 _ausfuehrbareDatei) {
			if (_ausfuehrbareDatei.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._ausfuehrbareDatei = _ausfuehrbareDatei;
		}
	
		/**
		Beliebige Anzahl von Makroreferenzierungen auf Makros im globalen Teil.
		<p>
		
		</p>
		
		@return der Wert von Makros.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlMakros
			> getMakros() {
			return _makros;
		}
	
	
		/**
		Beliebige Anzahl von Aufrufparametern für diese Anwendung.
		<p>
		
		</p>
		
		@return der Wert von AufrufParameter.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlAufrufParameter
			> getAufrufParameter() {
			return _aufrufParameter;
		}
	
	
		/**
		Info zu Art des Startens(AUTOMATISCH;INTERVALL;MANUELL), Feritgmeldung (ja&#47;nain), Neustart(ja&#47;nein).
		<p>
		
		</p>
		
		@return der Wert von StartArt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartArt
			 getStartArt() {
			return _startArt;
		}
	
		/**
		Info zu Art des Startens(AUTOMATISCH;INTERVALL;MANUELL), Feritgmeldung (ja&#47;nain), Neustart(ja&#47;nein).
		<p>
		
		</p>
		
		@param _startArt der neue Wert von StartArt.
		*/
		public void setStartArt(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartArt
		 _startArt) {
			this._startArt = _startArt;
		}
	
		/**
		Hier wird mitgetilt unter welchen Bedingungen die Applikation starten darf.
		<p>
		
		</p>
		
		@return der Wert von StartBedingung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartBedingung
			> getStartBedingung() {
			return _startBedingung;
		}
	
	
		/**
		Hier wird mitgetilt unter welchen Bedingungen die Applikation starten darf.
		<p>
		
		</p>
		
		@return der Wert von StoppBedingung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStoppBedingung
			> getStoppBedingung() {
			return _stoppBedingung;
		}
	
	
		/**
		Einstellung der Standardausgabe.
		<p>
		
		</p>
		
		@return der Wert von StandardAusgabe.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStandardAusgabe
			 getStandardAusgabe() {
			return _standardAusgabe;
		}
	
		/**
		Einstellung der Standardausgabe.
		<p>
		
		</p>
		
		@param _standardAusgabe der neue Wert von StandardAusgabe.
		*/
		public void setStandardAusgabe(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStandardAusgabe
		 _standardAusgabe) {
			this._standardAusgabe = _standardAusgabe;
		}
	
		/**
		Einstellung der StandardFehlerausgabe.
		<p>
		
		</p>
		
		@return der Wert von FehlerAusgabe.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlFehlerAusgabe
			 getFehlerAusgabe() {
			return _fehlerAusgabe;
		}
	
		/**
		Einstellung der StandardFehlerausgabe.
		<p>
		
		</p>
		
		@param _fehlerAusgabe der neue Wert von FehlerAusgabe.
		*/
		public void setFehlerAusgabe(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlFehlerAusgabe
		 _fehlerAusgabe) {
			this._fehlerAusgabe = _fehlerAusgabe;
		}
	
		/**
		Einstellung des Verhaltens bei Fehler während des Startvorgangs.
		<p>
		
		</p>
		
		@return der Wert von StartVerhaltenFehler.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartVerhaltenFehler
			 getStartVerhaltenFehler() {
			return _startVerhaltenFehler;
		}
	
		/**
		Einstellung des Verhaltens bei Fehler während des Startvorgangs.
		<p>
		
		</p>
		
		@param _startVerhaltenFehler der neue Wert von StartVerhaltenFehler.
		*/
		public void setStartVerhaltenFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartVerhaltenFehler
		 _startVerhaltenFehler) {
			this._startVerhaltenFehler = _startVerhaltenFehler;
		}
	
		/**
		Einstellung des Verhaltens bei Fehler während des Stoppvorgangs.
		<p>
		
		</p>
		
		@return der Wert von StoppVerhaltenFehler.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStoppVerhaltenFehler
			 getStoppVerhaltenFehler() {
			return _stoppVerhaltenFehler;
		}
	
		/**
		Einstellung des Verhaltens bei Fehler während des Stoppvorgangs.
		<p>
		
		</p>
		
		@param _stoppVerhaltenFehler der neue Wert von StoppVerhaltenFehler.
		*/
		public void setStoppVerhaltenFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStoppVerhaltenFehler
		 _stoppVerhaltenFehler) {
			this._stoppVerhaltenFehler = _stoppVerhaltenFehler;
		}
	
		/**
		Nummer der Simulation einer Anwendung. "0" ist die Normale Anwendung.
		<p>
		
		</p>
		
		@return der Wert von SimulationsVariante.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getSimulationsVariante() {
			return _simulationsVariante;
		}
	
		/**
		Nummer der Simulation einer Anwendung. "0" ist die Normale Anwendung.
		<p>
		
		</p>
		
		@param _simulationsVariante der neue Wert von SimulationsVariante.
		*/
		public void setSimulationsVariante(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _simulationsVariante) {
			this._simulationsVariante = _simulationsVariante;
		}
	
		/**
		Zustand der Applikation.
		<p>
		
		</p>
		
		@return der Wert von Zustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
			 getZustand() {
			return _zustand;
		}
	
		/**
		Zustand der Applikation.
		<p>
		
		</p>
		
		@param _zustand der neue Wert von Zustand.
		*/
		public void setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
		 _zustand) {
			this._zustand = _zustand;
		}
	
		/**
		Startzeitpunkt der Anwendung.
		<p>
		
		</p>
		
		@return der Wert von StartZeitpunkt.
		*/
			public String
			 getStartZeitpunkt() {
			return _startZeitpunkt;
		}
	
		/**
		Startzeitpunkt der Anwendung.
		<p>
		
		</p>
		
		@param _startZeitpunkt der neue Wert von StartZeitpunkt.
		*/
		public void setStartZeitpunkt(String
		 _startZeitpunkt) {
			if (_startZeitpunkt.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._startZeitpunkt = _startZeitpunkt;
		}
	
		/**
		Stoppzeitpunkt der Anwendung.
		<p>
		
		</p>
		
		@return der Wert von StoppZeitpunkt.
		*/
			public String
			 getStoppZeitpunkt() {
			return _stoppZeitpunkt;
		}
	
		/**
		Stoppzeitpunkt der Anwendung.
		<p>
		
		</p>
		
		@param _stoppZeitpunkt der neue Wert von StoppZeitpunkt.
		*/
		public void setStoppZeitpunkt(String
		 _stoppZeitpunkt) {
			if (_stoppZeitpunkt.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._stoppZeitpunkt = _stoppZeitpunkt;
		}
	
		/**
		Initialisierungszeitpunkt der Anwendung.
		<p>
		
		</p>
		
		@return der Wert von InitialisierungsZeitpunkt.
		*/
			public String
			 getInitialisierungsZeitpunkt() {
			return _initialisierungsZeitpunkt;
		}
	
		/**
		Initialisierungszeitpunkt der Anwendung.
		<p>
		
		</p>
		
		@param _initialisierungsZeitpunkt der neue Wert von InitialisierungsZeitpunkt.
		*/
		public void setInitialisierungsZeitpunkt(String
		 _initialisierungsZeitpunkt) {
			if (_initialisierungsZeitpunkt.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._initialisierungsZeitpunkt = _initialisierungsZeitpunkt;
		}
	
		/**
		nächster Startzeitpunkt der Anwendung (nur bei Startart Intervall).
		<p>
		
		</p>
		
		@return der Wert von NaechsterStartZeitpunkt.
		*/
			public String
			 getNaechsterStartZeitpunkt() {
			return _naechsterStartZeitpunkt;
		}
	
		/**
		nächster Startzeitpunkt der Anwendung (nur bei Startart Intervall).
		<p>
		
		</p>
		
		@param _naechsterStartZeitpunkt der neue Wert von NaechsterStartZeitpunkt.
		*/
		public void setNaechsterStartZeitpunkt(String
		 _naechsterStartZeitpunkt) {
			if (_naechsterStartZeitpunkt.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._naechsterStartZeitpunkt = _naechsterStartZeitpunkt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getProzessID() != null) {
					datum.getTextValue("ProzessID").setText(getProzessID());
				}
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ZeichenkettenAttributTyp
				if (getAusfuehrbareDatei() != null) {
					datum.getTextValue("AusfuehrbareDatei").setText(getAusfuehrbareDatei());
				}
				// AttributListenDefinition
					final Data.Array arrayMakros = datum.getArray("Makros");
					arrayMakros.setLength(getMakros().size());
					for (int i = 0; i < arrayMakros.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlMakros
						 atl = getMakros().get(i);
						atl.bean2Atl(arrayMakros.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayAufrufParameter = datum.getArray("AufrufParameter");
					arrayAufrufParameter.setLength(getAufrufParameter().size());
					for (int i = 0; i < arrayAufrufParameter.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlAufrufParameter
						 atl = getAufrufParameter().get(i);
						atl.bean2Atl(arrayAufrufParameter.getItem(i), factory);
	
					}
				// AttributListenDefinition
					getStartArt().bean2Atl(datum.getItem("StartArt"), factory);
				// AttributListenDefinition
					final Data.Array arrayStartBedingung = datum.getArray("StartBedingung");
					arrayStartBedingung.setLength(getStartBedingung().size());
					for (int i = 0; i < arrayStartBedingung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartBedingung
						 atl = getStartBedingung().get(i);
						atl.bean2Atl(arrayStartBedingung.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayStoppBedingung = datum.getArray("StoppBedingung");
					arrayStoppBedingung.setLength(getStoppBedingung().size());
					for (int i = 0; i < arrayStoppBedingung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStoppBedingung
						 atl = getStoppBedingung().get(i);
						atl.bean2Atl(arrayStoppBedingung.getItem(i), factory);
	
					}
				// AttributListenDefinition
					getStandardAusgabe().bean2Atl(datum.getItem("StandardAusgabe"), factory);
				// AttributListenDefinition
					getFehlerAusgabe().bean2Atl(datum.getItem("FehlerAusgabe"), factory);
				// AttributListenDefinition
					getStartVerhaltenFehler().bean2Atl(datum.getItem("StartVerhaltenFehler"), factory);
				// AttributListenDefinition
					getStoppVerhaltenFehler().bean2Atl(datum.getItem("StoppVerhaltenFehler"), factory);
				// GanzzahlAttributTyp
				if (getSimulationsVariante() != null) {
	                if (getSimulationsVariante().isZustand()) {
	                    datum.getUnscaledValue("SimulationsVariante").setText(getSimulationsVariante().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SimulationsVariante").set(getSimulationsVariante().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZustand() != null) {
	                if (getZustand().isZustand()) {
	                    datum.getUnscaledValue("Zustand").setText(getZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zustand").set(getZustand().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getStartZeitpunkt() != null) {
					datum.getTextValue("StartZeitpunkt").setText(getStartZeitpunkt());
				}
				// ZeichenkettenAttributTyp
				if (getStoppZeitpunkt() != null) {
					datum.getTextValue("StoppZeitpunkt").setText(getStoppZeitpunkt());
				}
				// ZeichenkettenAttributTyp
				if (getInitialisierungsZeitpunkt() != null) {
					datum.getTextValue("InitialisierungsZeitpunkt").setText(getInitialisierungsZeitpunkt());
				}
				// ZeichenkettenAttributTyp
				if (getNaechsterStartZeitpunkt() != null) {
					datum.getTextValue("NächsterStartZeitpunkt").setText(getNaechsterStartZeitpunkt());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setProzessID(daten.getTextValue("ProzessID").getText());
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ZeichenkettenAttributTyp
					setAusfuehrbareDatei(daten.getTextValue("AusfuehrbareDatei").getText());
				// AttributListenDefinition
					final Data.Array arrayMakros = daten.getArray("Makros");
					for (int i = 0; i < arrayMakros.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlMakros
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlMakros
						 ();
						atl.atl2Bean(arrayMakros.getItem(i), factory);
						getMakros().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayAufrufParameter = daten.getArray("AufrufParameter");
					for (int i = 0; i < arrayAufrufParameter.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlAufrufParameter
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlAufrufParameter
						 ();
						atl.atl2Bean(arrayAufrufParameter.getItem(i), factory);
						getAufrufParameter().add(atl);
					}
				// AttributListenDefinition
					getStartArt().atl2Bean(daten.getItem("StartArt"), factory);
				// AttributListenDefinition
					final Data.Array arrayStartBedingung = daten.getArray("StartBedingung");
					for (int i = 0; i < arrayStartBedingung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartBedingung
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStartBedingung
						 ();
						atl.atl2Bean(arrayStartBedingung.getItem(i), factory);
						getStartBedingung().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayStoppBedingung = daten.getArray("StoppBedingung");
					for (int i = 0; i < arrayStoppBedingung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStoppBedingung
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlStoppBedingung
						 ();
						atl.atl2Bean(arrayStoppBedingung.getItem(i), factory);
						getStoppBedingung().add(atl);
					}
				// AttributListenDefinition
					getStandardAusgabe().atl2Bean(daten.getItem("StandardAusgabe"), factory);
				// AttributListenDefinition
					getFehlerAusgabe().atl2Bean(daten.getItem("FehlerAusgabe"), factory);
				// AttributListenDefinition
					getStartVerhaltenFehler().atl2Bean(daten.getItem("StartVerhaltenFehler"), factory);
				// AttributListenDefinition
					getStoppVerhaltenFehler().atl2Bean(daten.getItem("StoppVerhaltenFehler"), factory);
				// GanzzahlAttributTyp
						setSimulationsVariante(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("SimulationsVariante").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zustand").isState()) {
							setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
							.getZustand(daten.getScaledValue("Zustand").getText()));
						} else {
						setZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
						(daten.
							getUnscaledValue
						("Zustand").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setStartZeitpunkt(daten.getTextValue("StartZeitpunkt").getText());
				// ZeichenkettenAttributTyp
					setStoppZeitpunkt(daten.getTextValue("StoppZeitpunkt").getText());
				// ZeichenkettenAttributTyp
					setInitialisierungsZeitpunkt(daten.getTextValue("InitialisierungsZeitpunkt").getText());
				// ZeichenkettenAttributTyp
					setNaechsterStartZeitpunkt(daten.getTextValue("NächsterStartZeitpunkt").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlProzess clone() {
		AtlProzess klon = new AtlProzess();
		
						klon.setProzessID(getProzessID());
						klon.setName(getName());
						klon.setAusfuehrbareDatei(getAusfuehrbareDatei());
					klon._makros = getMakros().clone();
					klon._aufrufParameter = getAufrufParameter().clone();
						klon._startArt = getStartArt().clone();
					klon._startBedingung = getStartBedingung().clone();
					klon._stoppBedingung = getStoppBedingung().clone();
						klon._standardAusgabe = getStandardAusgabe().clone();
						klon._fehlerAusgabe = getFehlerAusgabe().clone();
						klon._startVerhaltenFehler = getStartVerhaltenFehler().clone();
						klon._stoppVerhaltenFehler = getStoppVerhaltenFehler().clone();
						klon.setSimulationsVariante(getSimulationsVariante());
						klon.setZustand(getZustand());
						klon.setStartZeitpunkt(getStartZeitpunkt());
						klon.setStoppZeitpunkt(getStoppZeitpunkt());
						klon.setInitialisierungsZeitpunkt(getInitialisierungsZeitpunkt());
						klon.setNaechsterStartZeitpunkt(getNaechsterStartZeitpunkt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
