/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Sammelt alle Aufrufparameter für einen Anwendungsstart.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlStartArt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttOptionStart
			 _optionStart
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _neuStart
			;
			private String
			 _intervall
			= new String
			()
			;
	
		/**
		Option der Startart.
		<p>
		Optionen(AUTOMATISCH;INTERVALL;MANUELL)
		</p>
		
		@return der Wert von OptionStart.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttOptionStart
			 getOptionStart() {
			return _optionStart;
		}
	
		/**
		Option der Startart.
		<p>
		Optionen(AUTOMATISCH;INTERVALL;MANUELL)
		</p>
		
		@param _optionStart der neue Wert von OptionStart.
		*/
		public void setOptionStart(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttOptionStart
		 _optionStart) {
			this._optionStart = _optionStart;
		}
	
		/**
		Mitteilung ob nach Rechnerabsturz die Anwendung automatisch neu gestartet werden soll oder nicht.
		<p>
		
		</p>
		
		@return der Wert von NeuStart.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getNeuStart() {
			return _neuStart;
		}
	
		/**
		Mitteilung ob nach Rechnerabsturz die Anwendung automatisch neu gestartet werden soll oder nicht.
		<p>
		
		</p>
		
		@param _neuStart der neue Wert von NeuStart.
		*/
		public void setNeuStart(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _neuStart) {
			this._neuStart = _neuStart;
		}
	
		/**
		Zeitdauer bei der Option Intervall.
		<p>
		
		</p>
		
		@return der Wert von Intervall.
		*/
			public String
			 getIntervall() {
			return _intervall;
		}
	
		/**
		Zeitdauer bei der Option Intervall.
		<p>
		
		</p>
		
		@param _intervall der neue Wert von Intervall.
		*/
		public void setIntervall(String
		 _intervall) {
			if (_intervall.length() > 128) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 128 + " Zeichen sein.");
			}
			this._intervall = _intervall;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getOptionStart() != null) {
	                if (getOptionStart().isZustand()) {
	                    datum.getUnscaledValue("OptionStart").setText(getOptionStart().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("OptionStart").set(getOptionStart().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getNeuStart() != null) {
	                if (getNeuStart().isZustand()) {
	                    datum.getUnscaledValue("NeuStart").setText(getNeuStart().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("NeuStart").set(getNeuStart().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getIntervall() != null) {
					datum.getTextValue("Intervall").setText(getIntervall());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("OptionStart").isState()) {
							setOptionStart(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttOptionStart
							.getZustand(daten.getScaledValue("OptionStart").getText()));
						} else {
						setOptionStart(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttOptionStart
						(daten.
							getUnscaledValue
						("OptionStart").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("NeuStart").isState()) {
							setNeuStart(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("NeuStart").getText()));
						} else {
						setNeuStart(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("NeuStart").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setIntervall(daten.getTextValue("Intervall").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStartArt clone() {
		AtlStartArt klon = new AtlStartArt();
		
						klon.setOptionStart(getOptionStart());
						klon.setNeuStart(getNeuStart());
						klon.setIntervall(getIntervall());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
