/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Sammelt alle Startbedingungen zu einer Anwendung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlStartBedingung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _vorgaenger
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttWarteArt
			 _warteArt
			;
			private String
			 _rechner
			= new String
			()
			;
			private 	RelativerZeitstempel
			 _warteZeit
			;
	
		/**
		Anwendung die zuerst gestartet sein muss.
		<p>
		
		</p>
		
		@return der Wert von Vorgaenger.
		*/
			public String
			 getVorgaenger() {
			return _vorgaenger;
		}
	
		/**
		Anwendung die zuerst gestartet sein muss.
		<p>
		
		</p>
		
		@param _vorgaenger der neue Wert von Vorgaenger.
		*/
		public void setVorgaenger(String
		 _vorgaenger) {
			if (_vorgaenger.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._vorgaenger = _vorgaenger;
		}
	
		/**
		beginn(Standard):Warten auf den Startanfang.
		                    ende: Warten auf das Startende (Fertigmeldung) der angegebenen Anwendung.
		<p>
		
		</p>
		
		@return der Wert von WarteArt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttWarteArt
			 getWarteArt() {
			return _warteArt;
		}
	
		/**
		beginn(Standard):Warten auf den Startanfang.
		                    ende: Warten auf das Startende (Fertigmeldung) der angegebenen Anwendung.
		<p>
		
		</p>
		
		@param _warteArt der neue Wert von WarteArt.
		*/
		public void setWarteArt(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttWarteArt
		 _warteArt) {
			this._warteArt = _warteArt;
		}
	
		/**
		Rechner Adresse auf dem die Anwendung läuft bzw. laufen soll.
		<p>
		
		</p>
		
		@return der Wert von Rechner.
		*/
			public String
			 getRechner() {
			return _rechner;
		}
	
		/**
		Rechner Adresse auf dem die Anwendung läuft bzw. laufen soll.
		<p>
		
		</p>
		
		@param _rechner der neue Wert von Rechner.
		*/
		public void setRechner(String
		 _rechner) {
			if (_rechner.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._rechner = _rechner;
		}
	
		/**
		Zeitdauer die noch gewartet werden muss bis der Start der Anwendung erfolgen soll.
		<p>
		
		</p>
		
		@return der Wert von WarteZeit.
		*/
			public 	RelativerZeitstempel
			 getWarteZeit() {
			return _warteZeit;
		}
	
		/**
		Zeitdauer die noch gewartet werden muss bis der Start der Anwendung erfolgen soll.
		<p>
		
		</p>
		
		@param _warteZeit der neue Wert von WarteZeit.
		*/
		public void setWarteZeit(	RelativerZeitstempel
		 _warteZeit) {
			this._warteZeit = _warteZeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getVorgaenger() != null) {
					datum.getTextValue("Vorgaenger").setText(getVorgaenger());
				}
				// GanzzahlAttributTyp
				if (getWarteArt() != null) {
	                if (getWarteArt().isZustand()) {
	                    datum.getUnscaledValue("WarteArt").setText(getWarteArt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("WarteArt").set(getWarteArt().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getRechner() != null) {
					datum.getTextValue("Rechner").setText(getRechner());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("WarteZeit").setMillis(getWarteZeit().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setVorgaenger(daten.getTextValue("Vorgaenger").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("WarteArt").isState()) {
							setWarteArt(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttWarteArt
							.getZustand(daten.getScaledValue("WarteArt").getText()));
						} else {
						setWarteArt(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttWarteArt
						(daten.
							getUnscaledValue
						("WarteArt").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setRechner(daten.getTextValue("Rechner").getText());
				// ZeitstempelAttributTyp
					setWarteZeit(new
						RelativerZeitstempel
						(daten.getTimeValue("WarteZeit").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStartBedingung clone() {
		AtlStartBedingung klon = new AtlStartBedingung();
		
						klon.setVorgaenger(getVorgaenger());
						klon.setWarteArt(getWarteArt());
						klon.setRechner(getRechner());
						klon.setWarteZeit(getWarteZeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
