/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält Informationen zu einem StartStopp Block.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlStartStoppBloecke implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _startStoppID
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlInkarnationen
			> _inkarnationen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlInkarnationen
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
			 _zustand
			;
			private String
			 _startZeitpunkt
			= new String
			()
			;
	
		/**
		Id des StartStopp-Blocks.
		<p>
		
		</p>
		
		@return der Wert von StartStoppID.
		*/
			public String
			 getStartStoppID() {
			return _startStoppID;
		}
	
		/**
		Id des StartStopp-Blocks.
		<p>
		
		</p>
		
		@param _startStoppID der neue Wert von StartStoppID.
		*/
		public void setStartStoppID(String
		 _startStoppID) {
			if (_startStoppID.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._startStoppID = _startStoppID;
		}
	
		/**
		Liste der Inkarnationen die zu diesem StartStopp Block gehören.
		<p>
		
		</p>
		
		@return der Wert von Inkarnationen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlInkarnationen
			> getInkarnationen() {
			return _inkarnationen;
		}
	
	
		/**
		Zustand des StartStopp Blocks.
		<p>
		
		</p>
		
		@return der Wert von Zustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
			 getZustand() {
			return _zustand;
		}
	
		/**
		Zustand des StartStopp Blocks.
		<p>
		
		</p>
		
		@param _zustand der neue Wert von Zustand.
		*/
		public void setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
		 _zustand) {
			this._zustand = _zustand;
		}
	
		/**
		Startzeitpunkt der StartStopp Blocks.
		<p>
		
		</p>
		
		@return der Wert von StartZeitpunkt.
		*/
			public String
			 getStartZeitpunkt() {
			return _startZeitpunkt;
		}
	
		/**
		Startzeitpunkt der StartStopp Blocks.
		<p>
		
		</p>
		
		@param _startZeitpunkt der neue Wert von StartZeitpunkt.
		*/
		public void setStartZeitpunkt(String
		 _startZeitpunkt) {
			if (_startZeitpunkt.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._startZeitpunkt = _startZeitpunkt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getStartStoppID() != null) {
					datum.getTextValue("StartStoppID").setText(getStartStoppID());
				}
				// AttributListenDefinition
					final Data.Array arrayInkarnationen = datum.getArray("Inkarnationen");
					arrayInkarnationen.setLength(getInkarnationen().size());
					for (int i = 0; i < arrayInkarnationen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlInkarnationen
						 atl = getInkarnationen().get(i);
						atl.bean2Atl(arrayInkarnationen.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getZustand() != null) {
	                if (getZustand().isZustand()) {
	                    datum.getUnscaledValue("Zustand").setText(getZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zustand").set(getZustand().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getStartZeitpunkt() != null) {
					datum.getTextValue("StartZeitpunkt").setText(getStartZeitpunkt());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setStartStoppID(daten.getTextValue("StartStoppID").getText());
				// AttributListenDefinition
					final Data.Array arrayInkarnationen = daten.getArray("Inkarnationen");
					for (int i = 0; i < arrayInkarnationen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlInkarnationen
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AtlInkarnationen
						 ();
						atl.atl2Bean(arrayInkarnationen.getItem(i), factory);
						getInkarnationen().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zustand").isState()) {
							setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
							.getZustand(daten.getScaledValue("Zustand").getText()));
						} else {
						setZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStartStoppZustand
						(daten.
							getUnscaledValue
						("Zustand").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setStartZeitpunkt(daten.getTextValue("StartZeitpunkt").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStartStoppBloecke clone() {
		AtlStartStoppBloecke klon = new AtlStartStoppBloecke();
		
						klon.setStartStoppID(getStartStoppID());
					klon._inkarnationen = getInkarnationen().clone();
						klon.setZustand(getZustand());
						klon.setStartZeitpunkt(getStartZeitpunkt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
