/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert das Verhalten bei Fehlern während des Stoppens.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlStoppVerhaltenFehler implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStoppVerhaltenFehlerOption
			 _stoppVerhaltenFehlerOption
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _wiederholrate
			;
	
		/**
		Verwendungsoption.
		<p>
		
		</p>
		
		@return der Wert von StoppVerhaltenFehlerOption.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStoppVerhaltenFehlerOption
			 getStoppVerhaltenFehlerOption() {
			return _stoppVerhaltenFehlerOption;
		}
	
		/**
		Verwendungsoption.
		<p>
		
		</p>
		
		@param _stoppVerhaltenFehlerOption der neue Wert von StoppVerhaltenFehlerOption.
		*/
		public void setStoppVerhaltenFehlerOption(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStoppVerhaltenFehlerOption
		 _stoppVerhaltenFehlerOption) {
			this._stoppVerhaltenFehlerOption = _stoppVerhaltenFehlerOption;
		}
	
		/**
		Datei.
		<p>
		
		</p>
		
		@return der Wert von Wiederholrate.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getWiederholrate() {
			return _wiederholrate;
		}
	
		/**
		Datei.
		<p>
		
		</p>
		
		@param _wiederholrate der neue Wert von Wiederholrate.
		*/
		public void setWiederholrate(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _wiederholrate) {
			this._wiederholrate = _wiederholrate;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getStoppVerhaltenFehlerOption() != null) {
	                if (getStoppVerhaltenFehlerOption().isZustand()) {
	                    datum.getUnscaledValue("StoppVerhaltenFehlerOption").setText(getStoppVerhaltenFehlerOption().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StoppVerhaltenFehlerOption").set(getStoppVerhaltenFehlerOption().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getWiederholrate() != null) {
	                if (getWiederholrate().isZustand()) {
	                    datum.getUnscaledValue("Wiederholrate").setText(getWiederholrate().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Wiederholrate").set(getWiederholrate().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StoppVerhaltenFehlerOption").isState()) {
							setStoppVerhaltenFehlerOption(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStoppVerhaltenFehlerOption
							.getZustand(daten.getScaledValue("StoppVerhaltenFehlerOption").getText()));
						} else {
						setStoppVerhaltenFehlerOption(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttStoppVerhaltenFehlerOption
						(daten.
							getUnscaledValue
						("StoppVerhaltenFehlerOption").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setWiederholrate(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Wiederholrate").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStoppVerhaltenFehler clone() {
		AtlStoppVerhaltenFehler klon = new AtlStoppVerhaltenFehler();
		
						klon.setStoppVerhaltenFehlerOption(getStoppVerhaltenFehlerOption());
						klon.setWiederholrate(getWiederholrate());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
