/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Übergabe der Start&#47;Stopp Informationen als XML-Datei-Pfad.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlV3 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttAktion
			 _aktion
			;
			private String
			 _startStoppID
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _simulationsVariante
			;
			private String
			 _xmlDatei
			= new String
			()
			;
	
		/**
		Option der Aktion.
		<p>
		Optionen(starten,stoppen,neustart)
		</p>
		
		@return der Wert von Aktion.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttAktion
			 getAktion() {
			return _aktion;
		}
	
		/**
		Option der Aktion.
		<p>
		Optionen(starten,stoppen,neustart)
		</p>
		
		@param _aktion der neue Wert von Aktion.
		*/
		public void setAktion(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttAktion
		 _aktion) {
			this._aktion = _aktion;
		}
	
		/**
		eindeutige StartStopp ID des StartStopp Blocks.
		<p>
		
		</p>
		
		@return der Wert von StartStoppID.
		*/
			public String
			 getStartStoppID() {
			return _startStoppID;
		}
	
		/**
		eindeutige StartStopp ID des StartStopp Blocks.
		<p>
		
		</p>
		
		@param _startStoppID der neue Wert von StartStoppID.
		*/
		public void setStartStoppID(String
		 _startStoppID) {
			if (_startStoppID.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._startStoppID = _startStoppID;
		}
	
		/**
		Nummer der Simulation einer Anwendung. "0" ist die Normale Anwendung.
		<p>
		
		</p>
		
		@return der Wert von SimulationsVariante.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getSimulationsVariante() {
			return _simulationsVariante;
		}
	
		/**
		Nummer der Simulation einer Anwendung. "0" ist die Normale Anwendung.
		<p>
		
		</p>
		
		@param _simulationsVariante der neue Wert von SimulationsVariante.
		*/
		public void setSimulationsVariante(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _simulationsVariante) {
			this._simulationsVariante = _simulationsVariante;
		}
	
		/**
		Ein Pfad zu einer XML-Datei( Mit Rechner) wird übergeben.
		<p>
		
		</p>
		
		@return der Wert von XmlDatei.
		*/
			public String
			 getXmlDatei() {
			return _xmlDatei;
		}
	
		/**
		Ein Pfad zu einer XML-Datei( Mit Rechner) wird übergeben.
		<p>
		
		</p>
		
		@param _xmlDatei der neue Wert von XmlDatei.
		*/
		public void setXmlDatei(String
		 _xmlDatei) {
			if (_xmlDatei.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._xmlDatei = _xmlDatei;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAktion() != null) {
	                if (getAktion().isZustand()) {
	                    datum.getUnscaledValue("Aktion").setText(getAktion().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Aktion").set(getAktion().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getStartStoppID() != null) {
					datum.getTextValue("StartStoppID").setText(getStartStoppID());
				}
				// GanzzahlAttributTyp
				if (getSimulationsVariante() != null) {
	                if (getSimulationsVariante().isZustand()) {
	                    datum.getUnscaledValue("SimulationsVariante").setText(getSimulationsVariante().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SimulationsVariante").set(getSimulationsVariante().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getXmlDatei() != null) {
					datum.getTextValue("xmlDatei").setText(getXmlDatei());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Aktion").isState()) {
							setAktion(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttAktion
							.getZustand(daten.getScaledValue("Aktion").getText()));
						} else {
						setAktion(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttAktion
						(daten.
							getUnscaledValue
						("Aktion").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setStartStoppID(daten.getTextValue("StartStoppID").getText());
				// GanzzahlAttributTyp
						setSimulationsVariante(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("SimulationsVariante").
								longValue
						()));
				// ZeichenkettenAttributTyp
					setXmlDatei(daten.getTextValue("xmlDatei").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlV3 clone() {
		AtlV3 klon = new AtlV3();
		
						klon.setAktion(getAktion());
						klon.setStartStoppID(getStartStoppID());
						klon.setSimulationsVariante(getSimulationsVariante());
						klon.setXmlDatei(getXmlDatei());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
