/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Übergabe der Start&#47;Stopp Informationen durch Angabe eines Inkarnationsnamen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlV4 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _prozessID
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttAktion
			 _aktion
			;
			private String
			 _name
			= new String
			()
			;
	
		/**
		eindeutige StartStopp Id der Applikation.
		<p>
		
		</p>
		
		@return der Wert von ProzessID.
		*/
			public String
			 getProzessID() {
			return _prozessID;
		}
	
		/**
		eindeutige StartStopp Id der Applikation.
		<p>
		
		</p>
		
		@param _prozessID der neue Wert von ProzessID.
		*/
		public void setProzessID(String
		 _prozessID) {
			if (_prozessID.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._prozessID = _prozessID;
		}
	
		/**
		Option der Aktion.
		<p>
		Optionen(starten,stoppen,neustart)
		</p>
		
		@return der Wert von Aktion.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttAktion
			 getAktion() {
			return _aktion;
		}
	
		/**
		Option der Aktion.
		<p>
		Optionen(starten,stoppen,neustart)
		</p>
		
		@param _aktion der neue Wert von Aktion.
		*/
		public void setAktion(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttAktion
		 _aktion) {
			this._aktion = _aktion;
		}
	
		/**
		Applikationsname.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Applikationsname.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getProzessID() != null) {
					datum.getTextValue("ProzessID").setText(getProzessID());
				}
				// GanzzahlAttributTyp
				if (getAktion() != null) {
	                if (getAktion().isZustand()) {
	                    datum.getUnscaledValue("Aktion").setText(getAktion().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Aktion").set(getAktion().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setProzessID(daten.getTextValue("ProzessID").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Aktion").isState()) {
							setAktion(de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttAktion
							.getZustand(daten.getScaledValue("Aktion").getText()));
						} else {
						setAktion(new de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.attribute.AttAktion
						(daten.
							getUnscaledValue
						("Aktion").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlV4 clone() {
		AtlV4 klon = new AtlV4();
		
						klon.setProzessID(getProzessID());
						klon.setAktion(getAktion());
						klon.setName(getName());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
