/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zusammenfassung aller atmosphärischen Sensorikwerte.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlGmaAtmosphaerendaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
			> _luftTemperatur = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
			> _niederschlagsIntensitaet = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftDruck
			> _luftDruck = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftDruck
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
			> _relativeLuftFeuchte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindRichtung
			> _windRichtung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindRichtung
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitMittelWert
			> _windGeschwindigkeitMittelWert = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitMittelWert
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeHoehe
			> _schneeHoehe = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeHoehe
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			> _sichtWeite = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsHelligkeit
			> _helligkeit = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsHelligkeit
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitSpitzenWert
			> _windGeschwindigkeitSpitzenWert = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitSpitzenWert
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTaupunktTemperatur
			> _taupunktTemperatur = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTaupunktTemperatur
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsArt
			> _niederschlagsArt = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsArt
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsMenge
			> _niederschlagsMenge = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsMenge
			>(1, true);
	
		/**
		Temperatur, der in Nähe der Fahrbahnmessstelle befindlichen Umgebungsluft.
		<p>
		- 30 ... + 60 °C Temperatur, der in Nähe der Fahrbahnmessstelle befindlichen Umgebungsluft. Messung muss weitgehend unbeeinflusst von direkter Sonneneinstrahlung und Windeinwirkung sein. Die Lufttemperatur wird in Grad Celsius angegeben. Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von LuftTemperatur.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
			> getLuftTemperatur() {
			return _luftTemperatur;
		}
	
	
		/**
		Niederschlagsart Regen&#47;Schnee (alte Anlagen).
		<p>
		
		</p>
		
		@return der Wert von NiederschlagsIntensitaet.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
			> getNiederschlagsIntensitaet() {
			return _niederschlagsIntensitaet;
		}
	
	
		/**
		Luftdruck.
		<p>
		Atmosphärischer Luftdruck, bezogen auf Meereshöhe und Normbedingung (QNH), am Ort des Messquerschnittes in hPa. Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von LuftDruck.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftDruck
			> getLuftDruck() {
			return _luftDruck;
		}
	
	
		/**
		Relative Luftfeuchte der in Nähe der Fahrbahnmessstelle befindlichen Umgebungsluft.
		<p>
		Relative Luftfeuchte der in Nähe der Fahrbahnmessstelle befindlichen Umgebungsluft. Messung muss weitgehend unbeeinflusst von direkter Sonneneinstrahlung und Windeinwirkung sein. Die Rel. Feuchte sollte immer an der gleichen Stelle gemessen werden wie die Lufttemperatur (DE-Typ 48). Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von RelativeLuftFeuchte.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
			> getRelativeLuftFeuchte() {
			return _relativeLuftFeuchte;
		}
	
	
		/**
		Windrichtung.
		<p>
		Richtung aus der der Wind weht in Grad der Kompassrose angegeben. Die Windrichtung wird als vektorieller Mittelwert (Windrichtung und - geschwindigkeit) über ein gleitendes Zeitintervall von 10 Minuten ermittelt. Gleichzeitig sollte auch die Windgeschwindigkeit an der gleichen Stelle gemessen werdem.
		</p>
		
		@return der Wert von WindRichtung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindRichtung
			> getWindRichtung() {
			return _windRichtung;
		}
	
	
		/**
		Windgeschwindigkeit (Mittel).
		<p>
		Geschwindigkeit des Windes in horizontaler Ebene (Komponente) in Meter pro Sekunde. Windgeschwindigkeit (Mittel) wird als vektorieller Mittelwert über ein gleitendes Zeitintervall von 10 Minuten ermittelt. Bei gleichzeitiger Messung der Windrichtung sind die Sensoren an der gleichen Stelle zu platzieren.
		</p>
		
		@return der Wert von WindGeschwindigkeitMittelWert.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitMittelWert
			> getWindGeschwindigkeitMittelWert() {
			return _windGeschwindigkeitMittelWert;
		}
	
	
		/**
		Schneehöhe.
		<p>
		Gibt die Höhe der Schneebedeckung an einer definierten Messstelle in Bezug zu einer ebenen, senkrechten Fläche an. 0 cm wird gemeldet, wenn die ebene senkrechte Fläche völlig unbedeckt ist. Die Schneeoberfläche sollte durch die Messung nicht beeinflusst werden. Die Schneehöhe hat nichts mit der Bedeckung der Straßenoberfläche von Fahrspuren zu tun. Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von SchneeHoehe.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeHoehe
			> getSchneeHoehe() {
			return _schneeHoehe;
		}
	
	
		/**
		Sichtweite.
		<p>
		Sichtweite bezogen auf eine Kontrastschwelle von 5% an der Messstelle in Meter. Ist diejenige Entfernung, in der zwei aneinandergrenzende Flächen, deren Kontrastunterschied 5% beträgt, gerade noch unterschieden werden können. Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von SichtWeite.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			> getSichtWeite() {
			return _sichtWeite;
		}
	
	
		/**
		Helligkeit.
		<p>
		Helligkeit ist definiert als Beleuchtungsstärke (Anteil des auf eine ebene Messfläche senkrecht auftreffenden Komponente des Lichtstroms im sichtbaren Spektralbereich) in Lux angegeben. Die Ausrichtung des Sensors sollte beachtet werden. Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von Helligkeit.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsHelligkeit
			> getHelligkeit() {
			return _helligkeit;
		}
	
	
		/**
		Windgeschwindigkeit (Spitze).
		<p>
		Geschwindigkeit des Windes in horizontaler Ebene (Komponente) in Meter pro Sekunde. Windgeschwindigkeit (Spitze) ist die maximale Windgeschwindigkeit der letzten 10 Minuten. Bei gleichzeitiger Messung der Windrichtung sind die Sensoren an der gleichen Stelle zu platzieren.
		</p>
		
		@return der Wert von WindGeschwindigkeitSpitzenWert.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitSpitzenWert
			> getWindGeschwindigkeitSpitzenWert() {
			return _windGeschwindigkeitSpitzenWert;
		}
	
	
		/**
		Taupunkttemperatur.
		<p>
		Taupunkttemperatur ist diejenige Temperatur, bei der die in der Umgebungsluft der Messstelle (am Ort der Temperatur und Feuchte-Sensorik) befindliche Feuchte zu kondensieren beginnt. Die Taupunkttemperatur ist aus der Temperatur und der relativen Feuchte der Luft zu bestimmen. Zur Bestimmung ist die in den neuesten ?betriebstechnischen Anforderungen für Glättemeldeanlagen? enthaltene Berechnungsvorschrift zu verwenden. Dieser Berechnungsvorschrift liegen auch die im Wetterdienst verwendeten Taupunkttabellen zugrunde.
		</p>
		
		@return der Wert von TaupunktTemperatur.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTaupunktTemperatur
			> getTaupunktTemperatur() {
			return _taupunktTemperatur;
		}
	
	
		/**
		Niederschlagart.
		<p>
		In der Atmosphäre fallender Niederschlag. Wird gleichzeitig Niederschlagsintensität ermittelt, ist diese an der gleichen Stelle vorzunehmen. Es wird darauf hingewiesen, dass von der Streckenstation bzw. der Sensorik nicht alle Ausprägungen unterstützt werden müssen. Welcher Differenzierungsgrad notwendig und sinnvoll ist, hängt von der Anwendung ab. Bei einfachen Anwendungen können die Ausprägungen 0 und 40, bei normalen Anforderungen 0, 60 und 70 ( entspricht den bisher verwendeten Ausprägungen 00, 01, 02 des Typs 63 ) ausreichen. Es werden die Klassifikation und die Codes nach WMO Tabelle 4680 verwendet.
		</p>
		
		@return der Wert von NiederschlagsArt.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsArt
			> getNiederschlagsArt() {
			return _niederschlagsArt;
		}
	
	
		/**
		Fallender Niederschlag aller Art.
		<p>
		Die Intensität wird in Bezug auf Niederschlag in flüssiger Form durch Volumen (1 l&#47;m2 = 1 mm) pro Zeiteinheit angegeben. Ist die Sensorik in der Lage, Niederschlag in gefrorener Form zu detektieren, wird das Wasseräquivalent (Menge nach Schmelzen) verwendet. Es wird der gleitende Mittelwert übertragen.
		</p>
		
		@return der Wert von NiederschlagsMenge.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsMenge
			> getNiederschlagsMenge() {
			return _niederschlagsMenge;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getLuftTemperatur() != null) {
					final Data.NumberArray arrayLuftTemperatur = datum.
						getScaledArray
						("LuftTemperatur");
					arrayLuftTemperatur.setLength(getLuftTemperatur().size());
					for (int i = 0; i < arrayLuftTemperatur.getLength(); ++i) {
						arrayLuftTemperatur.getValue(i).set(getLuftTemperatur().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getNiederschlagsIntensitaet() != null) {
					final Data.NumberArray arrayNiederschlagsIntensitaet = datum.
						getScaledArray
						("NiederschlagsIntensität");
					arrayNiederschlagsIntensitaet.setLength(getNiederschlagsIntensitaet().size());
					for (int i = 0; i < arrayNiederschlagsIntensitaet.getLength(); ++i) {
						arrayNiederschlagsIntensitaet.getValue(i).set(getNiederschlagsIntensitaet().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getLuftDruck() != null) {
					final Data.NumberArray arrayLuftDruck = datum.
						getUnscaledArray
						("LuftDruck");
					arrayLuftDruck.setLength(getLuftDruck().size());
					for (int i = 0; i < arrayLuftDruck.getLength(); ++i) {
						arrayLuftDruck.getValue(i).set(getLuftDruck().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getRelativeLuftFeuchte() != null) {
					final Data.NumberArray arrayRelativeLuftFeuchte = datum.
						getUnscaledArray
						("RelativeLuftFeuchte");
					arrayRelativeLuftFeuchte.setLength(getRelativeLuftFeuchte().size());
					for (int i = 0; i < arrayRelativeLuftFeuchte.getLength(); ++i) {
						arrayRelativeLuftFeuchte.getValue(i).set(getRelativeLuftFeuchte().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getWindRichtung() != null) {
					final Data.NumberArray arrayWindRichtung = datum.
						getUnscaledArray
						("WindRichtung");
					arrayWindRichtung.setLength(getWindRichtung().size());
					for (int i = 0; i < arrayWindRichtung.getLength(); ++i) {
						arrayWindRichtung.getValue(i).set(getWindRichtung().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getWindGeschwindigkeitMittelWert() != null) {
					final Data.NumberArray arrayWindGeschwindigkeitMittelWert = datum.
						getScaledArray
						("WindGeschwindigkeitMittelWert");
					arrayWindGeschwindigkeitMittelWert.setLength(getWindGeschwindigkeitMittelWert().size());
					for (int i = 0; i < arrayWindGeschwindigkeitMittelWert.getLength(); ++i) {
						arrayWindGeschwindigkeitMittelWert.getValue(i).set(getWindGeschwindigkeitMittelWert().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getSchneeHoehe() != null) {
					final Data.NumberArray arraySchneeHoehe = datum.
						getUnscaledArray
						("SchneeHöhe");
					arraySchneeHoehe.setLength(getSchneeHoehe().size());
					for (int i = 0; i < arraySchneeHoehe.getLength(); ++i) {
						arraySchneeHoehe.getValue(i).set(getSchneeHoehe().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getSichtWeite() != null) {
					final Data.NumberArray arraySichtWeite = datum.
						getUnscaledArray
						("SichtWeite");
					arraySichtWeite.setLength(getSichtWeite().size());
					for (int i = 0; i < arraySichtWeite.getLength(); ++i) {
						arraySichtWeite.getValue(i).set(getSichtWeite().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getHelligkeit() != null) {
					final Data.NumberArray arrayHelligkeit = datum.
						getUnscaledArray
						("Helligkeit");
					arrayHelligkeit.setLength(getHelligkeit().size());
					for (int i = 0; i < arrayHelligkeit.getLength(); ++i) {
						arrayHelligkeit.getValue(i).set(getHelligkeit().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getWindGeschwindigkeitSpitzenWert() != null) {
					final Data.NumberArray arrayWindGeschwindigkeitSpitzenWert = datum.
						getScaledArray
						("WindGeschwindigkeitSpitzenWert");
					arrayWindGeschwindigkeitSpitzenWert.setLength(getWindGeschwindigkeitSpitzenWert().size());
					for (int i = 0; i < arrayWindGeschwindigkeitSpitzenWert.getLength(); ++i) {
						arrayWindGeschwindigkeitSpitzenWert.getValue(i).set(getWindGeschwindigkeitSpitzenWert().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getTaupunktTemperatur() != null) {
					final Data.NumberArray arrayTaupunktTemperatur = datum.
						getScaledArray
						("TaupunktTemperatur");
					arrayTaupunktTemperatur.setLength(getTaupunktTemperatur().size());
					for (int i = 0; i < arrayTaupunktTemperatur.getLength(); ++i) {
						arrayTaupunktTemperatur.getValue(i).set(getTaupunktTemperatur().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getNiederschlagsArt() != null) {
					final Data.NumberArray arrayNiederschlagsArt = datum.
						getUnscaledArray
						("NiederschlagsArt");
					arrayNiederschlagsArt.setLength(getNiederschlagsArt().size());
					for (int i = 0; i < arrayNiederschlagsArt.getLength(); ++i) {
						arrayNiederschlagsArt.getValue(i).set(getNiederschlagsArt().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getNiederschlagsMenge() != null) {
					final Data.NumberArray arrayNiederschlagsMenge = datum.
						getScaledArray
						("NiederschlagsMenge");
					arrayNiederschlagsMenge.setLength(getNiederschlagsMenge().size());
					for (int i = 0; i < arrayNiederschlagsMenge.getLength(); ++i) {
						arrayNiederschlagsMenge.getValue(i).set(getNiederschlagsMenge().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
					final Data.NumberArray arrayLuftTemperatur = daten.
						getScaledArray
					("LuftTemperatur");
	
					for (int i = 0; i < arrayLuftTemperatur.getLength(); ++i) {
	                    if (arrayLuftTemperatur.getValue(i).isState()) {
	                        getLuftTemperatur().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
	                        .getZustand(arrayLuftTemperatur.getValue(i).getState().getName()));
	                    } else {
	                    getLuftTemperatur().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
	                    (arrayLuftTemperatur.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayNiederschlagsIntensitaet = daten.
						getScaledArray
					("NiederschlagsIntensität");
	
					for (int i = 0; i < arrayNiederschlagsIntensitaet.getLength(); ++i) {
	                    if (arrayNiederschlagsIntensitaet.getValue(i).isState()) {
	                        getNiederschlagsIntensitaet().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
	                        .getZustand(arrayNiederschlagsIntensitaet.getValue(i).getState().getName()));
	                    } else {
	                    getNiederschlagsIntensitaet().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
	                    (arrayNiederschlagsIntensitaet.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayLuftDruck = daten.
						getUnscaledArray
					("LuftDruck");
	
					for (int i = 0; i < arrayLuftDruck.getLength(); ++i) {
	                    if (arrayLuftDruck.getValue(i).isState()) {
	                        getLuftDruck().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftDruck
	                        .getZustand(arrayLuftDruck.getValue(i).getState().getName()));
	                    } else {
	                    getLuftDruck().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftDruck
	                    (arrayLuftDruck.
	                    		shortValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayRelativeLuftFeuchte = daten.
						getUnscaledArray
					("RelativeLuftFeuchte");
	
					for (int i = 0; i < arrayRelativeLuftFeuchte.getLength(); ++i) {
	                    if (arrayRelativeLuftFeuchte.getValue(i).isState()) {
	                        getRelativeLuftFeuchte().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
	                        .getZustand(arrayRelativeLuftFeuchte.getValue(i).getState().getName()));
	                    } else {
	                    getRelativeLuftFeuchte().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
	                    (arrayRelativeLuftFeuchte.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayWindRichtung = daten.
						getUnscaledArray
					("WindRichtung");
	
					for (int i = 0; i < arrayWindRichtung.getLength(); ++i) {
	                    if (arrayWindRichtung.getValue(i).isState()) {
	                        getWindRichtung().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindRichtung
	                        .getZustand(arrayWindRichtung.getValue(i).getState().getName()));
	                    } else {
	                    getWindRichtung().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindRichtung
	                    (arrayWindRichtung.
	                    		shortValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayWindGeschwindigkeitMittelWert = daten.
						getScaledArray
					("WindGeschwindigkeitMittelWert");
	
					for (int i = 0; i < arrayWindGeschwindigkeitMittelWert.getLength(); ++i) {
	                    if (arrayWindGeschwindigkeitMittelWert.getValue(i).isState()) {
	                        getWindGeschwindigkeitMittelWert().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitMittelWert
	                        .getZustand(arrayWindGeschwindigkeitMittelWert.getValue(i).getState().getName()));
	                    } else {
	                    getWindGeschwindigkeitMittelWert().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitMittelWert
	                    (arrayWindGeschwindigkeitMittelWert.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arraySchneeHoehe = daten.
						getUnscaledArray
					("SchneeHöhe");
	
					for (int i = 0; i < arraySchneeHoehe.getLength(); ++i) {
	                    if (arraySchneeHoehe.getValue(i).isState()) {
	                        getSchneeHoehe().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeHoehe
	                        .getZustand(arraySchneeHoehe.getValue(i).getState().getName()));
	                    } else {
	                    getSchneeHoehe().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeHoehe
	                    (arraySchneeHoehe.
	                    		shortValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arraySichtWeite = daten.
						getUnscaledArray
					("SichtWeite");
	
					for (int i = 0; i < arraySichtWeite.getLength(); ++i) {
	                    if (arraySichtWeite.getValue(i).isState()) {
	                        getSichtWeite().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
	                        .getZustand(arraySichtWeite.getValue(i).getState().getName()));
	                    } else {
	                    getSichtWeite().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
	                    (arraySichtWeite.
	                    		intValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayHelligkeit = daten.
						getUnscaledArray
					("Helligkeit");
	
					for (int i = 0; i < arrayHelligkeit.getLength(); ++i) {
	                    if (arrayHelligkeit.getValue(i).isState()) {
	                        getHelligkeit().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsHelligkeit
	                        .getZustand(arrayHelligkeit.getValue(i).getState().getName()));
	                    } else {
	                    getHelligkeit().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsHelligkeit
	                    (arrayHelligkeit.
	                    		intValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayWindGeschwindigkeitSpitzenWert = daten.
						getScaledArray
					("WindGeschwindigkeitSpitzenWert");
	
					for (int i = 0; i < arrayWindGeschwindigkeitSpitzenWert.getLength(); ++i) {
	                    if (arrayWindGeschwindigkeitSpitzenWert.getValue(i).isState()) {
	                        getWindGeschwindigkeitSpitzenWert().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitSpitzenWert
	                        .getZustand(arrayWindGeschwindigkeitSpitzenWert.getValue(i).getState().getName()));
	                    } else {
	                    getWindGeschwindigkeitSpitzenWert().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitSpitzenWert
	                    (arrayWindGeschwindigkeitSpitzenWert.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayTaupunktTemperatur = daten.
						getScaledArray
					("TaupunktTemperatur");
	
					for (int i = 0; i < arrayTaupunktTemperatur.getLength(); ++i) {
	                    if (arrayTaupunktTemperatur.getValue(i).isState()) {
	                        getTaupunktTemperatur().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTaupunktTemperatur
	                        .getZustand(arrayTaupunktTemperatur.getValue(i).getState().getName()));
	                    } else {
	                    getTaupunktTemperatur().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTaupunktTemperatur
	                    (arrayTaupunktTemperatur.
	                    	doubleValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayNiederschlagsArt = daten.
						getUnscaledArray
					("NiederschlagsArt");
	
					for (int i = 0; i < arrayNiederschlagsArt.getLength(); ++i) {
	                    if (arrayNiederschlagsArt.getValue(i).isState()) {
	                        getNiederschlagsArt().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsArt
	                        .getZustand(arrayNiederschlagsArt.getValue(i).getState().getName()));
	                    } else {
	                    getNiederschlagsArt().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsArt
	                    (arrayNiederschlagsArt.
	                    		shortValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayNiederschlagsMenge = daten.
						getScaledArray
					("NiederschlagsMenge");
	
					for (int i = 0; i < arrayNiederschlagsMenge.getLength(); ++i) {
	                    if (arrayNiederschlagsMenge.getValue(i).isState()) {
	                        getNiederschlagsMenge().add(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsMenge
	                        .getZustand(arrayNiederschlagsMenge.getValue(i).getState().getName()));
	                    } else {
	                    getNiederschlagsMenge().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsMenge
	                    (arrayNiederschlagsMenge.
	                    	doubleValue
	                    (i)));
	                    }
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlGmaAtmosphaerendaten clone() {
		AtlGmaAtmosphaerendaten klon = new AtlGmaAtmosphaerendaten();
		
					klon._luftTemperatur = getLuftTemperatur().clone();
					klon._niederschlagsIntensitaet = getNiederschlagsIntensitaet().clone();
					klon._luftDruck = getLuftDruck().clone();
					klon._relativeLuftFeuchte = getRelativeLuftFeuchte().clone();
					klon._windRichtung = getWindRichtung().clone();
					klon._windGeschwindigkeitMittelWert = getWindGeschwindigkeitMittelWert().clone();
					klon._schneeHoehe = getSchneeHoehe().clone();
					klon._sichtWeite = getSichtWeite().clone();
					klon._helligkeit = getHelligkeit().clone();
					klon._windGeschwindigkeitSpitzenWert = getWindGeschwindigkeitSpitzenWert().clone();
					klon._taupunktTemperatur = getTaupunktTemperatur().clone();
					klon._niederschlagsArt = getNiederschlagsArt().clone();
					klon._niederschlagsMenge = getNiederschlagsMenge().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
