/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Alarmstufe mit Bestätigung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSwisAlarm implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttSwisAlarm
			 _swisAlarm
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _unbestaetigt
			;
	
		/**
		Alarmstufe.
		<p>
		
		</p>
		
		@return der Wert von SwisAlarm.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttSwisAlarm
			 getSwisAlarm() {
			return _swisAlarm;
		}
	
		/**
		Alarmstufe.
		<p>
		
		</p>
		
		@param _swisAlarm der neue Wert von SwisAlarm.
		*/
		public void setSwisAlarm(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttSwisAlarm
		 _swisAlarm) {
			this._swisAlarm = _swisAlarm;
		}
	
		/**
		Gibt an, ob ein unbestätigter Alarm anliegt.
		<p>
		
		</p>
		
		@return der Wert von Unbestaetigt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getUnbestaetigt() {
			return _unbestaetigt;
		}
	
		/**
		Gibt an, ob ein unbestätigter Alarm anliegt.
		<p>
		
		</p>
		
		@param _unbestaetigt der neue Wert von Unbestaetigt.
		*/
		public void setUnbestaetigt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _unbestaetigt) {
			this._unbestaetigt = _unbestaetigt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getSwisAlarm() != null) {
	                if (getSwisAlarm().isZustand()) {
	                    datum.getUnscaledValue("SwisAlarm").setText(getSwisAlarm().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SwisAlarm").set(getSwisAlarm().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getUnbestaetigt() != null) {
	                if (getUnbestaetigt().isZustand()) {
	                    datum.getUnscaledValue("unbestätigt").setText(getUnbestaetigt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("unbestätigt").set(getUnbestaetigt().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SwisAlarm").isState()) {
							setSwisAlarm(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttSwisAlarm
							.getZustand(daten.getScaledValue("SwisAlarm").getText()));
						} else {
						setSwisAlarm(new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttSwisAlarm
						(daten.
							getUnscaledValue
						("SwisAlarm").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("unbestätigt").isState()) {
							setUnbestaetigt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("unbestätigt").getText()));
						} else {
						setUnbestaetigt(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("unbestätigt").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSwisAlarm clone() {
		AtlSwisAlarm klon = new AtlSwisAlarm();
		
						klon.setSwisAlarm(getSwisAlarm());
						klon.setUnbestaetigt(getUnbestaetigt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
