/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Streckentyp nach Definition des DWD.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlUfdStreckenTyp implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdStreckenTypCharakteristik
			 _charakteristik
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdStreckenTypFahrbahnBelag
			 _fahrbahnBelag
			;
	
		/**
		freie Strecke oder Brücke mit zugehöriger Charakteristik.
		<p>
		
		</p>
		
		@return der Wert von Charakteristik.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdStreckenTypCharakteristik
			 getCharakteristik() {
			return _charakteristik;
		}
	
		/**
		freie Strecke oder Brücke mit zugehöriger Charakteristik.
		<p>
		
		</p>
		
		@param _charakteristik der neue Wert von Charakteristik.
		*/
		public void setCharakteristik(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdStreckenTypCharakteristik
		 _charakteristik) {
			this._charakteristik = _charakteristik;
		}
	
		/**
		Art des Fahrbahnbelags.
		<p>
		
		</p>
		
		@return der Wert von FahrbahnBelag.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdStreckenTypFahrbahnBelag
			 getFahrbahnBelag() {
			return _fahrbahnBelag;
		}
	
		/**
		Art des Fahrbahnbelags.
		<p>
		
		</p>
		
		@param _fahrbahnBelag der neue Wert von FahrbahnBelag.
		*/
		public void setFahrbahnBelag(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdStreckenTypFahrbahnBelag
		 _fahrbahnBelag) {
			this._fahrbahnBelag = _fahrbahnBelag;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getCharakteristik() != null) {
	                if (getCharakteristik().isZustand()) {
	                    datum.getUnscaledValue("Charakteristik").setText(getCharakteristik().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Charakteristik").set(getCharakteristik().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFahrbahnBelag() != null) {
	                if (getFahrbahnBelag().isZustand()) {
	                    datum.getUnscaledValue("FahrbahnBelag").setText(getFahrbahnBelag().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrbahnBelag").set(getFahrbahnBelag().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Charakteristik").isState()) {
							setCharakteristik(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdStreckenTypCharakteristik
							.getZustand(daten.getScaledValue("Charakteristik").getText()));
						} else {
						setCharakteristik(new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdStreckenTypCharakteristik
						(daten.
							getUnscaledValue
						("Charakteristik").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrbahnBelag").isState()) {
							setFahrbahnBelag(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdStreckenTypFahrbahnBelag
							.getZustand(daten.getScaledValue("FahrbahnBelag").getText()));
						} else {
						setFahrbahnBelag(new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdStreckenTypFahrbahnBelag
						(daten.
							getUnscaledValue
						("FahrbahnBelag").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUfdStreckenTyp clone() {
		AtlUfdStreckenTyp klon = new AtlUfdStreckenTyp();
		
						klon.setCharakteristik(getCharakteristik());
						klon.setFahrbahnBelag(getFahrbahnBelag());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
