/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Erweiterter Stationstyp (BUFR Codetabelle 0 02 243).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 63L,
	einheit = ""
)
public class AttUfdErweiterterStationsTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("63");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_0_NICHT_AUTOMATISCH_NICHT_BEMANNT_NICHT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("nicht automatisch, nicht bemannt, nicht ereignisgesteuert, normale Zeitperiode", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_4_NICHT_AUTOMATISCH_NICHT_BEMANNT_NICHT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("nicht automatisch, nicht bemannt, nicht ereignisgesteuert, verlängerte Zeitperiode", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_8_NICHT_AUTOMATISCH_NICHT_BEMANNT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("nicht automatisch, nicht bemannt, ereignisgesteuert, normale Zeitperiode", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_12_NICHT_AUTOMATISCH_NICHT_BEMANNT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("nicht automatisch, nicht bemannt, ereignisgesteuert, verlängerte Zeitperiode", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_16_NICHT_AUTOMATISCH_BEMANNT_NICHT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("nicht automatisch, bemannt, nicht ereignisgesteuert, normale Zeitperiode", 		Byte
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_20_NICHT_AUTOMATISCH_BEMANNT_NICHT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("nicht automatisch, bemannt, nicht ereignisgesteuert, verlängerte Zeitperiode", 		Byte
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_24_NICHT_AUTOMATISCH_BEMANNT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("nicht automatisch, bemannt, ereignisgesteuert, normale Zeitperiode", 		Byte
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_28_NICHT_AUTOMATISCH_BEMANNT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("nicht automatisch, bemannt, ereignisgesteuert, verlängerte Zeitperiode", 		Byte
	.valueOf("28"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_32_AUTOMATISCH_NICHT_BEMANNT_NICHT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("automatisch, nicht bemannt, nicht ereignisgesteuert, normale Zeitperiode", 		Byte
	.valueOf("32"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_36_AUTOMATISCH_NICHT_BEMANNT_NICHT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("automatisch, nicht bemannt, nicht ereignisgesteuert, verlängerte Zeitperiode", 		Byte
	.valueOf("36"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_40_AUTOMATISCH_NICHT_BEMANNT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("automatisch, nicht bemannt, ereignisgesteuert, normale Zeitperiode", 		Byte
	.valueOf("40"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_44_AUTOMATISCH_NICHT_BEMANNT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("automatisch, nicht bemannt, ereignisgesteuert, verlängerte Zeitperiode", 		Byte
	.valueOf("44"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_48_AUTOMATISCH_BEMANNT_NICHT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("automatisch, bemannt, nicht ereignisgesteuert, normale Zeitperiode", 		Byte
	.valueOf("48"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_52_AUTOMATISCH_BEMANNT_NICHT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("automatisch, bemannt, nicht ereignisgesteuert, verlängerte Zeitperiode", 		Byte
	.valueOf("52"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_56_AUTOMATISCH_BEMANNT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("automatisch, bemannt, ereignisgesteuert, normale Zeitperiode", 		Byte
	.valueOf("56"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_60_AUTOMATISCH_BEMANNT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE = new AttUfdErweiterterStationsTyp("automatisch, bemannt, ereignisgesteuert, verlängerte Zeitperiode", 		Byte
	.valueOf("60"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdErweiterterStationsTyp ZUSTAND_63_UNBEKANNT = new AttUfdErweiterterStationsTyp("unbekannt", 		Byte
	.valueOf("63"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdErweiterterStationsTyp getZustand(final 		Byte
	 value) {
		for (AttUfdErweiterterStationsTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdErweiterterStationsTyp getZustand(final String value) {
		for (AttUfdErweiterterStationsTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdErweiterterStationsTyp> getZustaende() {
		List<AttUfdErweiterterStationsTyp> list = new ArrayList<AttUfdErweiterterStationsTyp>();
		list.add(ZUSTAND_0_NICHT_AUTOMATISCH_NICHT_BEMANNT_NICHT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE);
		list.add(ZUSTAND_4_NICHT_AUTOMATISCH_NICHT_BEMANNT_NICHT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE);
		list.add(ZUSTAND_8_NICHT_AUTOMATISCH_NICHT_BEMANNT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE);
		list.add(ZUSTAND_12_NICHT_AUTOMATISCH_NICHT_BEMANNT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE);
		list.add(ZUSTAND_16_NICHT_AUTOMATISCH_BEMANNT_NICHT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE);
		list.add(ZUSTAND_20_NICHT_AUTOMATISCH_BEMANNT_NICHT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE);
		list.add(ZUSTAND_24_NICHT_AUTOMATISCH_BEMANNT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE);
		list.add(ZUSTAND_28_NICHT_AUTOMATISCH_BEMANNT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE);
		list.add(ZUSTAND_32_AUTOMATISCH_NICHT_BEMANNT_NICHT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE);
		list.add(ZUSTAND_36_AUTOMATISCH_NICHT_BEMANNT_NICHT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE);
		list.add(ZUSTAND_40_AUTOMATISCH_NICHT_BEMANNT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE);
		list.add(ZUSTAND_44_AUTOMATISCH_NICHT_BEMANNT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE);
		list.add(ZUSTAND_48_AUTOMATISCH_BEMANNT_NICHT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE);
		list.add(ZUSTAND_52_AUTOMATISCH_BEMANNT_NICHT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE);
		list.add(ZUSTAND_56_AUTOMATISCH_BEMANNT_EREIGNISGESTEUERT_NORMALE_ZEITPERIODE);
		list.add(ZUSTAND_60_AUTOMATISCH_BEMANNT_EREIGNISGESTEUERT_VERLAENGERTE_ZEITPERIODE);
		list.add(ZUSTAND_63_UNBEKANNT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut ErweiterterStationsTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdErweiterterStationsTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttUfdErweiterterStationsTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
