/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Streckencharakteristik nach DWD (BUFR Codetabelle 0 02 244).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 31L,
	einheit = ""
)
public class AttUfdStreckenTypCharakteristik extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("31");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_0_FREIE_STRECKE_OHNE_WEITERE_ANGABEN = new AttUfdStreckenTypCharakteristik("freie Strecke, ohne weitere Angaben", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_1_FREIE_STRECKE_DAMMLAGE = new AttUfdStreckenTypCharakteristik("freie Strecke, Dammlage", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_2_FREIE_STRECKE_EBEN_ZUR_UMGEBUNG = new AttUfdStreckenTypCharakteristik("freie Strecke, eben zur Umgebung", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_3_FREIE_STRECKE_WASSERFLAECHEN_IN_DER_UMGEBUNG = new AttUfdStreckenTypCharakteristik("freie Strecke, Wasserflächen in der Umgebung", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_4_FREIE_STRECKE_WALD = new AttUfdStreckenTypCharakteristik("freie Strecke, Wald", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_5_FREIE_STRECKE_EINSCHNITT = new AttUfdStreckenTypCharakteristik("freie Strecke, Einschnitt", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_6_FREIE_STRECKE_KUPPENLAGE = new AttUfdStreckenTypCharakteristik("freie Strecke, Kuppenlage", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_7_FREIE_STRECKE_BEWALDETE_KUPPENLAGE = new AttUfdStreckenTypCharakteristik("freie Strecke, bewaldete Kuppenlage", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_8_FREIE_STRECKE_TALLAGE = new AttUfdStreckenTypCharakteristik("freie Strecke, Tallage", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_9_FREIE_STRECKE_BEWALDETE_TALLAGE = new AttUfdStreckenTypCharakteristik("freie Strecke, bewaldete Tallage", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_10_FREIE_STRECKE_NORDHANG = new AttUfdStreckenTypCharakteristik("freie Strecke, Nordhang", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_11_FREIE_STRECKE_BEWALDETER_NORDHANG = new AttUfdStreckenTypCharakteristik("freie Strecke, bewaldeter Nordhang", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_12_FREIE_STRECKE_SUEDHANG = new AttUfdStreckenTypCharakteristik("freie Strecke, Südhang", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_13_FREIE_STRECKE_BEWALDETER_SUEDHANG = new AttUfdStreckenTypCharakteristik("freie Strecke, bewaldeter Südhang", 		Byte
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_14__14_RESERVIERT_ = new AttUfdStreckenTypCharakteristik("14 (reserviert)", 		Byte
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_15__15_RESERVIERT_ = new AttUfdStreckenTypCharakteristik("15 (reserviert)", 		Byte
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_16__16_RESERVIERT_ = new AttUfdStreckenTypCharakteristik("16 (reserviert)", 		Byte
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_17__17_RESERVIERT_ = new AttUfdStreckenTypCharakteristik("17 (reserviert)", 		Byte
	.valueOf("17"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_18__18_RESERVIERT_ = new AttUfdStreckenTypCharakteristik("18 (reserviert)", 		Byte
	.valueOf("18"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_19__19_RESERVIERT_ = new AttUfdStreckenTypCharakteristik("19 (reserviert)", 		Byte
	.valueOf("19"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_20_BRUECKE_KEINE_WEITEREN_ANGABEN = new AttUfdStreckenTypCharakteristik("Brücke, keine weiteren Angaben", 		Byte
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_21_BRUECKE_UEBER_TAL_IN_EINEM_STADTGEBIET = new AttUfdStreckenTypCharakteristik("Brücke über Tal in einem Stadtgebiet", 		Byte
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_22_BRUECKE_UEBER_TAL_MIT_WALD_WIESEN_ACKER = new AttUfdStreckenTypCharakteristik("Brücke über Tal mit Wald/Wiesen/Acker", 		Byte
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_23_BRUECKE_UEBER_STRASSE_SCHIENE = new AttUfdStreckenTypCharakteristik("Brücke über Straße/Schiene", 		Byte
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_24_BRUECKE_UEBER_GROSSEN_FLUSS_KANAL = new AttUfdStreckenTypCharakteristik("Brücke über großen Fluss/Kanal", 		Byte
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_25_BRUECKE_UEBER_MITTELGROSSEN_FLUSS_KANAL = new AttUfdStreckenTypCharakteristik("Brücke über mittelgroßen Fluss/Kanal", 		Byte
	.valueOf("25"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_26_BRUECKE_UEBER_KLEINEN_FLUSS_KANAL = new AttUfdStreckenTypCharakteristik("Brücke über kleinen Fluss/Kanal", 		Byte
	.valueOf("26"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_27__27_RESERVIERT_ = new AttUfdStreckenTypCharakteristik("27 (reserviert)", 		Byte
	.valueOf("27"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_28__28_RESERVIERT_ = new AttUfdStreckenTypCharakteristik("28 (reserviert)", 		Byte
	.valueOf("28"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_29__29_RESERVIERT_ = new AttUfdStreckenTypCharakteristik("29 (reserviert)", 		Byte
	.valueOf("29"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_30__30_RESERVIERT_ = new AttUfdStreckenTypCharakteristik("30 (reserviert)", 		Byte
	.valueOf("30"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdStreckenTypCharakteristik ZUSTAND_31_UNBEKANNT = new AttUfdStreckenTypCharakteristik("unbekannt", 		Byte
	.valueOf("31"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdStreckenTypCharakteristik getZustand(final 		Byte
	 value) {
		for (AttUfdStreckenTypCharakteristik e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdStreckenTypCharakteristik getZustand(final String value) {
		for (AttUfdStreckenTypCharakteristik e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdStreckenTypCharakteristik> getZustaende() {
		List<AttUfdStreckenTypCharakteristik> list = new ArrayList<AttUfdStreckenTypCharakteristik>();
		list.add(ZUSTAND_0_FREIE_STRECKE_OHNE_WEITERE_ANGABEN);
		list.add(ZUSTAND_1_FREIE_STRECKE_DAMMLAGE);
		list.add(ZUSTAND_2_FREIE_STRECKE_EBEN_ZUR_UMGEBUNG);
		list.add(ZUSTAND_3_FREIE_STRECKE_WASSERFLAECHEN_IN_DER_UMGEBUNG);
		list.add(ZUSTAND_4_FREIE_STRECKE_WALD);
		list.add(ZUSTAND_5_FREIE_STRECKE_EINSCHNITT);
		list.add(ZUSTAND_6_FREIE_STRECKE_KUPPENLAGE);
		list.add(ZUSTAND_7_FREIE_STRECKE_BEWALDETE_KUPPENLAGE);
		list.add(ZUSTAND_8_FREIE_STRECKE_TALLAGE);
		list.add(ZUSTAND_9_FREIE_STRECKE_BEWALDETE_TALLAGE);
		list.add(ZUSTAND_10_FREIE_STRECKE_NORDHANG);
		list.add(ZUSTAND_11_FREIE_STRECKE_BEWALDETER_NORDHANG);
		list.add(ZUSTAND_12_FREIE_STRECKE_SUEDHANG);
		list.add(ZUSTAND_13_FREIE_STRECKE_BEWALDETER_SUEDHANG);
		list.add(ZUSTAND_14__14_RESERVIERT_);
		list.add(ZUSTAND_15__15_RESERVIERT_);
		list.add(ZUSTAND_16__16_RESERVIERT_);
		list.add(ZUSTAND_17__17_RESERVIERT_);
		list.add(ZUSTAND_18__18_RESERVIERT_);
		list.add(ZUSTAND_19__19_RESERVIERT_);
		list.add(ZUSTAND_20_BRUECKE_KEINE_WEITEREN_ANGABEN);
		list.add(ZUSTAND_21_BRUECKE_UEBER_TAL_IN_EINEM_STADTGEBIET);
		list.add(ZUSTAND_22_BRUECKE_UEBER_TAL_MIT_WALD_WIESEN_ACKER);
		list.add(ZUSTAND_23_BRUECKE_UEBER_STRASSE_SCHIENE);
		list.add(ZUSTAND_24_BRUECKE_UEBER_GROSSEN_FLUSS_KANAL);
		list.add(ZUSTAND_25_BRUECKE_UEBER_MITTELGROSSEN_FLUSS_KANAL);
		list.add(ZUSTAND_26_BRUECKE_UEBER_KLEINEN_FLUSS_KANAL);
		list.add(ZUSTAND_27__27_RESERVIERT_);
		list.add(ZUSTAND_28__28_RESERVIERT_);
		list.add(ZUSTAND_29__29_RESERVIERT_);
		list.add(ZUSTAND_30__30_RESERVIERT_);
		list.add(ZUSTAND_31_UNBEKANNT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StreckentypCharakteristik.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdStreckenTypCharakteristik(final 		Byte
	 value) {
		super(value);
	}
	
	private AttUfdStreckenTypCharakteristik(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
