/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmswis.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Charakterisierende Daten einer Sensorengruppe (als logisches Strukturelement).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdUfdSensorGruppe extends AbstractKonfigurationsDatensatz<KdUfdSensorGruppe.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				 _strasse
				;
				private 	Double
				 _station
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
				 _himmelsrichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttFahrbahnRichtung
				 _fahrbahnrichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdPositionFahrbahnSensor
				 _positionFahrbahnsensor
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlUfdStreckenTyp
				 _streckenTyp
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlUfdStreckenTyp
				()
				;
		
			/**
			Verweis auf Straße.
			<p>
			
			</p>
			
			@return der Wert von Strasse.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				 getStrasse() {
				return _strasse;
			}
		
			/**
			Verweis auf Straße.
			<p>
			
			</p>
			
			@param _strasse der neue Wert von Strasse.
			*/
			public void setStrasse(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
			 _strasse) {
				this._strasse = _strasse;
			}
		
			/**
			Stationierung auf der Strecken die über zwei Netzknoten eindeutig referenziert werden kann.
			<p>
			
			</p>
			
			@return der Wert von Station.
			*/
				public 	Double
				 getStation() {
				return _station;
			}
		
			/**
			Stationierung auf der Strecken die über zwei Netzknoten eindeutig referenziert werden kann.
			<p>
			
			</p>
			
			@param _station der neue Wert von Station.
			*/
			public void setStation(	Double
			 _station) {
				this._station = _station;
			}
		
			/**
			Himmelsrichtung zur Angabe der Richtung u.a. von Richtungsquerschnitten.
			<p>
			
			</p>
			
			@return der Wert von Himmelsrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
				 getHimmelsrichtung() {
				return _himmelsrichtung;
			}
		
			/**
			Himmelsrichtung zur Angabe der Richtung u.a. von Richtungsquerschnitten.
			<p>
			
			</p>
			
			@param _himmelsrichtung der neue Wert von Himmelsrichtung.
			*/
			public void setHimmelsrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
			 _himmelsrichtung) {
				this._himmelsrichtung = _himmelsrichtung;
			}
		
			/**
			Fahrbahnrichtung in Grad 0°=Norden, 90°=Osten, usw.
			<p>
			Richtung in der eine Fahrbahn an einen bestimmten Punkt verläuft.
			</p>
			
			@return der Wert von Fahrbahnrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttFahrbahnRichtung
				 getFahrbahnrichtung() {
				return _fahrbahnrichtung;
			}
		
			/**
			Fahrbahnrichtung in Grad 0°=Norden, 90°=Osten, usw.
			<p>
			Richtung in der eine Fahrbahn an einen bestimmten Punkt verläuft.
			</p>
			
			@param _fahrbahnrichtung der neue Wert von Fahrbahnrichtung.
			*/
			public void setFahrbahnrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttFahrbahnRichtung
			 _fahrbahnrichtung) {
				this._fahrbahnrichtung = _fahrbahnrichtung;
			}
		
			/**
			Position des Fahrbahnsensors (BUFR Codetabelle 0 02 242).
			<p>
			
			</p>
			
			@return der Wert von PositionFahrbahnsensor.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdPositionFahrbahnSensor
				 getPositionFahrbahnsensor() {
				return _positionFahrbahnsensor;
			}
		
			/**
			Position des Fahrbahnsensors (BUFR Codetabelle 0 02 242).
			<p>
			
			</p>
			
			@param _positionFahrbahnsensor der neue Wert von PositionFahrbahnsensor.
			*/
			public void setPositionFahrbahnsensor(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdPositionFahrbahnSensor
			 _positionFahrbahnsensor) {
				this._positionFahrbahnsensor = _positionFahrbahnsensor;
			}
		
			/**
			Streckentyp nach Definition des DWD.
			<p>
			
			</p>
			
			@return der Wert von StreckenTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlUfdStreckenTyp
				 getStreckenTyp() {
				return _streckenTyp;
			}
		
			/**
			Streckentyp nach Definition des DWD.
			<p>
			
			</p>
			
			@param _streckenTyp der neue Wert von StreckenTyp.
			*/
			public void setStreckenTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AtlUfdStreckenTyp
			 _streckenTyp) {
				this._streckenTyp = _streckenTyp;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soStrasse = getStrasse();
						final SystemObject tmpStrasse;
							if (soStrasse instanceof SystemObject) {
								tmpStrasse = (SystemObject)soStrasse;
							} else if(soStrasse instanceof SystemObjekt){
								tmpStrasse = ((SystemObjekt)soStrasse).getSystemObject();
							} else{
								tmpStrasse = null;
							}
						datum.getReferenceValue("Straße").setSystemObject(tmpStrasse);
					// KommazahlAttributTyp
					if (getStation() != null) {
						datum.getUnscaledValue("Station").set(getStation());
					}
					// GanzzahlAttributTyp
					if (getHimmelsrichtung() != null) {
		                if (getHimmelsrichtung().isZustand()) {
		                    datum.getUnscaledValue("Himmelsrichtung").setText(getHimmelsrichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Himmelsrichtung").set(getHimmelsrichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFahrbahnrichtung() != null) {
		                if (getFahrbahnrichtung().isZustand()) {
		                    datum.getUnscaledValue("Fahrbahnrichtung").setText(getFahrbahnrichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Fahrbahnrichtung").set(getFahrbahnrichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPositionFahrbahnsensor() != null) {
		                if (getPositionFahrbahnsensor().isZustand()) {
		                    datum.getUnscaledValue("PositionFahrbahnsensor").setText(getPositionFahrbahnsensor().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PositionFahrbahnsensor").set(getPositionFahrbahnsensor().getValue());
		                }
					}
					// AttributListenDefinition
						getStreckenTyp().bean2Atl(datum.getItem("StreckenTyp"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idStrasse = daten.getReferenceValue("Straße").getId();
						final SystemObjekt tmpStrasse;
						if (idStrasse == 0) {
							tmpStrasse = null;
						} else {
							final SystemObject soStrasse = factory.getDav().getDataModel().getObject(idStrasse);
							if (soStrasse == null) {
									tmpStrasse = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrasseUngueltig(idStrasse);
							} else {
								tmpStrasse = factory.getModellobjekt(soStrasse);
							}
						}
						setStrasse((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
						) tmpStrasse);
					// KommazahlAttributTyp
						setStation(daten.getUnscaledValue("Station").
							doubleValue()
						);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Himmelsrichtung").isState()) {
								setHimmelsrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
								.getZustand(daten.getScaledValue("Himmelsrichtung").getText()));
							} else {
							setHimmelsrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
							(daten.
								getUnscaledValue
							("Himmelsrichtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setFahrbahnrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttFahrbahnRichtung
							(daten.
								getUnscaledValue
							("Fahrbahnrichtung").
									intValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PositionFahrbahnsensor").isState()) {
								setPositionFahrbahnsensor(de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdPositionFahrbahnSensor
								.getZustand(daten.getScaledValue("PositionFahrbahnsensor").getText()));
							} else {
							setPositionFahrbahnsensor(new de.bsvrz.sys.funclib.bitctrl.modell.tmswis.attribute.AttUfdPositionFahrbahnSensor
							(daten.
								getUnscaledValue
							("PositionFahrbahnsensor").
									byteValue
							()));
							}
					// AttributListenDefinition
						getStreckenTyp().atl2Bean(daten.getItem("StreckenTyp"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setStrasse(getStrasse());
							klon.setStation(getStation());
							klon.setHimmelsrichtung(getHimmelsrichtung());
							klon.setFahrbahnrichtung(getFahrbahnrichtung());
							klon.setPositionFahrbahnsensor(getPositionFahrbahnsensor());
							klon._streckenTyp = getStreckenTyp().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ufdSensorGruppe";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdUfdSensorGruppe(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
