/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ortstyp des Ortes.
<p>
&lt;absatz&gt;Für die Sprachunabhängigkeit der weitergegebenen Informationen und zur Mitteilung an das empfangende System, welche Datenfelder zu erwarten sind, sind Ortstypen und Untertypen erforderlich. Innerhalb einer jeden Kategorie wird (grundsätzlich) nach Ortstypen unterschieden, sofern für einen Ort ein funktionaler Unterschied besteht in der Art, wie er vom Empfänger einer Meldung zu behandeln ist.&lt;&#47;absatz&gt;
					&lt;absatz&gt;Orts- und Untertypen werden gemeinsam kodiert. Dabei gilt folgendes Kodierschema:&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Der TMC-Typ 'Punkt', 'Linie' oder 'Gebiet' ergibt sich aus dem Objekttyp
							&lt;verweis pid="typ.tmcPunkt"&gt;&lt;&#47;verweis&gt;
							,
							&lt;verweis pid="typ.tmcLinie"&gt;&lt;&#47;verweis&gt;
							oder
							&lt;verweis pid="typ.tmcGebiet"&gt;&lt;&#47;verweis&gt;
							.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Der Name wird gebildet aus 'OrtTypName:UntertypName', wobei 'UnterTypName' gleich 'Allgemein' verwendet wird, sofern kein Untertyp vorhanden ist.&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Der Wert des Aufzahlungstyps ist eine sechsstellige Zahl der Form TNNSSS mit T gleich Typ (1=Punkt, 2=Linie, 3=Gebiet), NN gleich Orttypnummer und SSS gleich Untertypnummer entsprechend LCL, jeweils mit führenden Nullen.&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
@Wertebereich(
	minimum = 0L,
	maximum = 999999L,
	einheit = ""
)
public class AttTmcOrtsTyp extends Zahl<		Integer
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MIN_VALUE =
				Integer
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MAX_VALUE =
				Integer
		.valueOf("999999");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	Einer der sieben Kontinente.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_301000_KONTINENT_ALLGEMEIN = new AttTmcOrtsTyp("Kontinent:Allgemein", 		Integer
	.valueOf("301000"));

	/**
	Anerkannte Gruppe aneinander grenzender Länder mit einen gemeinsamen Namen.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_302000_LAENDERGRUPPE_ALLGEMEIN = new AttTmcOrtsTyp("Ländergruppe:Allgemein", 		Integer
	.valueOf("302000"));

	/**
	Gebiet eines souveränen Staates.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_303000_LAND_ALLGEMEIN = new AttTmcOrtsTyp("Land:Allgemein", 		Integer
	.valueOf("303000"));

	/**
	Benanntes Wassergebiet, für welches Verkehrs- und Reisemeldungen gegeben werden können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_304000_WASSERGEBIET_ALLGEMEIN = new AttTmcOrtsTyp("Wassergebiet:Allgemein", 		Integer
	.valueOf("304000"));

	/**
	Benanntes Wassergebiet, welches mit den Weltmeeren verbunden ist oder an diese grenzt.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_304001_WASSERGEBIET_MEER = new AttTmcOrtsTyp("Wassergebiet:Meer", 		Integer
	.valueOf("304001"));

	/**
	Benanntes Wassergebiet, welches physisch von den Weltmeeren getrennt ist.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_304002_WASSERGEBIET_BINNEN_SEE = new AttTmcOrtsTyp("Wassergebiet:(Binnen)see", 		Integer
	.valueOf("304002"));

	/**
	Benanntes Landgebiet (das nicht ein Unterglied in der folgenden Hierarchie ist), für welches Meldungen gegeben werden können, zul. Abweichung seiner Größe weniger als 10%.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_306000_UNSCHARFES_GEBIET_ALLGEMEIN = new AttTmcOrtsTyp("Unscharfes Gebiet:Allgemein", 		Integer
	.valueOf("306000"));

	/**
	Gebiet mit touristischem Charakter.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_306001_UNSCHARFES_GEBIET_TOURISTISCHES_GEBIET = new AttTmcOrtsTyp("Unscharfes Gebiet:Touristisches Gebiet", 		Integer
	.valueOf("306001"));

	/**
	Gebiet mit großstädtischem Charakter.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_306002_UNSCHARFES_GEBIET_BALLUNGSRAUM = new AttTmcOrtsTyp("Unscharfes Gebiet:Ballungsraum", 		Integer
	.valueOf("306002"));

	/**
	Gebiet mit einer signifikanten Konzentration von Industriebetrieben.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_306003_UNSCHARFES_GEBIET_INDUSTRIEREGION = new AttTmcOrtsTyp("Unscharfes Gebiet:Industrieregion", 		Integer
	.valueOf("306003"));

	/**
	Komplexes Verkehrsgebiet mit zwei oder mehr Anschlüssen und&#47;oder Knotenpunkten.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_306004_UNSCHARFES_GEBIET_VERKEHRSGEBIET = new AttTmcOrtsTyp("Unscharfes Gebiet:Verkehrsgebiet", 		Integer
	.valueOf("306004"));

	/**
	Gebiet für das Wettermeldungen gegeben werden können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_306005_UNSCHARFES_GEBIET_METEOROLOGISCHES_GEBIET = new AttTmcOrtsTyp("Unscharfes Gebiet:Meteorologisches Gebiet", 		Integer
	.valueOf("306005"));

	/**
	Zugewiesenes Gebiet, wo Verkehrsteilnehmer parken und sich zur Bildung von Fahrgemeinschaften Fahrgemeinschaften treffen können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_306006_UNSCHARFES_GEBIET_SAMMELPARKPLATZ = new AttTmcOrtsTyp("Unscharfes Gebiet:Sammelparkplatz", 		Integer
	.valueOf("306006"));

	/**
	Zugewiesenes Gebiet, wo Verkehrsteilnehmer parken können zum Umsteigen in den ÖPNV.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_306007_UNSCHARFES_GEBIET_P_R_PARKPLATZ = new AttTmcOrtsTyp("Unscharfes Gebiet:P+R-Parkplatz", 		Integer
	.valueOf("306007"));

	/**
	Zugewiesenes Gebiet, wo Verkehrsteilnehmer parken können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_306008_UNSCHARFES_GEBIET_PARKPLATZ = new AttTmcOrtsTyp("Unscharfes Gebiet:Parkplatz", 		Integer
	.valueOf("306008"));

	/**
	Verwaltungsgebiet der 1.Ebene (unter A3), die jedoch nicht die kleinste des Landes sein muss.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_307000__GEBIET_1_ORDNUNG_BUNDESLAND_ALLGEMEIN = new AttTmcOrtsTyp("(Gebiet 1. Ordnung) Bundesland:Allgemein", 		Integer
	.valueOf("307000"));

	/**
	Verwaltungsgebiet der 2.Ebene, die jedoch nicht die kleinste des Landes sein muss.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_308000__GEBIET_2_ORDNUNG_REGIERUNGSBEZIRK_ALLGEMEIN = new AttTmcOrtsTyp("(Gebiet 2.Ordnung) Regierungsbezirk:Allgemein", 		Integer
	.valueOf("308000"));

	/**
	Verwaltungsgebiet der 3.Ebene, die jedoch nicht die kleinste des Landes sein muss.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_309000__GEBIET_3_ORDNUNG_KREIS_KREISFREIE_STADT_ALLGEMEIN = new AttTmcOrtsTyp("(Gebiet 3.Ordnung) Kreis/kreisfreie Stadt:Allgemein", 		Integer
	.valueOf("309000"));

	/**
	Gebiet der 3. Ebene mit ländlichem Charakter.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_309001__GEBIET_3_ORDNUNG_KREIS_KREISFREIE_STADT_KREIS_LANDKREIS = new AttTmcOrtsTyp("(Gebiet 3.Ordnung) Kreis/kreisfreie Stadt:Kreis/Landkreis", 		Integer
	.valueOf("309001"));

	/**
	Gebiet der 3.Ebene mit städtischem Charakter.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_309002__GEBIET_3_ORDNUNG_KREIS_KREISFREIE_STADT_KREISFREIE_STADT = new AttTmcOrtsTyp("(Gebiet 3.Ordnung) Kreis/kreisfreie Stadt:Kreisfreie Stadt", 		Integer
	.valueOf("309002"));

	/**
	Gebiet der 4.Ebene, die jedoch nicht die kleinste des Landes sein muss.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_310000_GEMEINDE_STADT_ALLGEMEIN = new AttTmcOrtsTyp("Gemeinde/Stadt:Allgemein", 		Integer
	.valueOf("310000"));

	/**
	Gebiet der 5.Ebene, die auch die niedrigste administrative Ebene des Landes ist.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_311000_GEMEINDETEIL_STADTTEIL_ALLGEMEIN = new AttTmcOrtsTyp("Gemeindeteil/Stadtteil:Allgemein", 		Integer
	.valueOf("311000"));

	/**
	Teilgebiet eines der definierten administrativen Gebiete.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_312000_TEILGEBIET_EINES_ADMINISTRATIVEN_GEBIETES_DER_EBENEN_A7_BIS_A11_ALLGEMEIN = new AttTmcOrtsTyp("Teilgebiet (eines administrativen Gebietes der Ebenen A7 bis A11):Allgemein", 		Integer
	.valueOf("312000"));

	/**
	Ein oder mehrere ineinander übergehende Abschnitte einer Straße innerhalb eines einzigen nationalen oder für eine Ebene gültigen Numerierungsgebietes, dessen&#47;deren Endpunkte sich an unterschiedlichen Orten befinden.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_201000_STRASSE_ALLGEMEIN = new AttTmcOrtsTyp("Straße:Allgemein", 		Integer
	.valueOf("201000"));

	/**
	(mit Zeichen 330 gekennzeichnete Straße) gewidmet als Autobahn.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_201001_STRASSE_STRASSE_1_ORDNUNG_BUNDESAUTOBAHN = new AttTmcOrtsTyp("Straße:(Straße 1.Ordnung) Bundesautobahn", 		Integer
	.valueOf("201001"));

	/**
	(Straße 1.Klasse) gewidmet als Bundesstraße.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_201002_STRASSE_STRASSE_2_ORDNUNG_BUNDESSTRASSE = new AttTmcOrtsTyp("Straße:(Straße 2.Ordnung) Bundesstraße", 		Integer
	.valueOf("201002"));

	/**
	(Straße 2.Klasse) gewidmet als Landesstraße, Staatsstraße.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_201003_STRASSE_LANDES_ODER_STAATSSTRASSE = new AttTmcOrtsTyp("Straße:Landes-oder Staatsstraße", 		Integer
	.valueOf("201003"));

	/**
	(Straße 3.Klasse) gewidmet als Kreisstraße.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_201004_STRASSE_KREISSTRASSE_GEMEINDESTRASSE = new AttTmcOrtsTyp("Straße:Kreisstraße, Gemeindestraße", 		Integer
	.valueOf("201004"));

	/**
	Straße ohne Endpunkte, die einen fortlaufenden Ring bildet, durchgehend mit einer einzigen Straßennummmer.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_202000_RINGSTRASSE_ALLGEMEIN = new AttTmcOrtsTyp("Ringstraße:Allgemein", 		Integer
	.valueOf("202000"));

	/**
	Ringautobahn ohne Anfangs- und Endpunkt.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_202001_RINGSTRASSE_BAB_RING = new AttTmcOrtsTyp("Ringstraße:BAB-Ring", 		Integer
	.valueOf("202001"));

	/**
	Ringstraße, die keine Autobahn ist.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_202002_RINGSTRASSE_RINGSTRASSE = new AttTmcOrtsTyp("Ringstraße:Ringstraße", 		Integer
	.valueOf("202002"));

	/**
	Streckenabschnitt 1. Ordnung von L1, L2, L6.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_203000_STRECKENABSCHNITT_1_ORDNUNG_ALLGEMEIN = new AttTmcOrtsTyp("Streckenabschnitt 1.Ordnung:Allgemein", 		Integer
	.valueOf("203000"));

	/**
	(Teil)abschnitt eines Abschnittes 1.Ordnung.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_204000_STRECKENABSCHNITT_2_ORDNUNG_ALLGEMEIN = new AttTmcOrtsTyp("Streckenabschnitt 2.Ordnung:Allgemein", 		Integer
	.valueOf("204000"));

	/**
	Straße in einer Gemeinde&#47;Stadt, die gewöhnlich durch einen Straßennamen, weniger durch eine Nummer bezeichnet ist.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_205000_GEMEINDESTRASSE_STADTSTRASSE_ALLGEMEIN = new AttTmcOrtsTyp("Gemeindestraße Stadtstraße:Allgemein", 		Integer
	.valueOf("205000"));

	/**
	Netzsegment, das nicht Teil einer Straße ist, für den Transport per Schiff oder auf der Schiene.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_206000_VERKEHRSVERBINDUNG_ALLGEMEIN = new AttTmcOrtsTyp("Verkehrsverbindung:Allgemein", 		Integer
	.valueOf("206000"));

	/**
	Spezieller Dienst, der mittels RO-RO-Schiff Straßenfahrzeuge zwischen zwei Punkten transportiert.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_206001_VERKEHRSVERBINDUNG_FAEHRVERBINDUNG = new AttTmcOrtsTyp("Verkehrsverbindung:Fährverbindung", 		Integer
	.valueOf("206001"));

	/**
	Spezieller Dienst, der mittels Zug Straßenfahrzeuge zwischen zwei Punkten transportiert.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_206002_VERKEHRSVERBINDUNG_AUTOREISEZUGVERBINDUNG = new AttTmcOrtsTyp("Verkehrsverbindung:Autoreisezugverbindung", 		Integer
	.valueOf("206002"));

	/**
	Punkt auf einer Straße&#47;Ringstraße, wo eine oder mehrere andere Straßen&#47;Ringstraßen angeschlossen sind.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101000_KNOTENPUNKT_ALLGEMEIN = new AttTmcOrtsTyp("Knotenpunkt:Allgemein", 		Integer
	.valueOf("101000"));

	/**
	Knotenpunkt mit unterschiedlichem Straßenniveau, wo sich zwei oder mehrere Autobahnen kreuzen und wo einige (oder alle) Fahrtrichtungen möglich sind.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101001_KNOTENPUNKT_AUTOBAHNKREUZ = new AttTmcOrtsTyp("Knotenpunkt:Autobahnkreuz", 		Integer
	.valueOf("101001"));

	/**
	Knotenpunkt mit unterschiedlichem Straßenniveau, wo eine Autobahn mit eingeschränktem Zugang auf eine durchgehende Autobahn trifft, auf welcher einige (oder alle) Fahrtrichtungen zulässig sind.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101002_KNOTENPUNKT_AUTOBAHNDREIECK = new AttTmcOrtsTyp("Knotenpunkt:Autobahndreieck", 		Integer
	.valueOf("101002"));

	/**
	Knotenpunkt mit unterschiedlichem Straßenniveau, wo der Verkehr auf eine Autobahn mit beschränktem Zugang aus dem allgemeinen Straßennetz einfahren bzw, von der Autobahn in dieses ausfahren kann.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101003_KNOTENPUNKT_AUTOBAHNANSCHLUSSSTELLE = new AttTmcOrtsTyp("Knotenpunkt:Autobahnanschlussstelle", 		Integer
	.valueOf("101003"));

	/**
	Knotenpunkt mit unterschiedlichem Straßenniveau, wo der Verkehr lediglich von einer Autobahn in das allgemeine Straßennetz ausfahren kann.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101004_KNOTENPUNKT_AUTOBAHNAUSFAHRT = new AttTmcOrtsTyp("Knotenpunkt:Autobahnausfahrt", 		Integer
	.valueOf("101004"));

	/**
	Knotenpunkt mit unterschiedlichem Straßenniveau, wo der Verkehr lediglich in eine Autobahn aus dem allgemeinen Straßennetz einfahren kann.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101005_KNOTENPUNKT_AUTOBAHNEINFAHRT = new AttTmcOrtsTyp("Knotenpunkt:Autobahneinfahrt", 		Integer
	.valueOf("101005"));

	/**
	Knotenpunkt mit Überführung durchgehender Fahrbahnen einer Straße über eine oder mehrere andere Straßen und Anschluss an diese.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101006_KNOTENPUNKT_UEBERFUEHRUNG = new AttTmcOrtsTyp("Knotenpunkt:Überführung", 		Integer
	.valueOf("101006"));

	/**
	Knotenpunkt, bei dem durchgehende Fahr-bahnen einer Straße unter einer oder mehreren anderen Straßen hindurchgeführt werden und Anschluss an diese.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101007_KNOTENPUNKT_UNTERFUEHRUNG = new AttTmcOrtsTyp("Knotenpunkt:Unterführung", 		Integer
	.valueOf("101007"));

	/**
	Knotenpunkt, wo der Verkehr um eine zentrale Verkehrsinsel geführt wird.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101008_KNOTENPUNKT_KLEINER_KREISVERKEHR_SPLATZ_ = new AttTmcOrtsTyp("Knotenpunkt:Kleiner Kreisverkehr(splatz)", 		Integer
	.valueOf("101008"));

	/**
	Knotenpunkt, an dem der Verkehr mehrstreifig um eine sehr große zentrale Verkehrsinsel geführt wird, auf welcher normalerweise Gebäude, Denkmäler stehen. Die Zufahrt kann durch Lichtsignalregelung, Vorfahrtsregelung oder unkontrolliert erfolgen.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101009_KNOTENPUNKT_GROSSER_KREISVERKEHR_SPLATZ_ = new AttTmcOrtsTyp("Knotenpunkt:Großer Kreisverkehr(splatz)", 		Integer
	.valueOf("101009"));

	/**
	Knotenpunkt, von zwei oder mehreren Straßen mit Lichtsignalregelung.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101010_KNOTENPUNKT_LICHTSIGNALGEREGELTER_KNOTENPUNKT = new AttTmcOrtsTyp("Knotenpunkt:Lichtsignalgeregelter Knotenpunkt", 		Integer
	.valueOf("101010"));

	/**
	Knotenpunkt von zwei oder mehr Straßen mit beschilderter Vorfahrt oder ohne Vorfahrts-regelung ('Rechts' vor 'Links').
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101011_KNOTENPUNKT_KREUZUNG = new AttTmcOrtsTyp("Knotenpunkt:Kreuzung", 		Integer
	.valueOf("101011"));

	/**
	Knotenpunkt einer durchgehenden mit einer einmündenden Straße mit oder ohne Vorfahrtsregelung.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101012_KNOTENPUNKT_EINMUENDUNG = new AttTmcOrtsTyp("Knotenpunkt:Einmündung", 		Integer
	.valueOf("101012"));

	/**
	Punkt auf einer Straße, an dem sich ein wesentliches Attribut der Straße ändert (Straßennummer, -name oder der administrative Status).
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101013_KNOTENPUNKT_UEBERGANG = new AttTmcOrtsTyp("Knotenpunkt:Übergang", 		Integer
	.valueOf("101013"));

	/**
	Einzelfahrbahn von begrenzter Länge, welche zwei Straßen miteinander verbindet.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101014_KNOTENPUNKT_KURZE_VERBINDUNGSSTRASSE_QUERSPANGE = new AttTmcOrtsTyp("Knotenpunkt:Kurze Verbindungsstraße, Querspange", 		Integer
	.valueOf("101014"));

	/**
	Oberbegriff Ausfahrt für jeglichen Zweck.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_101015_KNOTENPUNKT_AUSFAHRT = new AttTmcOrtsTyp("Knotenpunkt:Ausfahrt", 		Integer
	.valueOf("101015"));

	/**
	Punkt zwischen zwei Knotenpunkten, auf den in Verkehrs- und Reisemeldungen Bezug genommen wird.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_102000_ZWISCHENPUNKT_ALLGEMEIN = new AttTmcOrtsTyp("Zwischenpunkt:Allgemein", 		Integer
	.valueOf("102000"));

	/**
	Vordefinierter Punkt zwischen Knotenpunkten, dessen einziger Zweck darin besteht, für Ortsangaben eine höhere Auflösung zu erhalten. Diese Punkte sind gewöhnlich Kilometerangaben und gelten für beide Fahrtrichtungen.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_102001_ZWISCHENPUNKT_STRECKENMARKE_KILOMETRIERUNG = new AttTmcOrtsTyp("Zwischenpunkt:(Streckenmarke)Kilometrierung", 		Integer
	.valueOf("102001"));

	/**
	Punkt, an dem Verkehrsdaten in einer oder beiden Richtungen erfasst werden.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_102002_ZWISCHENPUNKT_VERKEHRSERFASSUNGSSTATION = new AttTmcOrtsTyp("Zwischenpunkt:Verkehrserfassungsstation", 		Integer
	.valueOf("102002"));

	/**
	Punkt, der in Verkehrs- und Reisemeldungen von Interesse ist.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103000_SONSTIGER_MARKANTER_PUNKT_ALLGEMEIN = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Allgemein", 		Integer
	.valueOf("103000"));

	/**
	Markanter,mit Namen versehener Punkt, wo die Straße über eine signifikante Strecke eingehüllt ist.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103001_SONSTIGER_MARKANTER_PUNKT_TUNNEL = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Tunnel", 		Integer
	.valueOf("103001"));

	/**
	Markanter, mit Namen versehene Punkt, wo die Straße von einem Hochbauwerk getragen wird.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103002_SONSTIGER_MARKANTER_PUNKT_BRUECKE = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Brücke", 		Integer
	.valueOf("103002"));

	/**
	Dezidierter Ort, wo die Kraftfahrer halten und eine Reihe von Dienstleistungen nutzen können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103003_SONSTIGER_MARKANTER_PUNKT_RASTSTAETTE = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Raststätte", 		Integer
	.valueOf("103003"));

	/**
	Dezidierter Ort, wo die Kraftfahrer halten und eine begrenzte Reihe von Einrichtungen nutzen können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103004_SONSTIGER_MARKANTER_PUNKT_RASTPLATZ_MIT_EINZELNEN_EINRICHTUNGEN = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Rastplatz mit einzelnen Einrichtungen", 		Integer
	.valueOf("103004"));

	/**
	Dezidierter Ort, wo die Kraftfahrer halten und eine Aussicht haben können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103005_SONSTIGER_MARKANTER_PUNKT_AUSSICHTSPUNKT = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Aussichtspunkt", 		Integer
	.valueOf("103005"));

	/**
	Festgelegter Platz, wo die Kraftfahrer parken und sich zur Bildung von Fahrgemeinschaften treffen können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103006_SONSTIGER_MARKANTER_PUNKT_MITFAHRERSAMMELPARKPLATZ = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Mitfahrersammelparkplatz", 		Integer
	.valueOf("103006"));

	/**
	Dezidierter Ort, wo die Kraftfahrer parken und auf öffentliche Verkehrsmittel umsteigen können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103007_SONSTIGER_MARKANTER_PUNKT_P_R_PARKPLATZ = new AttTmcOrtsTyp("Sonstiger markanter Punkt:P+R-Parkplatz", 		Integer
	.valueOf("103007"));

	/**
	Dezidierter Ort, wo die Kraftfahrer parken können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103008_SONSTIGER_MARKANTER_PUNKT_PARKPLATZ = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Parkplatz", 		Integer
	.valueOf("103008"));

	/**
	Dezidierter Ort, wo Kraftfahrer begrenzte Einkaufsmöglichkeiten haben.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103009_SONSTIGER_MARKANTER_PUNKT_PARKPLATZ_MIT_KIOSK = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Parkplatz mit Kiosk", 		Integer
	.valueOf("103009"));

	/**
	Dezidierter Ort, wo Kraftfahrer eine begrenzte Reihe von Einrichtungen nutzen können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103010_SONSTIGER_MARKANTER_PUNKT_PARKPLATZ_MIT_KIOSK_WC = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Parkplatz mit Kiosk + WC", 		Integer
	.valueOf("103010"));

	/**
	Dezidierter Ort, wo Kraftfahrer Treibstoff kaufen können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103011_SONSTIGER_MARKANTER_PUNKT_TANKSTELLE = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Tankstelle", 		Integer
	.valueOf("103011"));

	/**
	Dezidierter Ort, mit einem eingeschränktem Angebot von Einrichtungen.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103012_SONSTIGER_MARKANTER_PUNKT_TANKSTELLE_MIT_KIOSK = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Tankstelle mit Kiosk", 		Integer
	.valueOf("103012"));

	/**
	Dezidierter Ort, wo den Kraftfahrern Unterkunft anboten wird.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103013_SONSTIGER_MARKANTER_PUNKT_MOTEL = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Motel", 		Integer
	.valueOf("103013"));

	/**
	Ort, wo die Grenze eines administrativen Gebietes ein Segment des Netzes kreuzt.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103014_SONSTIGER_MARKANTER_PUNKT_GRENZUEBERGANG = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Grenzübergang", 		Integer
	.valueOf("103014"));

	/**
	Dezidierter Ort, an dem Zollbeamte tätig sind.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103015_SONSTIGER_MARKANTER_PUNKT_ZOLLSTATION = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Zollstation", 		Integer
	.valueOf("103015"));

	/**
	Dezidierter Ort, wo die Kraftfahrer für die Benutzung gebührenpflichtiger Straßen bezahlen.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103016_SONSTIGER_MARKANTER_PUNKT_MAUTSTATION = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Mautstation", 		Integer
	.valueOf("103016"));

	/**
	Dezidierter Ort, an welchem Autofahrer Zugang zum zum Beladen bzw. Entladen einer Fähre haben.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103017_SONSTIGER_MARKANTER_PUNKT_FAEHRANLIEGER = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Fähranlieger", 		Integer
	.valueOf("103017"));

	/**
	Dezidierter Ort, wo eine Reihe von mit dem Wasser verbundener Einrichtungen arbeitet.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103018_SONSTIGER_MARKANTER_PUNKT_HAFEN = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Hafen", 		Integer
	.valueOf("103018"));

	/**
	Offener Platz, häufig in der Nähe eines Stadtzentrums gelegen, der für eine Vielzahl von Nutzungen zur Verfügung steht.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103019_SONSTIGER_MARKANTER_PUNKT_PLATZ = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Platz", 		Integer
	.valueOf("103019"));

	/**
	Ort, an welchem periodisch (z.B. jährlich) oft traditionelle Veranstaltungen stattfinden zu Zwecken der Unterhaltung oder Handel.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103020_SONSTIGER_MARKANTER_PUNKT_MARKTPLATZ_FEST_PLATZ = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Marktplatz/Fest-platz", 		Integer
	.valueOf("103020"));

	/**
	Festgelegter Platz, wo Kraftfahrer eine begrenzte Anzahl von Einrichtungen nutzen können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103021_SONSTIGER_MARKANTER_PUNKT_PARKHAUS = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Parkhaus", 		Integer
	.valueOf("103021"));

	/**
	Dezidierter Ort unter der Erdoberfläche, an welchem Kraftfahrn ein begrenztes Angebot von Einrichtungen zur Verfügung steht.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103022_SONSTIGER_MARKANTER_PUNKT_TIEFGARAGE = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Tiefgarage", 		Integer
	.valueOf("103022"));

	/**
	Dezidierter Ort, wo Kraftfahrern ein breites Angebot von Einkaufsmöglichkeiten zur Verfügung steht.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103023_SONSTIGER_MARKANTER_PUNKT_EINKAUFSZENTRUM = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Einkaufszentrum", 		Integer
	.valueOf("103023"));

	/**
	Dezidierter Ort für Unterhaltungszwecke.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103024_SONSTIGER_MARKANTER_PUNKT_FREIZEITPARK = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Freizeitpark", 		Integer
	.valueOf("103024"));

	/**
	Dezidierter Ort, wo Autofahrer anhalten und sich eine Sehenswürdigkeit (zu Natur, Gesellschaft, Geschichte oder Handel) ansehen können.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103025_SONSTIGER_MARKANTER_PUNKT_TOURISTENATTRAKTION = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Touristenattraktion", 		Integer
	.valueOf("103025"));

	/**
	Dezidierter Ort einer Bildungseinrichtung, für die Ausbildung von Studenten.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103026_SONSTIGER_MARKANTER_PUNKT_UNIVERSITAET = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Universität", 		Integer
	.valueOf("103026"));

	/**
	Flugplatz mit Einrichtungen für Passagiere und Fracht.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103027_SONSTIGER_MARKANTER_PUNKT_FLUGHAFEN = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Flughafen", 		Integer
	.valueOf("103027"));

	/**
	Dezidierter Ort, reguläre Haltestation des öffentlichen Verkehrs.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103028_SONSTIGER_MARKANTER_PUNKT_BAHNHOF_BUSBAHNHOF = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Bahnhof/Busbahnhof", 		Integer
	.valueOf("103028"));

	/**
	Dezidierter Ort für medizinische und chirurgische Behandlung.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103029_SONSTIGER_MARKANTER_PUNKT_KRANKENHAUS = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Krankenhaus", 		Integer
	.valueOf("103029"));

	/**
	Dezidierter Ort für öffentlichen Gottesdienst.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103030_SONSTIGER_MARKANTER_PUNKT_KIRCHE = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Kirche", 		Integer
	.valueOf("103030"));

	/**
	Dezidierter Ort für öffentliche Unterhaltung.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103031_SONSTIGER_MARKANTER_PUNKT_STADION = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Stadion", 		Integer
	.valueOf("103031"));

	/**
	Dezidierter Ort mit einer Staats- oder Kirchenresidenz oder einem öffentlichen Staatsgebäude.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103032_SONSTIGER_MARKANTER_PUNKT_OEFFENTLICHES_GEBAEUDE = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Öffentliches Gebäude", 		Integer
	.valueOf("103032"));

	/**
	Befestigter Platz, oft mit Türmen und Wehranlagen.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103033_SONSTIGER_MARKANTER_PUNKT_BURG = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Burg", 		Integer
	.valueOf("103033"));

	/**
	Öffentliches Gebäude, häufig Sitz der lokalen Verwaltung.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103034_SONSTIGER_MARKANTER_PUNKT_RATHAUS = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Rathaus", 		Integer
	.valueOf("103034"));

	/**
	Ort zur Durchführung von Messen, Kongres-sen, Ausstellungen und Parteiversammlungen.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103035_SONSTIGER_MARKANTER_PUNKT_AUSSTELLUNGS_KONGRESSZENTRUM = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Ausstellungs-/Kongresszentrum", 		Integer
	.valueOf("103035"));

	/**
	Bewohnte Siedlung, die nicht am gängigen&#47;üblichen Straßennetz liegt.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103036_SONSTIGER_MARKANTER_PUNKT_WEILER = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Weiler", 		Integer
	.valueOf("103036"));

	/**
	Ort an einer innerörtlichen Straße, welcher gemäß den Straßenschildern benannt ist (Gemeinde, Stadt).
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103037_SONSTIGER_MARKANTER_PUNKT_BENANNTER_PUNKT = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Benannter Punkt", 		Integer
	.valueOf("103037"));

	/**
	Straße auf festem Untergrund, welche zwei Wasserflächen voneinander trennt.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103038_SONSTIGER_MARKANTER_PUNKT_DAMM = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Damm", 		Integer
	.valueOf("103038"));

	/**
	Straße auf festem Untergrund, welche eine Wasserfläche und eine Landfläche von einander trennt.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103039_SONSTIGER_MARKANTER_PUNKT_DEICH = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Deich", 		Integer
	.valueOf("103039"));

	/**
	Wasserweg über einer Straße.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103040_SONSTIGER_MARKANTER_PUNKT_AQUAEDUKT = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Aquädukt", 		Integer
	.valueOf("103040"));

	/**
	Wasserwegschleuse.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103041_SONSTIGER_MARKANTER_PUNKT_SCHLEUSE = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Schleuse", 		Integer
	.valueOf("103041"));

	/**
	Straße, die über einen Berg führt. Dieser Subtyp ist bestimmt für jene Bergpässe, die im Winter normalerweise Wetterprobleme (hauptsächlich Schnee und Eis) aufweisen.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103042_SONSTIGER_MARKANTER_PUNKT_PASS = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Pass", 		Integer
	.valueOf("103042"));

	/**
	Straße-Eisenbahn-Kreuzung auf gleichem Niveau.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103043_SONSTIGER_MARKANTER_PUNKT_BAHNUEBERGANG = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Bahnübergang", 		Integer
	.valueOf("103043"));

	/**
	Straße, die durch einen Fluss oder zu einer Insel führt, welche ständig oder in regelmäßigen Abständen überflutet ist.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103044_SONSTIGER_MARKANTER_PUNKT_FURT = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Furt", 		Integer
	.valueOf("103044"));

	/**
	Kurze Fährverbindung zur Überquerung eines Flusses&#47;Kanals (anstelle einer Brücke oder bis zum späteren Ersatz durch eine Brücke).
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103045_SONSTIGER_MARKANTER_PUNKT_FLUSSFAEHRE_BINNENGEWAESSER_ = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Flußfähre (Binnengewässer)", 		Integer
	.valueOf("103045"));

	/**
	Allgemein bekanntes Gebiet, das vorwiegend von der Industrie genutzt wird.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103046_SONSTIGER_MARKANTER_PUNKT_INDUSTRIEGEBIET = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Industriegebiet", 		Integer
	.valueOf("103046"));

	/**
	Bauwerk, auf welchem eine hochgelegene über eine tiefer gelegene Straße, ein Tal oder eine Flußmündung führt.
	<p>
	
	</p>
	*/
	public static final AttTmcOrtsTyp ZUSTAND_103047_SONSTIGER_MARKANTER_PUNKT_VIADUCKT = new AttTmcOrtsTyp("Sonstiger markanter Punkt:Viaduckt", 		Integer
	.valueOf("103047"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTmcOrtsTyp getZustand(final 		Integer
	 value) {
		for (AttTmcOrtsTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTmcOrtsTyp getZustand(final String value) {
		for (AttTmcOrtsTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTmcOrtsTyp> getZustaende() {
		List<AttTmcOrtsTyp> list = new ArrayList<AttTmcOrtsTyp>();
		list.add(ZUSTAND_301000_KONTINENT_ALLGEMEIN);
		list.add(ZUSTAND_302000_LAENDERGRUPPE_ALLGEMEIN);
		list.add(ZUSTAND_303000_LAND_ALLGEMEIN);
		list.add(ZUSTAND_304000_WASSERGEBIET_ALLGEMEIN);
		list.add(ZUSTAND_304001_WASSERGEBIET_MEER);
		list.add(ZUSTAND_304002_WASSERGEBIET_BINNEN_SEE);
		list.add(ZUSTAND_306000_UNSCHARFES_GEBIET_ALLGEMEIN);
		list.add(ZUSTAND_306001_UNSCHARFES_GEBIET_TOURISTISCHES_GEBIET);
		list.add(ZUSTAND_306002_UNSCHARFES_GEBIET_BALLUNGSRAUM);
		list.add(ZUSTAND_306003_UNSCHARFES_GEBIET_INDUSTRIEREGION);
		list.add(ZUSTAND_306004_UNSCHARFES_GEBIET_VERKEHRSGEBIET);
		list.add(ZUSTAND_306005_UNSCHARFES_GEBIET_METEOROLOGISCHES_GEBIET);
		list.add(ZUSTAND_306006_UNSCHARFES_GEBIET_SAMMELPARKPLATZ);
		list.add(ZUSTAND_306007_UNSCHARFES_GEBIET_P_R_PARKPLATZ);
		list.add(ZUSTAND_306008_UNSCHARFES_GEBIET_PARKPLATZ);
		list.add(ZUSTAND_307000__GEBIET_1_ORDNUNG_BUNDESLAND_ALLGEMEIN);
		list.add(ZUSTAND_308000__GEBIET_2_ORDNUNG_REGIERUNGSBEZIRK_ALLGEMEIN);
		list.add(ZUSTAND_309000__GEBIET_3_ORDNUNG_KREIS_KREISFREIE_STADT_ALLGEMEIN);
		list.add(ZUSTAND_309001__GEBIET_3_ORDNUNG_KREIS_KREISFREIE_STADT_KREIS_LANDKREIS);
		list.add(ZUSTAND_309002__GEBIET_3_ORDNUNG_KREIS_KREISFREIE_STADT_KREISFREIE_STADT);
		list.add(ZUSTAND_310000_GEMEINDE_STADT_ALLGEMEIN);
		list.add(ZUSTAND_311000_GEMEINDETEIL_STADTTEIL_ALLGEMEIN);
		list.add(ZUSTAND_312000_TEILGEBIET_EINES_ADMINISTRATIVEN_GEBIETES_DER_EBENEN_A7_BIS_A11_ALLGEMEIN);
		list.add(ZUSTAND_201000_STRASSE_ALLGEMEIN);
		list.add(ZUSTAND_201001_STRASSE_STRASSE_1_ORDNUNG_BUNDESAUTOBAHN);
		list.add(ZUSTAND_201002_STRASSE_STRASSE_2_ORDNUNG_BUNDESSTRASSE);
		list.add(ZUSTAND_201003_STRASSE_LANDES_ODER_STAATSSTRASSE);
		list.add(ZUSTAND_201004_STRASSE_KREISSTRASSE_GEMEINDESTRASSE);
		list.add(ZUSTAND_202000_RINGSTRASSE_ALLGEMEIN);
		list.add(ZUSTAND_202001_RINGSTRASSE_BAB_RING);
		list.add(ZUSTAND_202002_RINGSTRASSE_RINGSTRASSE);
		list.add(ZUSTAND_203000_STRECKENABSCHNITT_1_ORDNUNG_ALLGEMEIN);
		list.add(ZUSTAND_204000_STRECKENABSCHNITT_2_ORDNUNG_ALLGEMEIN);
		list.add(ZUSTAND_205000_GEMEINDESTRASSE_STADTSTRASSE_ALLGEMEIN);
		list.add(ZUSTAND_206000_VERKEHRSVERBINDUNG_ALLGEMEIN);
		list.add(ZUSTAND_206001_VERKEHRSVERBINDUNG_FAEHRVERBINDUNG);
		list.add(ZUSTAND_206002_VERKEHRSVERBINDUNG_AUTOREISEZUGVERBINDUNG);
		list.add(ZUSTAND_101000_KNOTENPUNKT_ALLGEMEIN);
		list.add(ZUSTAND_101001_KNOTENPUNKT_AUTOBAHNKREUZ);
		list.add(ZUSTAND_101002_KNOTENPUNKT_AUTOBAHNDREIECK);
		list.add(ZUSTAND_101003_KNOTENPUNKT_AUTOBAHNANSCHLUSSSTELLE);
		list.add(ZUSTAND_101004_KNOTENPUNKT_AUTOBAHNAUSFAHRT);
		list.add(ZUSTAND_101005_KNOTENPUNKT_AUTOBAHNEINFAHRT);
		list.add(ZUSTAND_101006_KNOTENPUNKT_UEBERFUEHRUNG);
		list.add(ZUSTAND_101007_KNOTENPUNKT_UNTERFUEHRUNG);
		list.add(ZUSTAND_101008_KNOTENPUNKT_KLEINER_KREISVERKEHR_SPLATZ_);
		list.add(ZUSTAND_101009_KNOTENPUNKT_GROSSER_KREISVERKEHR_SPLATZ_);
		list.add(ZUSTAND_101010_KNOTENPUNKT_LICHTSIGNALGEREGELTER_KNOTENPUNKT);
		list.add(ZUSTAND_101011_KNOTENPUNKT_KREUZUNG);
		list.add(ZUSTAND_101012_KNOTENPUNKT_EINMUENDUNG);
		list.add(ZUSTAND_101013_KNOTENPUNKT_UEBERGANG);
		list.add(ZUSTAND_101014_KNOTENPUNKT_KURZE_VERBINDUNGSSTRASSE_QUERSPANGE);
		list.add(ZUSTAND_101015_KNOTENPUNKT_AUSFAHRT);
		list.add(ZUSTAND_102000_ZWISCHENPUNKT_ALLGEMEIN);
		list.add(ZUSTAND_102001_ZWISCHENPUNKT_STRECKENMARKE_KILOMETRIERUNG);
		list.add(ZUSTAND_102002_ZWISCHENPUNKT_VERKEHRSERFASSUNGSSTATION);
		list.add(ZUSTAND_103000_SONSTIGER_MARKANTER_PUNKT_ALLGEMEIN);
		list.add(ZUSTAND_103001_SONSTIGER_MARKANTER_PUNKT_TUNNEL);
		list.add(ZUSTAND_103002_SONSTIGER_MARKANTER_PUNKT_BRUECKE);
		list.add(ZUSTAND_103003_SONSTIGER_MARKANTER_PUNKT_RASTSTAETTE);
		list.add(ZUSTAND_103004_SONSTIGER_MARKANTER_PUNKT_RASTPLATZ_MIT_EINZELNEN_EINRICHTUNGEN);
		list.add(ZUSTAND_103005_SONSTIGER_MARKANTER_PUNKT_AUSSICHTSPUNKT);
		list.add(ZUSTAND_103006_SONSTIGER_MARKANTER_PUNKT_MITFAHRERSAMMELPARKPLATZ);
		list.add(ZUSTAND_103007_SONSTIGER_MARKANTER_PUNKT_P_R_PARKPLATZ);
		list.add(ZUSTAND_103008_SONSTIGER_MARKANTER_PUNKT_PARKPLATZ);
		list.add(ZUSTAND_103009_SONSTIGER_MARKANTER_PUNKT_PARKPLATZ_MIT_KIOSK);
		list.add(ZUSTAND_103010_SONSTIGER_MARKANTER_PUNKT_PARKPLATZ_MIT_KIOSK_WC);
		list.add(ZUSTAND_103011_SONSTIGER_MARKANTER_PUNKT_TANKSTELLE);
		list.add(ZUSTAND_103012_SONSTIGER_MARKANTER_PUNKT_TANKSTELLE_MIT_KIOSK);
		list.add(ZUSTAND_103013_SONSTIGER_MARKANTER_PUNKT_MOTEL);
		list.add(ZUSTAND_103014_SONSTIGER_MARKANTER_PUNKT_GRENZUEBERGANG);
		list.add(ZUSTAND_103015_SONSTIGER_MARKANTER_PUNKT_ZOLLSTATION);
		list.add(ZUSTAND_103016_SONSTIGER_MARKANTER_PUNKT_MAUTSTATION);
		list.add(ZUSTAND_103017_SONSTIGER_MARKANTER_PUNKT_FAEHRANLIEGER);
		list.add(ZUSTAND_103018_SONSTIGER_MARKANTER_PUNKT_HAFEN);
		list.add(ZUSTAND_103019_SONSTIGER_MARKANTER_PUNKT_PLATZ);
		list.add(ZUSTAND_103020_SONSTIGER_MARKANTER_PUNKT_MARKTPLATZ_FEST_PLATZ);
		list.add(ZUSTAND_103021_SONSTIGER_MARKANTER_PUNKT_PARKHAUS);
		list.add(ZUSTAND_103022_SONSTIGER_MARKANTER_PUNKT_TIEFGARAGE);
		list.add(ZUSTAND_103023_SONSTIGER_MARKANTER_PUNKT_EINKAUFSZENTRUM);
		list.add(ZUSTAND_103024_SONSTIGER_MARKANTER_PUNKT_FREIZEITPARK);
		list.add(ZUSTAND_103025_SONSTIGER_MARKANTER_PUNKT_TOURISTENATTRAKTION);
		list.add(ZUSTAND_103026_SONSTIGER_MARKANTER_PUNKT_UNIVERSITAET);
		list.add(ZUSTAND_103027_SONSTIGER_MARKANTER_PUNKT_FLUGHAFEN);
		list.add(ZUSTAND_103028_SONSTIGER_MARKANTER_PUNKT_BAHNHOF_BUSBAHNHOF);
		list.add(ZUSTAND_103029_SONSTIGER_MARKANTER_PUNKT_KRANKENHAUS);
		list.add(ZUSTAND_103030_SONSTIGER_MARKANTER_PUNKT_KIRCHE);
		list.add(ZUSTAND_103031_SONSTIGER_MARKANTER_PUNKT_STADION);
		list.add(ZUSTAND_103032_SONSTIGER_MARKANTER_PUNKT_OEFFENTLICHES_GEBAEUDE);
		list.add(ZUSTAND_103033_SONSTIGER_MARKANTER_PUNKT_BURG);
		list.add(ZUSTAND_103034_SONSTIGER_MARKANTER_PUNKT_RATHAUS);
		list.add(ZUSTAND_103035_SONSTIGER_MARKANTER_PUNKT_AUSSTELLUNGS_KONGRESSZENTRUM);
		list.add(ZUSTAND_103036_SONSTIGER_MARKANTER_PUNKT_WEILER);
		list.add(ZUSTAND_103037_SONSTIGER_MARKANTER_PUNKT_BENANNTER_PUNKT);
		list.add(ZUSTAND_103038_SONSTIGER_MARKANTER_PUNKT_DAMM);
		list.add(ZUSTAND_103039_SONSTIGER_MARKANTER_PUNKT_DEICH);
		list.add(ZUSTAND_103040_SONSTIGER_MARKANTER_PUNKT_AQUAEDUKT);
		list.add(ZUSTAND_103041_SONSTIGER_MARKANTER_PUNKT_SCHLEUSE);
		list.add(ZUSTAND_103042_SONSTIGER_MARKANTER_PUNKT_PASS);
		list.add(ZUSTAND_103043_SONSTIGER_MARKANTER_PUNKT_BAHNUEBERGANG);
		list.add(ZUSTAND_103044_SONSTIGER_MARKANTER_PUNKT_FURT);
		list.add(ZUSTAND_103045_SONSTIGER_MARKANTER_PUNKT_FLUSSFAEHRE_BINNENGEWAESSER_);
		list.add(ZUSTAND_103046_SONSTIGER_MARKANTER_PUNKT_INDUSTRIEGEBIET);
		list.add(ZUSTAND_103047_SONSTIGER_MARKANTER_PUNKT_VIADUCKT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TmcOrtsTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTmcOrtsTyp(final 		Integer
	 value) {
		super(value);
	}
	
	private AttTmcOrtsTyp(final String zustand, final 		Integer
	 value) {
		super(zustand, value);
	}
	
}
