/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class KdTmcLocationCode extends AbstractKonfigurationsDatensatz<KdTmcLocationCode.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
				 _tmcLocationCode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcOrtsTyp
				 _tmcOrtsTyp
				;
				private String
				 _tmcStrassenNummer
				= new String
				()
				;
				private String
				 _tmcStrassenName
				= new String
				()
				;
				private String
				 _tmcErsterName
				= new String
				()
				;
				private String
				 _tmcZweiterName
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _tmcStadtverkehr
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _einfahrtPositiveRichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _ausfahrtPositiveRichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _einfahrtNegativeRichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _ausfahrtNegativeRichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _vorhandenPositiveRichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _vorhandenNegativeRichtung
				;
				private String
				 _ausfahrtNr
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
				 _x
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
				 _y
				;
				private String
				 _umleitungPositiveRichtung
				= new String
				()
				;
				private String
				 _umleitungNegativeRichtung
				= new String
				()
				;
				private String
				 _netzKnotenNrA
				= new String
				()
				;
				private String
				 _netzKnotenNrB
				= new String
				()
				;
				private String
				 _station
				= new String
				()
				;
				private String
				 _polizeiDirektion
				= new String
				()
				;
				private String
				 _verwaltungsBereich
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _veraenderung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _tern
				;
				private String
				 _aenderungsDatum
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _aktiviert
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _getestet
				;
				private Feld<String
				> _sondereintrag = new Feld<String
				>(10, true);
		
			/**
			Ortscode (TMC Location Code).
			<p>
			
			</p>
			
			@return der Wert von TmcLocationCode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
				 getTmcLocationCode() {
				return _tmcLocationCode;
			}
		
			/**
			Ortscode (TMC Location Code).
			<p>
			
			</p>
			
			@param _tmcLocationCode der neue Wert von TmcLocationCode.
			*/
			public void setTmcLocationCode(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 _tmcLocationCode) {
				this._tmcLocationCode = _tmcLocationCode;
			}
		
			/**
			Ortstyp und OrtSubtyp des Ortes entsprechend der Festlegungen der LCL.
			<p>
			&lt;absatz&gt;Für die Sprachunabhängigkeit der weitergegebenen Informationen und zur Mitteilung an das empfangende System, welche Datenfelder zu erwarten sind, sind Ortstypen und Untertypen erforderlich. Innerhalb einer jeden Kategorie wird (grundsätzlich) nach Ortstypen unterschieden, sofern für einen Ort ein funktionaler Unterschied besteht in der Art, wie er vom Empfänger einer Meldung zu behandeln ist.&lt;&#47;absatz&gt;
									&lt;absatz&gt;Orts- und Untertypen werden gemeinsam kodiert. Dabei gilt folgendes Kodierschema:&lt;&#47;absatz&gt;
									&lt;liste zeichen="punkt"&gt;
										&lt;listenPunkt&gt;Der TMC-Typ 'Punkt', 'Linie' oder 'Gebiet' ergibt sich aus dem Objekttyp
											&lt;verweis pid="typ.tmcPunkt"&gt;&lt;&#47;verweis&gt;
											,
											&lt;verweis pid="typ.tmcLinie"&gt;&lt;&#47;verweis&gt;
											oder
											&lt;verweis pid="typ.tmcGebiet"&gt;&lt;&#47;verweis&gt;
											.
										&lt;&#47;listenPunkt&gt;
										&lt;listenPunkt&gt;Der Name wird gebildet aus 'OrtTypName:UntertypName', wobei 'UnterTypName' gleich 'Allgemein' verwendet wird, sofern kein Untertyp vorhanden ist.&lt;&#47;listenPunkt&gt;
										&lt;listenPunkt&gt;Der Wert des Aufzahlungstyps ist eine sechsstellige Zahl der Form TNNSSS mit T gleich Typ (1=Punkt, 2=Linie, 3=Gebiet), NN gleich Orttypnummer und SSS gleich Untertypnummer entsprechend LCL, jeweils mit führenden Nullen.&lt;&#47;listenPunkt&gt;
									&lt;&#47;liste&gt;
			</p>
			
			@return der Wert von TmcOrtsTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcOrtsTyp
				 getTmcOrtsTyp() {
				return _tmcOrtsTyp;
			}
		
			/**
			Ortstyp und OrtSubtyp des Ortes entsprechend der Festlegungen der LCL.
			<p>
			&lt;absatz&gt;Für die Sprachunabhängigkeit der weitergegebenen Informationen und zur Mitteilung an das empfangende System, welche Datenfelder zu erwarten sind, sind Ortstypen und Untertypen erforderlich. Innerhalb einer jeden Kategorie wird (grundsätzlich) nach Ortstypen unterschieden, sofern für einen Ort ein funktionaler Unterschied besteht in der Art, wie er vom Empfänger einer Meldung zu behandeln ist.&lt;&#47;absatz&gt;
									&lt;absatz&gt;Orts- und Untertypen werden gemeinsam kodiert. Dabei gilt folgendes Kodierschema:&lt;&#47;absatz&gt;
									&lt;liste zeichen="punkt"&gt;
										&lt;listenPunkt&gt;Der TMC-Typ 'Punkt', 'Linie' oder 'Gebiet' ergibt sich aus dem Objekttyp
											&lt;verweis pid="typ.tmcPunkt"&gt;&lt;&#47;verweis&gt;
											,
											&lt;verweis pid="typ.tmcLinie"&gt;&lt;&#47;verweis&gt;
											oder
											&lt;verweis pid="typ.tmcGebiet"&gt;&lt;&#47;verweis&gt;
											.
										&lt;&#47;listenPunkt&gt;
										&lt;listenPunkt&gt;Der Name wird gebildet aus 'OrtTypName:UntertypName', wobei 'UnterTypName' gleich 'Allgemein' verwendet wird, sofern kein Untertyp vorhanden ist.&lt;&#47;listenPunkt&gt;
										&lt;listenPunkt&gt;Der Wert des Aufzahlungstyps ist eine sechsstellige Zahl der Form TNNSSS mit T gleich Typ (1=Punkt, 2=Linie, 3=Gebiet), NN gleich Orttypnummer und SSS gleich Untertypnummer entsprechend LCL, jeweils mit führenden Nullen.&lt;&#47;listenPunkt&gt;
									&lt;&#47;liste&gt;
			</p>
			
			@param _tmcOrtsTyp der neue Wert von TmcOrtsTyp.
			*/
			public void setTmcOrtsTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcOrtsTyp
			 _tmcOrtsTyp) {
				this._tmcOrtsTyp = _tmcOrtsTyp;
			}
		
			/**
			Straßennummer der Straße, die durch diesen Ortscode referenziert wird.
			<p>
			
			</p>
			
			@return der Wert von TmcStrassenNummer.
			*/
				public String
				 getTmcStrassenNummer() {
				return _tmcStrassenNummer;
			}
		
			/**
			Straßennummer der Straße, die durch diesen Ortscode referenziert wird.
			<p>
			
			</p>
			
			@param _tmcStrassenNummer der neue Wert von TmcStrassenNummer.
			*/
			public void setTmcStrassenNummer(String
			 _tmcStrassenNummer) {
				if (_tmcStrassenNummer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tmcStrassenNummer = _tmcStrassenNummer;
			}
		
			/**
			Straßenname der Straße.
			<p>
			
			</p>
			
			@return der Wert von TmcStrassenName.
			*/
				public String
				 getTmcStrassenName() {
				return _tmcStrassenName;
			}
		
			/**
			Straßenname der Straße.
			<p>
			
			</p>
			
			@param _tmcStrassenName der neue Wert von TmcStrassenName.
			*/
			public void setTmcStrassenName(String
			 _tmcStrassenName) {
				if (_tmcStrassenName.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tmcStrassenName = _tmcStrassenName;
			}
		
			/**
			Zusätzlicher Name.
			<p>
			Namen von Orten sind im Regelfall in der Sprache des jeweiligen Ortes anzugeben. Es ist jedoch auch zulässig, Fassungen von Ortstabellen mit (zwei- oder mehrsprachigen) Ortsnamen, welche in andere Sprachen übersetzt wurden, zu erstellen. Der Name eines Anschlusses darf eine Beschreibung sein, wie sie Straßennutzern am besten bekannt ist.
			</p>
			
			@return der Wert von TmcErsterName.
			*/
				public String
				 getTmcErsterName() {
				return _tmcErsterName;
			}
		
			/**
			Zusätzlicher Name.
			<p>
			Namen von Orten sind im Regelfall in der Sprache des jeweiligen Ortes anzugeben. Es ist jedoch auch zulässig, Fassungen von Ortstabellen mit (zwei- oder mehrsprachigen) Ortsnamen, welche in andere Sprachen übersetzt wurden, zu erstellen. Der Name eines Anschlusses darf eine Beschreibung sein, wie sie Straßennutzern am besten bekannt ist.
			</p>
			
			@param _tmcErsterName der neue Wert von TmcErsterName.
			*/
			public void setTmcErsterName(String
			 _tmcErsterName) {
				if (_tmcErsterName.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tmcErsterName = _tmcErsterName;
			}
		
			/**
			Zusätzlicher Name.
			<p>
			Namen von Orten sind im Regelfall in der Sprache des jeweiligen Ortes anzugeben. Es ist jedoch auch zulässig, Fassungen von Ortstabellen mit (zwei- oder mehrsprachigen) Ortsnamen, welche in andere Sprachen übersetzt wurden, zu erstellen. Der Name eines Anschlusses darf eine Beschreibung sein, wie sie Straßennutzern am besten bekannt ist.
			</p>
			
			@return der Wert von TmcZweiterName.
			*/
				public String
				 getTmcZweiterName() {
				return _tmcZweiterName;
			}
		
			/**
			Zusätzlicher Name.
			<p>
			Namen von Orten sind im Regelfall in der Sprache des jeweiligen Ortes anzugeben. Es ist jedoch auch zulässig, Fassungen von Ortstabellen mit (zwei- oder mehrsprachigen) Ortsnamen, welche in andere Sprachen übersetzt wurden, zu erstellen. Der Name eines Anschlusses darf eine Beschreibung sein, wie sie Straßennutzern am besten bekannt ist.
			</p>
			
			@param _tmcZweiterName der neue Wert von TmcZweiterName.
			*/
			public void setTmcZweiterName(String
			 _tmcZweiterName) {
				if (_tmcZweiterName.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tmcZweiterName = _tmcZweiterName;
			}
		
			/**
			Gibt an, ob der Verkehr an diesem Punktort hauptsächlich den Charakter von Stadtverkehr (ja) oder von außerorts Verkehr (nein) hat.
			<p>
			
			</p>
			
			@return der Wert von TmcStadtverkehr.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getTmcStadtverkehr() {
				return _tmcStadtverkehr;
			}
		
			/**
			Gibt an, ob der Verkehr an diesem Punktort hauptsächlich den Charakter von Stadtverkehr (ja) oder von außerorts Verkehr (nein) hat.
			<p>
			
			</p>
			
			@param _tmcStadtverkehr der neue Wert von TmcStadtverkehr.
			*/
			public void setTmcStadtverkehr(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _tmcStadtverkehr) {
				this._tmcStadtverkehr = _tmcStadtverkehr;
			}
		
			/**
			Möglichkeit, auf die Straße in positiver Erfassungsrichtung aufzufahren.
			<p>
			
			</p>
			
			@return der Wert von EinfahrtPositiveRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEinfahrtPositiveRichtung() {
				return _einfahrtPositiveRichtung;
			}
		
			/**
			Möglichkeit, auf die Straße in positiver Erfassungsrichtung aufzufahren.
			<p>
			
			</p>
			
			@param _einfahrtPositiveRichtung der neue Wert von EinfahrtPositiveRichtung.
			*/
			public void setEinfahrtPositiveRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _einfahrtPositiveRichtung) {
				this._einfahrtPositiveRichtung = _einfahrtPositiveRichtung;
			}
		
			/**
			Möglichkeit, aus der Straße in positiver Erfassungsrichtung herauszufahren.
			<p>
			
			</p>
			
			@return der Wert von AusfahrtPositiveRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAusfahrtPositiveRichtung() {
				return _ausfahrtPositiveRichtung;
			}
		
			/**
			Möglichkeit, aus der Straße in positiver Erfassungsrichtung herauszufahren.
			<p>
			
			</p>
			
			@param _ausfahrtPositiveRichtung der neue Wert von AusfahrtPositiveRichtung.
			*/
			public void setAusfahrtPositiveRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ausfahrtPositiveRichtung) {
				this._ausfahrtPositiveRichtung = _ausfahrtPositiveRichtung;
			}
		
			/**
			Möglichkeit, in die Straße in negativer Erfassungsrichtung einzufahren.
			<p>
			
			</p>
			
			@return der Wert von EinfahrtNegativeRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEinfahrtNegativeRichtung() {
				return _einfahrtNegativeRichtung;
			}
		
			/**
			Möglichkeit, in die Straße in negativer Erfassungsrichtung einzufahren.
			<p>
			
			</p>
			
			@param _einfahrtNegativeRichtung der neue Wert von EinfahrtNegativeRichtung.
			*/
			public void setEinfahrtNegativeRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _einfahrtNegativeRichtung) {
				this._einfahrtNegativeRichtung = _einfahrtNegativeRichtung;
			}
		
			/**
			Möglichkeit, aus der Straße in negariver Erfassungsrichtung auszufahren.
			<p>
			
			</p>
			
			@return der Wert von AusfahrtNegativeRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAusfahrtNegativeRichtung() {
				return _ausfahrtNegativeRichtung;
			}
		
			/**
			Möglichkeit, aus der Straße in negariver Erfassungsrichtung auszufahren.
			<p>
			
			</p>
			
			@param _ausfahrtNegativeRichtung der neue Wert von AusfahrtNegativeRichtung.
			*/
			public void setAusfahrtNegativeRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ausfahrtNegativeRichtung) {
				this._ausfahrtNegativeRichtung = _ausfahrtNegativeRichtung;
			}
		
			/**
			Zur Angabe, dass ein Ort in der positiven Erfassungsrichtung vorhanden ist.
			<p>
			
			</p>
			
			@return der Wert von VorhandenPositiveRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getVorhandenPositiveRichtung() {
				return _vorhandenPositiveRichtung;
			}
		
			/**
			Zur Angabe, dass ein Ort in der positiven Erfassungsrichtung vorhanden ist.
			<p>
			
			</p>
			
			@param _vorhandenPositiveRichtung der neue Wert von VorhandenPositiveRichtung.
			*/
			public void setVorhandenPositiveRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _vorhandenPositiveRichtung) {
				this._vorhandenPositiveRichtung = _vorhandenPositiveRichtung;
			}
		
			/**
			Zur Angabe, dass ein Ort in negativer Erfassungsrichtung vorhanden ist.
			<p>
			
			</p>
			
			@return der Wert von VorhandenNegativeRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getVorhandenNegativeRichtung() {
				return _vorhandenNegativeRichtung;
			}
		
			/**
			Zur Angabe, dass ein Ort in negativer Erfassungsrichtung vorhanden ist.
			<p>
			
			</p>
			
			@param _vorhandenNegativeRichtung der neue Wert von VorhandenNegativeRichtung.
			*/
			public void setVorhandenNegativeRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _vorhandenNegativeRichtung) {
				this._vorhandenNegativeRichtung = _vorhandenNegativeRichtung;
			}
		
			/**
			Nummer der Ausfahrt (z. B. "4a" ).
			<p>
			
			</p>
			
			@return der Wert von AusfahrtNr.
			*/
				public String
				 getAusfahrtNr() {
				return _ausfahrtNr;
			}
		
			/**
			Nummer der Ausfahrt (z. B. "4a" ).
			<p>
			
			</p>
			
			@param _ausfahrtNr der neue Wert von AusfahrtNr.
			*/
			public void setAusfahrtNr(String
			 _ausfahrtNr) {
				if (_ausfahrtNr.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._ausfahrtNr = _ausfahrtNr;
			}
		
			/**
			x-Koordinate (Längenangaben gemäß WGS84).
			<p>
			
			</p>
			
			@return der Wert von X.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
				 getX() {
				return _x;
			}
		
			/**
			x-Koordinate (Längenangaben gemäß WGS84).
			<p>
			
			</p>
			
			@param _x der neue Wert von X.
			*/
			public void setX(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
			 _x) {
				this._x = _x;
			}
		
			/**
			y-Koordinate (Breitenangabe gemäß WGS84).
			<p>
			
			</p>
			
			@return der Wert von Y.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
				 getY() {
				return _y;
			}
		
			/**
			y-Koordinate (Breitenangabe gemäß WGS84).
			<p>
			
			</p>
			
			@param _y der neue Wert von Y.
			*/
			public void setY(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
			 _y) {
				this._y = _y;
			}
		
			/**
			Umleitung in positive Richtung über angegebene Umleitungsstrecke.
			<p>
			
			</p>
			
			@return der Wert von UmleitungPositiveRichtung.
			*/
				public String
				 getUmleitungPositiveRichtung() {
				return _umleitungPositiveRichtung;
			}
		
			/**
			Umleitung in positive Richtung über angegebene Umleitungsstrecke.
			<p>
			
			</p>
			
			@param _umleitungPositiveRichtung der neue Wert von UmleitungPositiveRichtung.
			*/
			public void setUmleitungPositiveRichtung(String
			 _umleitungPositiveRichtung) {
				if (_umleitungPositiveRichtung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._umleitungPositiveRichtung = _umleitungPositiveRichtung;
			}
		
			/**
			Umleitung in negative Richtung über angegebene Umleitungsstrecke.
			<p>
			
			</p>
			
			@return der Wert von UmleitungNegativeRichtung.
			*/
				public String
				 getUmleitungNegativeRichtung() {
				return _umleitungNegativeRichtung;
			}
		
			/**
			Umleitung in negative Richtung über angegebene Umleitungsstrecke.
			<p>
			
			</p>
			
			@param _umleitungNegativeRichtung der neue Wert von UmleitungNegativeRichtung.
			*/
			public void setUmleitungNegativeRichtung(String
			 _umleitungNegativeRichtung) {
				if (_umleitungNegativeRichtung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._umleitungNegativeRichtung = _umleitungNegativeRichtung;
			}
		
			/**
			Ortscode gehört zum angegebenen Netzknoten A.
			<p>
			
			</p>
			
			@return der Wert von NetzKnotenNrA.
			*/
				public String
				 getNetzKnotenNrA() {
				return _netzKnotenNrA;
			}
		
			/**
			Ortscode gehört zum angegebenen Netzknoten A.
			<p>
			
			</p>
			
			@param _netzKnotenNrA der neue Wert von NetzKnotenNrA.
			*/
			public void setNetzKnotenNrA(String
			 _netzKnotenNrA) {
				if (_netzKnotenNrA.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._netzKnotenNrA = _netzKnotenNrA;
			}
		
			/**
			Ortscode gehört zum angegebenen Netzknoten B.
			<p>
			
			</p>
			
			@return der Wert von NetzKnotenNrB.
			*/
				public String
				 getNetzKnotenNrB() {
				return _netzKnotenNrB;
			}
		
			/**
			Ortscode gehört zum angegebenen Netzknoten B.
			<p>
			
			</p>
			
			@param _netzKnotenNrB der neue Wert von NetzKnotenNrB.
			*/
			public void setNetzKnotenNrB(String
			 _netzKnotenNrB) {
				if (_netzKnotenNrB.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._netzKnotenNrB = _netzKnotenNrB;
			}
		
			/**
			Ortscode gehört zur angegebenen Station.
			<p>
			
			</p>
			
			@return der Wert von Station.
			*/
				public String
				 getStation() {
				return _station;
			}
		
			/**
			Ortscode gehört zur angegebenen Station.
			<p>
			
			</p>
			
			@param _station der neue Wert von Station.
			*/
			public void setStation(String
			 _station) {
				if (_station.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._station = _station;
			}
		
			/**
			Ortscode gehört zur angegebenen Polizeidirektion.
			<p>
			
			</p>
			
			@return der Wert von PolizeiDirektion.
			*/
				public String
				 getPolizeiDirektion() {
				return _polizeiDirektion;
			}
		
			/**
			Ortscode gehört zur angegebenen Polizeidirektion.
			<p>
			
			</p>
			
			@param _polizeiDirektion der neue Wert von PolizeiDirektion.
			*/
			public void setPolizeiDirektion(String
			 _polizeiDirektion) {
				if (_polizeiDirektion.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._polizeiDirektion = _polizeiDirektion;
			}
		
			/**
			Ortscode liegt im angegebenen Verwaltungsbereich.
			<p>
			
			</p>
			
			@return der Wert von VerwaltungsBereich.
			*/
				public String
				 getVerwaltungsBereich() {
				return _verwaltungsBereich;
			}
		
			/**
			Ortscode liegt im angegebenen Verwaltungsbereich.
			<p>
			
			</p>
			
			@param _verwaltungsBereich der neue Wert von VerwaltungsBereich.
			*/
			public void setVerwaltungsBereich(String
			 _verwaltungsBereich) {
				if (_verwaltungsBereich.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._verwaltungsBereich = _verwaltungsBereich;
			}
		
			/**
			Wurde Datensatz gegenüber letzter LocationCodeListe verändert ?.
			<p>
			
			</p>
			
			@return der Wert von Veraenderung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getVeraenderung() {
				return _veraenderung;
			}
		
			/**
			Wurde Datensatz gegenüber letzter LocationCodeListe verändert ?.
			<p>
			
			</p>
			
			@param _veraenderung der neue Wert von Veraenderung.
			*/
			public void setVeraenderung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _veraenderung) {
				this._veraenderung = _veraenderung;
			}
		
			/**
			Tern ????.
			<p>
			
			</p>
			
			@return der Wert von Tern.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getTern() {
				return _tern;
			}
		
			/**
			Tern ????.
			<p>
			
			</p>
			
			@param _tern der neue Wert von Tern.
			*/
			public void setTern(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _tern) {
				this._tern = _tern;
			}
		
			/**
			Eintrag wurde zuletzt geändert am angegebenen Datum.
			<p>
			
			</p>
			
			@return der Wert von AenderungsDatum.
			*/
				public String
				 getAenderungsDatum() {
				return _aenderungsDatum;
			}
		
			/**
			Eintrag wurde zuletzt geändert am angegebenen Datum.
			<p>
			
			</p>
			
			@param _aenderungsDatum der neue Wert von AenderungsDatum.
			*/
			public void setAenderungsDatum(String
			 _aenderungsDatum) {
				if (_aenderungsDatum.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._aenderungsDatum = _aenderungsDatum;
			}
		
			/**
			Ortscode ist aktiv.
			<p>
			
			</p>
			
			@return der Wert von Aktiviert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAktiviert() {
				return _aktiviert;
			}
		
			/**
			Ortscode ist aktiv.
			<p>
			
			</p>
			
			@param _aktiviert der neue Wert von Aktiviert.
			*/
			public void setAktiviert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aktiviert) {
				this._aktiviert = _aktiviert;
			}
		
			/**
			Daten wurden getestet.
			<p>
			
			</p>
			
			@return der Wert von Getestet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getGetestet() {
				return _getestet;
			}
		
			/**
			Daten wurden getestet.
			<p>
			
			</p>
			
			@param _getestet der neue Wert von Getestet.
			*/
			public void setGetestet(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _getestet) {
				this._getestet = _getestet;
			}
		
			/**
			Sondereintrag. Interpretation ist nicht definiert.
			<p>
			
			</p>
			
			@return der Wert von Sondereintrag.
			*/
				public Feld<String
				> getSondereintrag() {
				return _sondereintrag;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getTmcLocationCode() != null) {
		                if (getTmcLocationCode().isZustand()) {
		                    datum.getUnscaledValue("TmcLocationCode").setText(getTmcLocationCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TmcLocationCode").set(getTmcLocationCode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTmcOrtsTyp() != null) {
		                if (getTmcOrtsTyp().isZustand()) {
		                    datum.getUnscaledValue("TmcOrtsTyp").setText(getTmcOrtsTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TmcOrtsTyp").set(getTmcOrtsTyp().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getTmcStrassenNummer() != null) {
						datum.getTextValue("TmcStraßenNummer").setText(getTmcStrassenNummer());
					}
					// ZeichenkettenAttributTyp
					if (getTmcStrassenName() != null) {
						datum.getTextValue("TmcStraßenName").setText(getTmcStrassenName());
					}
					// ZeichenkettenAttributTyp
					if (getTmcErsterName() != null) {
						datum.getTextValue("TmcErsterName").setText(getTmcErsterName());
					}
					// ZeichenkettenAttributTyp
					if (getTmcZweiterName() != null) {
						datum.getTextValue("TmcZweiterName").setText(getTmcZweiterName());
					}
					// GanzzahlAttributTyp
					if (getTmcStadtverkehr() != null) {
		                if (getTmcStadtverkehr().isZustand()) {
		                    datum.getUnscaledValue("TmcStadtverkehr").setText(getTmcStadtverkehr().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TmcStadtverkehr").set(getTmcStadtverkehr().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEinfahrtPositiveRichtung() != null) {
		                if (getEinfahrtPositiveRichtung().isZustand()) {
		                    datum.getUnscaledValue("EinfahrtPositiveRichtung").setText(getEinfahrtPositiveRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EinfahrtPositiveRichtung").set(getEinfahrtPositiveRichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAusfahrtPositiveRichtung() != null) {
		                if (getAusfahrtPositiveRichtung().isZustand()) {
		                    datum.getUnscaledValue("AusfahrtPositiveRichtung").setText(getAusfahrtPositiveRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AusfahrtPositiveRichtung").set(getAusfahrtPositiveRichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEinfahrtNegativeRichtung() != null) {
		                if (getEinfahrtNegativeRichtung().isZustand()) {
		                    datum.getUnscaledValue("EinfahrtNegativeRichtung").setText(getEinfahrtNegativeRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EinfahrtNegativeRichtung").set(getEinfahrtNegativeRichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAusfahrtNegativeRichtung() != null) {
		                if (getAusfahrtNegativeRichtung().isZustand()) {
		                    datum.getUnscaledValue("AusfahrtNegativeRichtung").setText(getAusfahrtNegativeRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AusfahrtNegativeRichtung").set(getAusfahrtNegativeRichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVorhandenPositiveRichtung() != null) {
		                if (getVorhandenPositiveRichtung().isZustand()) {
		                    datum.getUnscaledValue("VorhandenPositiveRichtung").setText(getVorhandenPositiveRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VorhandenPositiveRichtung").set(getVorhandenPositiveRichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVorhandenNegativeRichtung() != null) {
		                if (getVorhandenNegativeRichtung().isZustand()) {
		                    datum.getUnscaledValue("VorhandenNegativeRichtung").setText(getVorhandenNegativeRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VorhandenNegativeRichtung").set(getVorhandenNegativeRichtung().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getAusfahrtNr() != null) {
						datum.getTextValue("AusfahrtNr").setText(getAusfahrtNr());
					}
					// GanzzahlAttributTyp
					if (getX() != null) {
		                if (getX().isZustand()) {
		                    datum.getUnscaledValue("x").setText(getX().toString());
		                } else {
							datum.
							getScaledValue
		                	("x").set(getX().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getY() != null) {
		                if (getY().isZustand()) {
		                    datum.getUnscaledValue("y").setText(getY().toString());
		                } else {
							datum.
							getScaledValue
		                	("y").set(getY().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getUmleitungPositiveRichtung() != null) {
						datum.getTextValue("UmleitungPositiveRichtung").setText(getUmleitungPositiveRichtung());
					}
					// ZeichenkettenAttributTyp
					if (getUmleitungNegativeRichtung() != null) {
						datum.getTextValue("UmleitungNegativeRichtung").setText(getUmleitungNegativeRichtung());
					}
					// ZeichenkettenAttributTyp
					if (getNetzKnotenNrA() != null) {
						datum.getTextValue("NetzKnotenNrA").setText(getNetzKnotenNrA());
					}
					// ZeichenkettenAttributTyp
					if (getNetzKnotenNrB() != null) {
						datum.getTextValue("NetzKnotenNrB").setText(getNetzKnotenNrB());
					}
					// ZeichenkettenAttributTyp
					if (getStation() != null) {
						datum.getTextValue("Station").setText(getStation());
					}
					// ZeichenkettenAttributTyp
					if (getPolizeiDirektion() != null) {
						datum.getTextValue("PolizeiDirektion").setText(getPolizeiDirektion());
					}
					// ZeichenkettenAttributTyp
					if (getVerwaltungsBereich() != null) {
						datum.getTextValue("VerwaltungsBereich").setText(getVerwaltungsBereich());
					}
					// GanzzahlAttributTyp
					if (getVeraenderung() != null) {
		                if (getVeraenderung().isZustand()) {
		                    datum.getUnscaledValue("Veränderung").setText(getVeraenderung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Veränderung").set(getVeraenderung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTern() != null) {
		                if (getTern().isZustand()) {
		                    datum.getUnscaledValue("Tern").setText(getTern().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Tern").set(getTern().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getAenderungsDatum() != null) {
						datum.getTextValue("ÄnderungsDatum").setText(getAenderungsDatum());
					}
					// GanzzahlAttributTyp
					if (getAktiviert() != null) {
		                if (getAktiviert().isZustand()) {
		                    datum.getUnscaledValue("aktiviert").setText(getAktiviert().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("aktiviert").set(getAktiviert().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGetestet() != null) {
		                if (getGetestet().isZustand()) {
		                    datum.getUnscaledValue("getestet").setText(getGetestet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("getestet").set(getGetestet().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getSondereintrag() != null) {
						final Data.TextArray arraySondereintrag = datum.getTextArray("Sondereintrag");
						arraySondereintrag.setLength(getSondereintrag().size());
						for (int i = 0; i < arraySondereintrag.getLength(); ++i) {
							arraySondereintrag.getTextValue(i).setText(getSondereintrag().get(i));
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setTmcLocationCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
							(daten.
								getUnscaledValue
							("TmcLocationCode").
									intValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TmcOrtsTyp").isState()) {
								setTmcOrtsTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcOrtsTyp
								.getZustand(daten.getScaledValue("TmcOrtsTyp").getText()));
							} else {
							setTmcOrtsTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcOrtsTyp
							(daten.
								getUnscaledValue
							("TmcOrtsTyp").
									intValue
							()));
							}
					// ZeichenkettenAttributTyp
						setTmcStrassenNummer(daten.getTextValue("TmcStraßenNummer").getText());
					// ZeichenkettenAttributTyp
						setTmcStrassenName(daten.getTextValue("TmcStraßenName").getText());
					// ZeichenkettenAttributTyp
						setTmcErsterName(daten.getTextValue("TmcErsterName").getText());
					// ZeichenkettenAttributTyp
						setTmcZweiterName(daten.getTextValue("TmcZweiterName").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TmcStadtverkehr").isState()) {
								setTmcStadtverkehr(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("TmcStadtverkehr").getText()));
							} else {
							setTmcStadtverkehr(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("TmcStadtverkehr").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EinfahrtPositiveRichtung").isState()) {
								setEinfahrtPositiveRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EinfahrtPositiveRichtung").getText()));
							} else {
							setEinfahrtPositiveRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EinfahrtPositiveRichtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AusfahrtPositiveRichtung").isState()) {
								setAusfahrtPositiveRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("AusfahrtPositiveRichtung").getText()));
							} else {
							setAusfahrtPositiveRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("AusfahrtPositiveRichtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EinfahrtNegativeRichtung").isState()) {
								setEinfahrtNegativeRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EinfahrtNegativeRichtung").getText()));
							} else {
							setEinfahrtNegativeRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EinfahrtNegativeRichtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AusfahrtNegativeRichtung").isState()) {
								setAusfahrtNegativeRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("AusfahrtNegativeRichtung").getText()));
							} else {
							setAusfahrtNegativeRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("AusfahrtNegativeRichtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VorhandenPositiveRichtung").isState()) {
								setVorhandenPositiveRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("VorhandenPositiveRichtung").getText()));
							} else {
							setVorhandenPositiveRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("VorhandenPositiveRichtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VorhandenNegativeRichtung").isState()) {
								setVorhandenNegativeRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("VorhandenNegativeRichtung").getText()));
							} else {
							setVorhandenNegativeRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("VorhandenNegativeRichtung").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setAusfahrtNr(daten.getTextValue("AusfahrtNr").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("x").isState()) {
								setX(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
								.getZustand(daten.getScaledValue("x").getText()));
							} else {
							setX(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
							(daten.
								getScaledValue
							("x").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("y").isState()) {
								setY(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
								.getZustand(daten.getScaledValue("y").getText()));
							} else {
							setY(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
							(daten.
								getScaledValue
							("y").
								doubleValue
							()));
							}
					// ZeichenkettenAttributTyp
						setUmleitungPositiveRichtung(daten.getTextValue("UmleitungPositiveRichtung").getText());
					// ZeichenkettenAttributTyp
						setUmleitungNegativeRichtung(daten.getTextValue("UmleitungNegativeRichtung").getText());
					// ZeichenkettenAttributTyp
						setNetzKnotenNrA(daten.getTextValue("NetzKnotenNrA").getText());
					// ZeichenkettenAttributTyp
						setNetzKnotenNrB(daten.getTextValue("NetzKnotenNrB").getText());
					// ZeichenkettenAttributTyp
						setStation(daten.getTextValue("Station").getText());
					// ZeichenkettenAttributTyp
						setPolizeiDirektion(daten.getTextValue("PolizeiDirektion").getText());
					// ZeichenkettenAttributTyp
						setVerwaltungsBereich(daten.getTextValue("VerwaltungsBereich").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Veränderung").isState()) {
								setVeraenderung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Veränderung").getText()));
							} else {
							setVeraenderung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Veränderung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Tern").isState()) {
								setTern(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Tern").getText()));
							} else {
							setTern(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Tern").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setAenderungsDatum(daten.getTextValue("ÄnderungsDatum").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("aktiviert").isState()) {
								setAktiviert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("aktiviert").getText()));
							} else {
							setAktiviert(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("aktiviert").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("getestet").isState()) {
								setGetestet(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("getestet").getText()));
							} else {
							setGetestet(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("getestet").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						final Data.TextArray arraySondereintrag = daten.getTextArray("Sondereintrag");
						for (int i = 0; i < arraySondereintrag.getLength(); ++i) {
							getSondereintrag().add(arraySondereintrag.getText(i));
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setTmcLocationCode(getTmcLocationCode());
							klon.setTmcOrtsTyp(getTmcOrtsTyp());
							klon.setTmcStrassenNummer(getTmcStrassenNummer());
							klon.setTmcStrassenName(getTmcStrassenName());
							klon.setTmcErsterName(getTmcErsterName());
							klon.setTmcZweiterName(getTmcZweiterName());
							klon.setTmcStadtverkehr(getTmcStadtverkehr());
							klon.setEinfahrtPositiveRichtung(getEinfahrtPositiveRichtung());
							klon.setAusfahrtPositiveRichtung(getAusfahrtPositiveRichtung());
							klon.setEinfahrtNegativeRichtung(getEinfahrtNegativeRichtung());
							klon.setAusfahrtNegativeRichtung(getAusfahrtNegativeRichtung());
							klon.setVorhandenPositiveRichtung(getVorhandenPositiveRichtung());
							klon.setVorhandenNegativeRichtung(getVorhandenNegativeRichtung());
							klon.setAusfahrtNr(getAusfahrtNr());
							klon.setX(getX());
							klon.setY(getY());
							klon.setUmleitungPositiveRichtung(getUmleitungPositiveRichtung());
							klon.setUmleitungNegativeRichtung(getUmleitungNegativeRichtung());
							klon.setNetzKnotenNrA(getNetzKnotenNrA());
							klon.setNetzKnotenNrB(getNetzKnotenNrB());
							klon.setStation(getStation());
							klon.setPolizeiDirektion(getPolizeiDirektion());
							klon.setVerwaltungsBereich(getVerwaltungsBereich());
							klon.setVeraenderung(getVeraenderung());
							klon.setTern(getTern());
							klon.setAenderungsDatum(getAenderungsDatum());
							klon.setAktiviert(getAktiviert());
							klon.setGetestet(getGetestet());
						klon._sondereintrag = getSondereintrag().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tmcLocationCode";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdTmcLocationCode(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
