/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eindeutige Identifikation der Meldung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlTmcId implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _datenproduzent
			= new String
			()
			;
			@Defaultwert(wert = "")
			private String
			 _datenkennung
			= new String
			()
			;
	
		/**
		Name der Organisation, welche die Meldung publiziert hat.
		<p>
		
		</p>
		
		@return der Wert von Datenproduzent.
		*/
			public String
			 getDatenproduzent() {
			return _datenproduzent;
		}
	
		/**
		Name der Organisation, welche die Meldung publiziert hat.
		<p>
		
		</p>
		
		@param _datenproduzent der neue Wert von Datenproduzent.
		*/
		public void setDatenproduzent(String
		 _datenproduzent) {
			if (_datenproduzent.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._datenproduzent = _datenproduzent;
		}
	
		/**
		Eindeutige Identifikation.
		<p>
		
		</p>
		
		@return der Wert von Datenkennung.
		*/
			public String
			 getDatenkennung() {
			return _datenkennung;
		}
	
		/**
		Eindeutige Identifikation.
		<p>
		
		</p>
		
		@param _datenkennung der neue Wert von Datenkennung.
		*/
		public void setDatenkennung(String
		 _datenkennung) {
			if (_datenkennung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._datenkennung = _datenkennung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getDatenproduzent() != null) {
					datum.getTextValue("Datenproduzent").setText(getDatenproduzent());
				}
				// ZeichenkettenAttributTyp
				if (getDatenkennung() != null) {
					datum.getTextValue("Datenkennung").setText(getDatenkennung());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setDatenproduzent(daten.getTextValue("Datenproduzent").getText());
				// ZeichenkettenAttributTyp
					setDatenkennung(daten.getTextValue("Datenkennung").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTmcId clone() {
		AtlTmcId klon = new AtlTmcId();
		
						klon.setDatenproduzent(getDatenproduzent());
						klon.setDatenkennung(getDatenkennung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
