/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Koordinaten.
<p>
Koordinaten im WGS 84 Format in Grad.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTmcKoordinaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "undefiniert")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
			 _tMCLaenge
			;
			@Defaultwert(wert = "undefiniert")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
			 _tMCBreite
			;
	
		/**
		Länge.
		<p>
		
		</p>
		
		@return der Wert von TMCLaenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
			 getTMCLaenge() {
			return _tMCLaenge;
		}
	
		/**
		Länge.
		<p>
		
		</p>
		
		@param _tMCLaenge der neue Wert von TMCLaenge.
		*/
		public void setTMCLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
		 _tMCLaenge) {
			this._tMCLaenge = _tMCLaenge;
		}
	
		/**
		Breite.
		<p>
		
		</p>
		
		@return der Wert von TMCBreite.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
			 getTMCBreite() {
			return _tMCBreite;
		}
	
		/**
		Breite.
		<p>
		
		</p>
		
		@param _tMCBreite der neue Wert von TMCBreite.
		*/
		public void setTMCBreite(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
		 _tMCBreite) {
			this._tMCBreite = _tMCBreite;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getTMCLaenge() != null) {
	                if (getTMCLaenge().isZustand()) {
	                    datum.getUnscaledValue("TMCLänge").setText(getTMCLaenge().toString());
	                } else {
						datum.
						getScaledValue
	                	("TMCLänge").set(getTMCLaenge().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getTMCBreite() != null) {
	                if (getTMCBreite().isZustand()) {
	                    datum.getUnscaledValue("TMCBreite").setText(getTMCBreite().toString());
	                } else {
						datum.
						getScaledValue
	                	("TMCBreite").set(getTMCBreite().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TMCLänge").isState()) {
							setTMCLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
							.getZustand(daten.getScaledValue("TMCLänge").getText()));
						} else {
						setTMCLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
						(daten.
							getScaledValue
						("TMCLänge").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TMCBreite").isState()) {
							setTMCBreite(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
							.getZustand(daten.getScaledValue("TMCBreite").getText()));
						} else {
						setTMCBreite(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
						(daten.
							getScaledValue
						("TMCBreite").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTmcKoordinaten clone() {
		AtlTmcKoordinaten klon = new AtlTmcKoordinaten();
		
						klon.setTMCLaenge(getTMCLaenge());
						klon.setTMCBreite(getTMCBreite());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
