/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TMC-Landesmeldestelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface TmcLandesMeldeStelle extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.tmcLandesMeldeStelle"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Menge der aktuellen Verkehrsmeldungen.
<p>

</p>

@return die Menge TMCMeldungen oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung> getTMCMeldungen();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Modellparameter für die TMC-Meldungserstellung.
	<p>
	&lt;absatz&gt;RDSSIVerfahren = Liste: Liste der Verfahren, deren Störfallindikatoren berücksichtigt werden sollen.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSBerücksichtigeStauverlaufsanalyse = Wert: Gibt an, ob die Stauobjekte aus der Stauverlaufsanalyse als Störfallindikatoren mit der Güte Wert interpretiert werden sollen.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSPlausibStauverlaufsanalyse: Gibt an, ob eine Plausibilisierung der Störfallindikatoren mit den Ergebnissen der Stauverlaufsanalyse erfolgen soll.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSLSIAusdehnung = Wert: Angenommene Ausdehnung einer Störung, die durch einen lokalen Störfallindikator detektiert wurde. Der Parameter wird in Länge pro Minute des Erfassungszyklus angegeben. Beispielsweise führt ein Parameterwert von 60 Meter pro Minute bei einer Zykluszeit der Erfassung von 5 Minuten zu einer angenommenen Ausdehnung von 300 Meter.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSVerzögerungsmatrix: Gibt die Mindestzeitspanne für Verkehrssituationsänderungen an.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSPrioritätenmatrix: Gibt die Prioritäten der Störfallsituationen in Abhängigkeit der ermittelten Güte an.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSAbbildungsmatrix: Gibt die Abbildung der Störfallsituationen auf RDS-Ereignisse an.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSDMax = Wert: Maximaler Abstand zwischen zwei Störfallgrenzen in Meter, die zu einer Zusammenfassung als ein Störfall führen kann. Wenn der Wert größer ist, werden die Störfälle als voneinander unabhängig angesehen.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSDStoerfallAnfang = Wert: Maximaler Abstand einer Störfallgrenze (z.B. Stauwurzel) in Meter zum nächsten Knoten, der dazu führt, dass der	Störfall bis zum Ende des Straßensegmentes erweitert wird.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSDStoerfallEnde = Wert: Maximaler Abstand einer Störfallgrenze (z.B. Stauende) in Meter zum nächsten Knoten, der dazu führt, dass der Störfall bis zum Anfang des Straßensegmentes erweitert wird.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSMindestLaenge = Wert: Mindestlänge in Meter eines Ereignisses, die zu einer Meldung führen kann.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSDMaxEinzelStoerfall = Wert: Maximale Längenangabe für eine Störfallsituation, die durch einen einzelnen lokalen Störfallindikator ermittelt wurde.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSNichtAddieren: Unterbindet die Addition der Längenangaben von zwei oder mehreren Störfallindikatoren innerhalb eines RDS-Abschnitts,	die nicht zu einem Ereignis zusammengefasst werden konnten.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSBaustelleSuchbereichVor = Wert: Erweiterung des Suchbereichs für Baustellen als Erklärungskomponente stromaufwärts. Die Erweiterung wird durch Autobahnkreuze oder Dreiecke beschränkt; d.h. eventuelle Baustellen hinter einem Autobahnkreuz oder Dreieck werden nicht als Erklärungskomponente bei der Meldungserstellung berücksichtigt.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSBaustelleSuchbereichNach = Wert: Erweiterung des Suchbereichs für Baustellen als Erklärungskomponente stromabwärts. Die Erweiterung wird durch Autobahnkreuze oder Dreiecke beschränkt; d.h. eventuelle Baustellen hinter einem Autobahnkreuz oder Dreieck werden nicht als Erklärungskomponente bei der Meldungserstellung berücksichtigt.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSMaxOhneDaten = Wert: Zeitspanne in Minuten, in der neue Daten vorliegen müssen, damit die Meldung aufrecht erhalten bleibt.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSBerücksichtigeBaustellen = Wert: Gibt an, ob als Erklärungskomponente bestehende Baustellen berücksichtigt werden sollen.&lt;&#47;absatz&gt;
						&lt;absatz&gt;RDSAusdehnungProLSI = Wert: Für (lokale) Störfallindikatoren können hier für ihre angenommenen Ausdehnung individuelle Werte angegeben werden.&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz TmcModell.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.parameter.PdTmcModell getPdTmcModell();
	
	/**
	Parameter für die TMC-Meldungsverwaltung.
	<p>
	
	</p>
	@return der Datensatz TmcMeldungsVerwaltung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.parameter.PdTmcMeldungsVerwaltung getPdTmcMeldungsVerwaltung();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Konfigurierende Eigenschaften des Typs.
	<p>
	
	</p>
	@return der Datensatz TmcLandesMeldeStelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.konfigurationsdaten.KdTmcLandesMeldeStelle getKdTmcLandesMeldeStelle();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
