/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Linguistische Variable, definiert durch ein Trapez.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class AtlLinguistischeVariableSichtWeite implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			 _t1
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			 _t2
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			 _t3
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			 _t4
			;
	
		/**
		Name des Zustandes.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name des Zustandes.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Erster Definitionspunkt des Trapez für die linguistische Variable.
		<p>
		
		</p>
		
		@return der Wert von T1.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			 getT1() {
			return _t1;
		}
	
		/**
		Erster Definitionspunkt des Trapez für die linguistische Variable.
		<p>
		
		</p>
		
		@param _t1 der neue Wert von T1.
		*/
		public void setT1(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
		 _t1) {
			this._t1 = _t1;
		}
	
		/**
		Zweiter Definitionspunkt des Trapez für die linguistische Variable.
		<p>
		
		</p>
		
		@return der Wert von T2.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			 getT2() {
			return _t2;
		}
	
		/**
		Zweiter Definitionspunkt des Trapez für die linguistische Variable.
		<p>
		
		</p>
		
		@param _t2 der neue Wert von T2.
		*/
		public void setT2(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
		 _t2) {
			this._t2 = _t2;
		}
	
		/**
		Dritter Definitionspunkt des Trapez für die linguistische Variable.
		<p>
		
		</p>
		
		@return der Wert von T3.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			 getT3() {
			return _t3;
		}
	
		/**
		Dritter Definitionspunkt des Trapez für die linguistische Variable.
		<p>
		
		</p>
		
		@param _t3 der neue Wert von T3.
		*/
		public void setT3(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
		 _t3) {
			this._t3 = _t3;
		}
	
		/**
		Vierter Definitionspunkt des Trapez für die linguistische Variable.
		<p>
		
		</p>
		
		@return der Wert von T4.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			 getT4() {
			return _t4;
		}
	
		/**
		Vierter Definitionspunkt des Trapez für die linguistische Variable.
		<p>
		
		</p>
		
		@param _t4 der neue Wert von T4.
		*/
		public void setT4(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
		 _t4) {
			this._t4 = _t4;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// GanzzahlAttributTyp
				if (getT1() != null) {
	                if (getT1().isZustand()) {
	                    datum.getUnscaledValue("t1").setText(getT1().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("t1").set(getT1().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getT2() != null) {
	                if (getT2().isZustand()) {
	                    datum.getUnscaledValue("t2").setText(getT2().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("t2").set(getT2().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getT3() != null) {
	                if (getT3().isZustand()) {
	                    datum.getUnscaledValue("t3").setText(getT3().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("t3").set(getT3().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getT4() != null) {
	                if (getT4().isZustand()) {
	                    datum.getUnscaledValue("t4").setText(getT4().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("t4").set(getT4().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("t1").isState()) {
							setT1(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
							.getZustand(daten.getScaledValue("t1").getText()));
						} else {
						setT1(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
						(daten.
							getUnscaledValue
						("t1").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("t2").isState()) {
							setT2(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
							.getZustand(daten.getScaledValue("t2").getText()));
						} else {
						setT2(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
						(daten.
							getUnscaledValue
						("t2").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("t3").isState()) {
							setT3(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
							.getZustand(daten.getScaledValue("t3").getText()));
						} else {
						setT3(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
						(daten.
							getUnscaledValue
						("t3").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("t4").isState()) {
							setT4(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
							.getZustand(daten.getScaledValue("t4").getText()));
						} else {
						setT4(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
						(daten.
							getUnscaledValue
						("t4").
								intValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlLinguistischeVariableSichtWeite clone() {
		AtlLinguistischeVariableSichtWeite klon = new AtlLinguistischeVariableSichtWeite();
		
						klon.setName(getName());
						klon.setT1(getT1());
						klon.setT2(getT2());
						klon.setT3(getT3());
						klon.setT4(getT4());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
