/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Bereichswerte der Hysteresefunktion für die Klassifizierung der Umfelddatensensorwerte.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 23
 */
public class AtlUfdsKlassifizierungSchneeFilmDicke implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeFilmDicke
			 _von
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeFilmDicke
			 _bis
			;
	
		/**
		Zugehörigkeit dieser Hysteresestufe beginnt bei diesem Wert.
		<p>
		
		</p>
		
		@return der Wert von Von.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeFilmDicke
			 getVon() {
			return _von;
		}
	
		/**
		Zugehörigkeit dieser Hysteresestufe beginnt bei diesem Wert.
		<p>
		
		</p>
		
		@param _von der neue Wert von Von.
		*/
		public void setVon(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeFilmDicke
		 _von) {
			this._von = _von;
		}
	
		/**
		Zugehörigkeit dieser Hysteresestufe endet bei diesem Wert.
		<p>
		
		</p>
		
		@return der Wert von Bis.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeFilmDicke
			 getBis() {
			return _bis;
		}
	
		/**
		Zugehörigkeit dieser Hysteresestufe endet bei diesem Wert.
		<p>
		
		</p>
		
		@param _bis der neue Wert von Bis.
		*/
		public void setBis(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeFilmDicke
		 _bis) {
			this._bis = _bis;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getVon() != null) {
	                if (getVon().isZustand()) {
	                    datum.getUnscaledValue("von").setText(getVon().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("von").set(getVon().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBis() != null) {
	                if (getBis().isZustand()) {
	                    datum.getUnscaledValue("bis").setText(getBis().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("bis").set(getBis().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("von").isState()) {
							setVon(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeFilmDicke
							.getZustand(daten.getScaledValue("von").getText()));
						} else {
						setVon(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeFilmDicke
						(daten.
							getUnscaledValue
						("von").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("bis").isState()) {
							setBis(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeFilmDicke
							.getZustand(daten.getScaledValue("bis").getText()));
						} else {
						setBis(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeFilmDicke
						(daten.
							getUnscaledValue
						("bis").
								shortValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUfdsKlassifizierungSchneeFilmDicke clone() {
		AtlUfdsKlassifizierungSchneeFilmDicke klon = new AtlUfdsKlassifizierungSchneeFilmDicke();
		
						klon.setVon(getVon());
						klon.setBis(getBis());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
