/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Sensorwert des Umfelddatensensors mit Statusinformationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class AtlUfdsNiederschlagsMenge implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsMenge
			 _wert
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsStatus
			 _status
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsStatus
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 _guete
			= new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			()
			;
	
		/**
		Wert des Umfelddatensensors.
		<p>
		
		</p>
		
		@return der Wert von Wert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsMenge
			 getWert() {
			return _wert;
		}
	
		/**
		Wert des Umfelddatensensors.
		<p>
		
		</p>
		
		@param _wert der neue Wert von Wert.
		*/
		public void setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsMenge
		 _wert) {
			this._wert = _wert;
		}
	
		/**
		Statusinformationen zum Wert, der sich aus unterschiedlichen Zwischenberechnungen ergibt.
		<p>
		
		</p>
		
		@return der Wert von Status.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsStatus
			 getStatus() {
			return _status;
		}
	
		/**
		Statusinformationen zum Wert, der sich aus unterschiedlichen Zwischenberechnungen ergibt.
		<p>
		
		</p>
		
		@param _status der neue Wert von Status.
		*/
		public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsStatus
		 _status) {
			this._status = _status;
		}
	
		/**
		Güteinformationen zum Wert (Güte und Verfahren, welches zur Güteermittlung verwendet wurde).
		<p>
		
		</p>
		
		@return der Wert von Guete.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 getGuete() {
			return _guete;
		}
	
		/**
		Güteinformationen zum Wert (Güte und Verfahren, welches zur Güteermittlung verwendet wurde).
		<p>
		
		</p>
		
		@param _guete der neue Wert von Guete.
		*/
		public void setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
		 _guete) {
			this._guete = _guete;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getWert() != null) {
	                if (getWert().isZustand()) {
	                    datum.getUnscaledValue("Wert").setText(getWert().toString());
	                } else {
						datum.
						getScaledValue
	                	("Wert").set(getWert().getValue());
	                }
				}
				// AttributListenDefinition
					getStatus().bean2Atl(datum.getItem("Status"), factory);
				// AttributListenDefinition
					getGuete().bean2Atl(datum.getItem("Güte"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Wert").isState()) {
							setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsMenge
							.getZustand(daten.getScaledValue("Wert").getText()));
						} else {
						setWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsMenge
						(daten.
							getScaledValue
						("Wert").
							doubleValue
						()));
						}
				// AttributListenDefinition
					getStatus().atl2Bean(daten.getItem("Status"), factory);
				// AttributListenDefinition
					getGuete().atl2Bean(daten.getItem("Güte"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUfdsNiederschlagsMenge clone() {
		AtlUfdsNiederschlagsMenge klon = new AtlUfdsNiederschlagsMenge();
		
						klon.setWert(getWert());
						klon._status = getStatus().clone();
						klon._guete = getGuete().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
