/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Statusinformationen zum Wert, der sich aus unterschiedlichen Zwischenberechnungen ergibt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class AtlUfdsStatus implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusExterneErfassung
			 _erfassung
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusExterneErfassung
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusPlausibilitaetsPruefungFormal
			 _plFormal
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusPlausibilitaetsPruefungFormal
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusPlausibilitaetsPruefungLogisch
			 _plLogisch
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusPlausibilitaetsPruefungLogisch
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusMessWertErsetzung
			 _messWertErsetzung
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusMessWertErsetzung
			()
			;
	
		/**
		Wird von externen Erfassungen gesetzt (z.B. TLS) gesetzt.
		<p>
		
		</p>
		
		@return der Wert von Erfassung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusExterneErfassung
			 getErfassung() {
			return _erfassung;
		}
	
		/**
		Wird von externen Erfassungen gesetzt (z.B. TLS) gesetzt.
		<p>
		
		</p>
		
		@param _erfassung der neue Wert von Erfassung.
		*/
		public void setErfassung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusExterneErfassung
		 _erfassung) {
			this._erfassung = _erfassung;
		}
	
		/**
		Statusinformationen werden von der formalen Plausibilitätsprüfung gesetzt.
		<p>
		
		</p>
		
		@return der Wert von PlFormal.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusPlausibilitaetsPruefungFormal
			 getPlFormal() {
			return _plFormal;
		}
	
		/**
		Statusinformationen werden von der formalen Plausibilitätsprüfung gesetzt.
		<p>
		
		</p>
		
		@param _plFormal der neue Wert von PlFormal.
		*/
		public void setPlFormal(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusPlausibilitaetsPruefungFormal
		 _plFormal) {
			this._plFormal = _plFormal;
		}
	
		/**
		Statusinformationen werden von der logischen Plausibilitätsprüfung gesetzt.
		<p>
		
		</p>
		
		@return der Wert von PlLogisch.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusPlausibilitaetsPruefungLogisch
			 getPlLogisch() {
			return _plLogisch;
		}
	
		/**
		Statusinformationen werden von der logischen Plausibilitätsprüfung gesetzt.
		<p>
		
		</p>
		
		@param _plLogisch der neue Wert von PlLogisch.
		*/
		public void setPlLogisch(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusPlausibilitaetsPruefungLogisch
		 _plLogisch) {
			this._plLogisch = _plLogisch;
		}
	
		/**
		Statusinformation werden von der Messwertersetzung gesetzt.
		<p>
		
		</p>
		
		@return der Wert von MessWertErsetzung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusMessWertErsetzung
			 getMessWertErsetzung() {
			return _messWertErsetzung;
		}
	
		/**
		Statusinformation werden von der Messwertersetzung gesetzt.
		<p>
		
		</p>
		
		@param _messWertErsetzung der neue Wert von MessWertErsetzung.
		*/
		public void setMessWertErsetzung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatusMessWertErsetzung
		 _messWertErsetzung) {
			this._messWertErsetzung = _messWertErsetzung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					getErfassung().bean2Atl(datum.getItem("Erfassung"), factory);
				// AttributListenDefinition
					getPlFormal().bean2Atl(datum.getItem("PlFormal"), factory);
				// AttributListenDefinition
					getPlLogisch().bean2Atl(datum.getItem("PlLogisch"), factory);
				// AttributListenDefinition
					getMessWertErsetzung().bean2Atl(datum.getItem("MessWertErsetzung"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					getErfassung().atl2Bean(daten.getItem("Erfassung"), factory);
				// AttributListenDefinition
					getPlFormal().atl2Bean(daten.getItem("PlFormal"), factory);
				// AttributListenDefinition
					getPlLogisch().atl2Bean(daten.getItem("PlLogisch"), factory);
				// AttributListenDefinition
					getMessWertErsetzung().atl2Bean(daten.getItem("MessWertErsetzung"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUfdsStatus clone() {
		AtlUfdsStatus klon = new AtlUfdsStatus();
		
						klon._erfassung = getErfassung().clone();
						klon._plFormal = getPlFormal().clone();
						klon._plLogisch = getPlLogisch().clone();
						klon._messWertErsetzung = getMessWertErsetzung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
