/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Niederschlagart.
<p>
In der Atmosphäre fallender Niederschlag. Wird gleichzeitig Niederschlagsintensität ermittelt, ist diese an der gleichen Stelle vorzunehmen. Es wird darauf hingewiesen, dass von der Streckenstation bzw. der Sensorik nicht alle Ausprägungen unterstützt werden müssen. Welcher Differenzierungsgrad notwendig und sinnvoll ist, hängt von der Anwendung ab. Bei einfachen Anwendungen können die Ausprägungen 0 und 40, bei normalen Anforderungen 0, 60 und 70 ( entspricht den bisher verwendeten Ausprägungen 00, 01, 02 des Typs 63 ) ausreichen. Es werden die Klassifikation und die Codes nach WMO Tabelle 4680 verwendet.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 254L,
	einheit = ""
)
public class AttUfdsNiederschlagsArt extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("254");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	Daten sind nicht ermittelbar (ist KEIN Fehler).
	<p>
	Wird gesetzt, wenn der entsprechende Wert nicht ermittelbar ist und kein Interpolation sinnvoll möglich ist (z.B. ist die Geschwindigkeit nicht ermittelbar, wenn kein Fahrzeug erfasst wurde).
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_1N_NICHT_ERMITTELBAR = new AttUfdsNiederschlagsArt("nicht ermittelbar", 		Short
	.valueOf("-1"));

	/**
	Daten sind fehlerhaft.
	<p>
	Wird gesetzt, wenn die Daten als fehlerhaft erkannt wurden.
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_2N_FEHLERHAFT = new AttUfdsNiederschlagsArt("fehlerhaft", 		Short
	.valueOf("-2"));

	/**
	Daten nicht ermittelbar, da bereits Basiswerte fehlerhaft.
	<p>
	Wird gesetzt, wenn Daten, die zur Berechnung dieses Werts notwendig sind, bereits als fehlerhaft gekennzeichnet sind, oder wenn die Berechnung aus anderen Gründen (z.B. Nenner = 0 in der Berechnungsformel) nicht möglich war.
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT = new AttUfdsNiederschlagsArt("nicht ermittelbar/fehlerhaft", 		Short
	.valueOf("-3"));

	/**
	Kein Niederschlag.
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_0_KEIN_NIEDERSCHLAG = new AttUfdsNiederschlagsArt("kein Niederschlag", 		Short
	.valueOf("0"));

	/**
	Niederschlag aller Art.
	<p>
	Nicht näher Klassifizier- und quantifizierbar oder Sensorik nicht dafür ausgelegt.
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_40_NIEDERSCHLAG_ALLER_ART = new AttUfdsNiederschlagsArt("Niederschlag aller Art", 		Short
	.valueOf("40"));

	/**
	Leichter oder mittlerer Niederschlag aller Art (kleiner 50 Partikel&#47;Minute).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_41_LEICHTER_MITTLERER_NIEDERSCHLAG = new AttUfdsNiederschlagsArt("Leichter/mittlerer Niederschlag", 		Short
	.valueOf("41"));

	/**
	42 Starker Niederschlag aller Art ( &gt; 50 Partikel&#47;Minute).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_42_STARKER_NIEDERSCHLAG = new AttUfdsNiederschlagsArt("starker Niederschlag", 		Short
	.valueOf("42"));

	/**
	Sprühregen (keine weitere Klassifikation von Sprühregen möglich).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_50_SPRUEHREGEN = new AttUfdsNiederschlagsArt("Sprühregen", 		Short
	.valueOf("50"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_51_SPRUEHREGEN_WMO1 = new AttUfdsNiederschlagsArt("Sprühregen WMO1", 		Short
	.valueOf("51"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_52_SPRUEHREGEN_WMO2 = new AttUfdsNiederschlagsArt("Sprühregen WMO2", 		Short
	.valueOf("52"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_53_SPRUEHREGEN_WMO3 = new AttUfdsNiederschlagsArt("Sprühregen WMO3", 		Short
	.valueOf("53"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_54_SPRUEHREGEN_WMO4 = new AttUfdsNiederschlagsArt("Sprühregen WMO4", 		Short
	.valueOf("54"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_55_SPRUEHREGEN_WMO5 = new AttUfdsNiederschlagsArt("Sprühregen WMO5", 		Short
	.valueOf("55"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_56_SPRUEHREGEN_WMO6 = new AttUfdsNiederschlagsArt("Sprühregen WMO6", 		Short
	.valueOf("56"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_57_SPRUEHREGEN_WMO7 = new AttUfdsNiederschlagsArt("Sprühregen WMO7", 		Short
	.valueOf("57"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_58_SPRUEHREGEN_WMO8 = new AttUfdsNiederschlagsArt("Sprühregen WMO8", 		Short
	.valueOf("58"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_59_SPRUEHREGEN_WMO9 = new AttUfdsNiederschlagsArt("Sprühregen WMO9", 		Short
	.valueOf("59"));

	/**
	Regen bzw. flüssiger Niederschlag (Keine weitere Klassifikation von Regen möglich).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_60_REGEN = new AttUfdsNiederschlagsArt("Regen", 		Short
	.valueOf("60"));

	/**
	Regen bzw. flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_61_REGEN_WMO1 = new AttUfdsNiederschlagsArt("Regen WMO1", 		Short
	.valueOf("61"));

	/**
	Regen bzw. flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_62_REGEN_WMO2 = new AttUfdsNiederschlagsArt("Regen WMO2", 		Short
	.valueOf("62"));

	/**
	Regen bzw. flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_63_REGEN_WMO3 = new AttUfdsNiederschlagsArt("Regen WMO3", 		Short
	.valueOf("63"));

	/**
	Regen bzw. flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_64_REGEN_WMO4 = new AttUfdsNiederschlagsArt("Regen WMO4", 		Short
	.valueOf("64"));

	/**
	Regen bzw. flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_65_REGEN_WMO5 = new AttUfdsNiederschlagsArt("Regen WMO5", 		Short
	.valueOf("65"));

	/**
	Regen bzw. flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_66_REGEN_WMO6 = new AttUfdsNiederschlagsArt("Regen WMO6", 		Short
	.valueOf("66"));

	/**
	Regen bzw. flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_67_REGEN_WMO7 = new AttUfdsNiederschlagsArt("Regen WMO7", 		Short
	.valueOf("67"));

	/**
	Regen bzw. flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_68_REGEN_WMO8 = new AttUfdsNiederschlagsArt("Regen WMO8", 		Short
	.valueOf("68"));

	/**
	Regen bzw. flüssiger Niederschlag(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_69_REGEN_WMO9 = new AttUfdsNiederschlagsArt("Regen WMO9", 		Short
	.valueOf("69"));

	/**
	Schnee bzw. gefrorener Niederschlag (Keine weitere Klassifikation von gefrorenem Niederschlag möglich).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_70_SCHNEEG_GEFRORENER_NIEDERSCHLAG = new AttUfdsNiederschlagsArt("SchneeG/gefrorener Niederschlag", 		Short
	.valueOf("70"));

	/**
	Schnee bzw. gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_71_SCHNEE_WMO1 = new AttUfdsNiederschlagsArt("Schnee WMO1", 		Short
	.valueOf("71"));

	/**
	Schnee bzw. gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_72_SCHNEE_WMO2 = new AttUfdsNiederschlagsArt("Schnee WMO2", 		Short
	.valueOf("72"));

	/**
	Schnee bzw. gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_73_SCHNEE_WMO3 = new AttUfdsNiederschlagsArt("Schnee WMO3", 		Short
	.valueOf("73"));

	/**
	Graupel bzw. gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_74_GRAUPEL_WMO1 = new AttUfdsNiederschlagsArt("Graupel WMO1", 		Short
	.valueOf("74"));

	/**
	Graupel bzw. gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_75_GRAUPEL_WMO2 = new AttUfdsNiederschlagsArt("Graupel WMO2", 		Short
	.valueOf("75"));

	/**
	Graupel bzw. gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_76_GRAUPEL_WMO3 = new AttUfdsNiederschlagsArt("Graupel WMO3", 		Short
	.valueOf("76"));

	/**
	Graupel bzw. gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_77_GRAUPEL_WMO4 = new AttUfdsNiederschlagsArt("Graupel WMO4", 		Short
	.valueOf("77"));

	/**
	Graupel bzw. gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_78_GRAUPEL_WMO5 = new AttUfdsNiederschlagsArt("Graupel WMO5", 		Short
	.valueOf("78"));

	/**
	Graupel bzw. gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_79_GRAUPEL_WMO6 = new AttUfdsNiederschlagsArt("Graupel WMO6", 		Short
	.valueOf("79"));

	/**
	Schauer bzw. wechselnder Niederschlag (Keine weitere Klassifikation von wechselndem Niederschlag möglich).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_80_SCHAUER_WECHSELNDER_NIEDERSCHLAG = new AttUfdsNiederschlagsArt("Schauer/wechselnder Niederschlag", 		Short
	.valueOf("80"));

	/**
	Schauer bzw. wechselnder flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_81_REGENSCHAUER_WMO1 = new AttUfdsNiederschlagsArt("Regenschauer WMO1", 		Short
	.valueOf("81"));

	/**
	Schauer bzw. wechselnder flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_82_REGENSCHAUER_WMO2 = new AttUfdsNiederschlagsArt("Regenschauer WMO2", 		Short
	.valueOf("82"));

	/**
	Schauer bzw. wechselnder flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_83_REGENSCHAUER_WMO3 = new AttUfdsNiederschlagsArt("Regenschauer WMO3", 		Short
	.valueOf("83"));

	/**
	Schauer bzw. wechselnder flüssiger Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_84_REGENSCHAUER_WMO4 = new AttUfdsNiederschlagsArt("Regenschauer WMO4", 		Short
	.valueOf("84"));

	/**
	Schneeschauer bzw. wechselnder gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_85_SCHNEESCHAUER_WMO1 = new AttUfdsNiederschlagsArt("Schneeschauer WMO1", 		Short
	.valueOf("85"));

	/**
	Schneeschauer bzw. wechselnder gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_86_SCHNEESCHAUER_WMO2 = new AttUfdsNiederschlagsArt("Schneeschauer WMO2", 		Short
	.valueOf("86"));

	/**
	Schneeschauer bzw. wechselnder gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_87_SCHNEESCHAUER_WMO3 = new AttUfdsNiederschlagsArt("Schneeschauer WMO3", 		Short
	.valueOf("87"));

	/**
	Schneeschauer bzw. wechselnder gefrorener Niederschlag (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_88_SCHNEESCHAUER_WMO4 = new AttUfdsNiederschlagsArt("Schneeschauer WMO4", 		Short
	.valueOf("88"));

	/**
	Hagel (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_89_HAGEL = new AttUfdsNiederschlagsArt("Hagel", 		Short
	.valueOf("89"));

	/**
	Gewitter (Keine weitere Klassifikation von Gewitter möglich).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_90_GEWITTER = new AttUfdsNiederschlagsArt("Gewitter", 		Short
	.valueOf("90"));

	/**
	Gewitter (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_91_GEWITTER_WMO1 = new AttUfdsNiederschlagsArt("Gewitter WMO1", 		Short
	.valueOf("91"));

	/**
	Gewitter (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_92_GEWITTER_WMO2 = new AttUfdsNiederschlagsArt("Gewitter WMO2", 		Short
	.valueOf("92"));

	/**
	Gewitter (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_93_GEWITTER_WMO3 = new AttUfdsNiederschlagsArt("Gewitter WMO3", 		Short
	.valueOf("93"));

	/**
	Gewitter (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_94_GEWITTER_WMO4 = new AttUfdsNiederschlagsArt("Gewitter WMO4", 		Short
	.valueOf("94"));

	/**
	Gewitter (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_95_GEWITTER_WMO5 = new AttUfdsNiederschlagsArt("Gewitter WMO5", 		Short
	.valueOf("95"));

	/**
	Gewitter (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_96_GEWITTER_WMO6 = new AttUfdsNiederschlagsArt("Gewitter WMO6", 		Short
	.valueOf("96"));

	/**
	Gewitter (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_97_GEWITTER_WMO7 = new AttUfdsNiederschlagsArt("Gewitter WMO7", 		Short
	.valueOf("97"));

	/**
	Gewitter (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_98_GEWITTER_WMO8 = new AttUfdsNiederschlagsArt("Gewitter WMO8", 		Short
	.valueOf("98"));

	/**
	Gewitter (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_99_GEWITTER_WMO9 = new AttUfdsNiederschlagsArt("Gewitter WMO9", 		Short
	.valueOf("99"));

	/**
	Platzregen (plötzlich auftretender starker Niederschlag; Übergang trocken - Regen und gleichzeitig Niederschlagsintensität &gt; 17 mm&#47;h) (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttUfdsNiederschlagsArt ZUSTAND_100_PLATZREGEN = new AttUfdsNiederschlagsArt("Platzregen", 		Short
	.valueOf("100"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdsNiederschlagsArt getZustand(final 		Short
	 value) {
		for (AttUfdsNiederschlagsArt e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdsNiederschlagsArt getZustand(final String value) {
		for (AttUfdsNiederschlagsArt e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdsNiederschlagsArt> getZustaende() {
		List<AttUfdsNiederschlagsArt> list = new ArrayList<AttUfdsNiederschlagsArt>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_2N_FEHLERHAFT);
		list.add(ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT);
		list.add(ZUSTAND_0_KEIN_NIEDERSCHLAG);
		list.add(ZUSTAND_40_NIEDERSCHLAG_ALLER_ART);
		list.add(ZUSTAND_41_LEICHTER_MITTLERER_NIEDERSCHLAG);
		list.add(ZUSTAND_42_STARKER_NIEDERSCHLAG);
		list.add(ZUSTAND_50_SPRUEHREGEN);
		list.add(ZUSTAND_51_SPRUEHREGEN_WMO1);
		list.add(ZUSTAND_52_SPRUEHREGEN_WMO2);
		list.add(ZUSTAND_53_SPRUEHREGEN_WMO3);
		list.add(ZUSTAND_54_SPRUEHREGEN_WMO4);
		list.add(ZUSTAND_55_SPRUEHREGEN_WMO5);
		list.add(ZUSTAND_56_SPRUEHREGEN_WMO6);
		list.add(ZUSTAND_57_SPRUEHREGEN_WMO7);
		list.add(ZUSTAND_58_SPRUEHREGEN_WMO8);
		list.add(ZUSTAND_59_SPRUEHREGEN_WMO9);
		list.add(ZUSTAND_60_REGEN);
		list.add(ZUSTAND_61_REGEN_WMO1);
		list.add(ZUSTAND_62_REGEN_WMO2);
		list.add(ZUSTAND_63_REGEN_WMO3);
		list.add(ZUSTAND_64_REGEN_WMO4);
		list.add(ZUSTAND_65_REGEN_WMO5);
		list.add(ZUSTAND_66_REGEN_WMO6);
		list.add(ZUSTAND_67_REGEN_WMO7);
		list.add(ZUSTAND_68_REGEN_WMO8);
		list.add(ZUSTAND_69_REGEN_WMO9);
		list.add(ZUSTAND_70_SCHNEEG_GEFRORENER_NIEDERSCHLAG);
		list.add(ZUSTAND_71_SCHNEE_WMO1);
		list.add(ZUSTAND_72_SCHNEE_WMO2);
		list.add(ZUSTAND_73_SCHNEE_WMO3);
		list.add(ZUSTAND_74_GRAUPEL_WMO1);
		list.add(ZUSTAND_75_GRAUPEL_WMO2);
		list.add(ZUSTAND_76_GRAUPEL_WMO3);
		list.add(ZUSTAND_77_GRAUPEL_WMO4);
		list.add(ZUSTAND_78_GRAUPEL_WMO5);
		list.add(ZUSTAND_79_GRAUPEL_WMO6);
		list.add(ZUSTAND_80_SCHAUER_WECHSELNDER_NIEDERSCHLAG);
		list.add(ZUSTAND_81_REGENSCHAUER_WMO1);
		list.add(ZUSTAND_82_REGENSCHAUER_WMO2);
		list.add(ZUSTAND_83_REGENSCHAUER_WMO3);
		list.add(ZUSTAND_84_REGENSCHAUER_WMO4);
		list.add(ZUSTAND_85_SCHNEESCHAUER_WMO1);
		list.add(ZUSTAND_86_SCHNEESCHAUER_WMO2);
		list.add(ZUSTAND_87_SCHNEESCHAUER_WMO3);
		list.add(ZUSTAND_88_SCHNEESCHAUER_WMO4);
		list.add(ZUSTAND_89_HAGEL);
		list.add(ZUSTAND_90_GEWITTER);
		list.add(ZUSTAND_91_GEWITTER_WMO1);
		list.add(ZUSTAND_92_GEWITTER_WMO2);
		list.add(ZUSTAND_93_GEWITTER_WMO3);
		list.add(ZUSTAND_94_GEWITTER_WMO4);
		list.add(ZUSTAND_95_GEWITTER_WMO5);
		list.add(ZUSTAND_96_GEWITTER_WMO6);
		list.add(ZUSTAND_97_GEWITTER_WMO7);
		list.add(ZUSTAND_98_GEWITTER_WMO8);
		list.add(ZUSTAND_99_GEWITTER_WMO9);
		list.add(ZUSTAND_100_PLATZREGEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut UfdsNiederschlagsArt.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdsNiederschlagsArt(final 		Short
	 value) {
		super(value);
	}
	
	private AttUfdsNiederschlagsArt(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
