/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class KdUmfeldDatenSensor extends AbstractKonfigurationsDatensatz<KdUmfeldDatenSensor.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
				 _vorgaenger
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
				 _nachfolger
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
				 _ersatzSensor
				;
				private 	Object
				 _umfeldDatenSensorQuelle
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTyp
				 _typ
				;
		
			/**
			Vorgänger dieses Umfelddatensensors gehört zur referenzierten Umfeldatenmessstelle.
			<p>
			
			</p>
			
			@return der Wert von Vorgaenger.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
				 getVorgaenger() {
				return _vorgaenger;
			}
		
			/**
			Vorgänger dieses Umfelddatensensors gehört zur referenzierten Umfeldatenmessstelle.
			<p>
			
			</p>
			
			@param _vorgaenger der neue Wert von Vorgaenger.
			*/
			public void setVorgaenger(	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
			 _vorgaenger) {
				this._vorgaenger = _vorgaenger;
			}
		
			/**
			Nachfolger dieses Umfelddatensensors gehört zur referenzierten Umfeldatenmessstelle.
			<p>
			
			</p>
			
			@return der Wert von Nachfolger.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
				 getNachfolger() {
				return _nachfolger;
			}
		
			/**
			Nachfolger dieses Umfelddatensensors gehört zur referenzierten Umfeldatenmessstelle.
			<p>
			
			</p>
			
			@param _nachfolger der neue Wert von Nachfolger.
			*/
			public void setNachfolger(	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
			 _nachfolger) {
				this._nachfolger = _nachfolger;
			}
		
			/**
			Ersatzsensor dieses Umfelddatensensors für die Messwertersetzung.
			<p>
			
			</p>
			
			@return der Wert von ErsatzSensor.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
				 getErsatzSensor() {
				return _ersatzSensor;
			}
		
			/**
			Ersatzsensor dieses Umfelddatensensors für die Messwertersetzung.
			<p>
			
			</p>
			
			@param _ersatzSensor der neue Wert von ErsatzSensor.
			*/
			public void setErsatzSensor(	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
			 _ersatzSensor) {
				this._ersatzSensor = _ersatzSensor;
			}
		
			/**
			Referenz auf das Objekt, welches die Daten für diesen Umfelddatensensor liefert (z. B. UFD-DE gemäß TLS).
			<p>
			
			</p>
			
			@return der Wert von UmfeldDatenSensorQuelle.
			*/
				public 	Object
				 getUmfeldDatenSensorQuelle() {
				return _umfeldDatenSensorQuelle;
			}
		
			/**
			Referenz auf das Objekt, welches die Daten für diesen Umfelddatensensor liefert (z. B. UFD-DE gemäß TLS).
			<p>
			
			</p>
			
			@param _umfeldDatenSensorQuelle der neue Wert von UmfeldDatenSensorQuelle.
			*/
			public void setUmfeldDatenSensorQuelle(	Object
			 _umfeldDatenSensorQuelle) {
				this._umfeldDatenSensorQuelle = _umfeldDatenSensorQuelle;
			}
		
			/**
			Typ des Umfeldatensensors für diesen Umfelddatensensortyp an dieser Umfelddatenmessstelle (Hauptsensor oder Nebensensor).
			<p>
			
			</p>
			
			@return der Wert von Typ.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTyp
				 getTyp() {
				return _typ;
			}
		
			/**
			Typ des Umfeldatensensors für diesen Umfelddatensensortyp an dieser Umfelddatenmessstelle (Hauptsensor oder Nebensensor).
			<p>
			
			</p>
			
			@param _typ der neue Wert von Typ.
			*/
			public void setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTyp
			 _typ) {
				this._typ = _typ;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soVorgaenger = getVorgaenger();
						final SystemObject tmpVorgaenger;
							if (soVorgaenger instanceof SystemObject) {
								tmpVorgaenger = (SystemObject)soVorgaenger;
							} else if(soVorgaenger instanceof SystemObjekt){
								tmpVorgaenger = ((SystemObjekt)soVorgaenger).getSystemObject();
							} else{
								tmpVorgaenger = null;
							}
						datum.getReferenceValue("Vorgänger").setSystemObject(tmpVorgaenger);
					// ObjektReferenzAttributTyp
						final Object soNachfolger = getNachfolger();
						final SystemObject tmpNachfolger;
							if (soNachfolger instanceof SystemObject) {
								tmpNachfolger = (SystemObject)soNachfolger;
							} else if(soNachfolger instanceof SystemObjekt){
								tmpNachfolger = ((SystemObjekt)soNachfolger).getSystemObject();
							} else{
								tmpNachfolger = null;
							}
						datum.getReferenceValue("Nachfolger").setSystemObject(tmpNachfolger);
					// ObjektReferenzAttributTyp
						final Object soErsatzSensor = getErsatzSensor();
						final SystemObject tmpErsatzSensor;
							if (soErsatzSensor instanceof SystemObject) {
								tmpErsatzSensor = (SystemObject)soErsatzSensor;
							} else if(soErsatzSensor instanceof SystemObjekt){
								tmpErsatzSensor = ((SystemObjekt)soErsatzSensor).getSystemObject();
							} else{
								tmpErsatzSensor = null;
							}
						datum.getReferenceValue("ErsatzSensor").setSystemObject(tmpErsatzSensor);
					// ObjektReferenzAttributTyp
						final Object soUmfeldDatenSensorQuelle = getUmfeldDatenSensorQuelle();
						final SystemObject tmpUmfeldDatenSensorQuelle;
							if (soUmfeldDatenSensorQuelle instanceof SystemObject) {
								tmpUmfeldDatenSensorQuelle = (SystemObject)soUmfeldDatenSensorQuelle;
							} else if(soUmfeldDatenSensorQuelle instanceof SystemObjekt){
								tmpUmfeldDatenSensorQuelle = ((SystemObjekt)soUmfeldDatenSensorQuelle).getSystemObject();
							} else{
								tmpUmfeldDatenSensorQuelle = null;
							}
						datum.getReferenceValue("UmfeldDatenSensorQuelle").setSystemObject(tmpUmfeldDatenSensorQuelle);
					// GanzzahlAttributTyp
					if (getTyp() != null) {
		                if (getTyp().isZustand()) {
		                    datum.getUnscaledValue("Typ").setText(getTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Typ").set(getTyp().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idVorgaenger = daten.getReferenceValue("Vorgänger").getId();
						final SystemObjekt tmpVorgaenger;
						if (idVorgaenger == 0) {
							tmpVorgaenger = null;
						} else {
							final SystemObject soVorgaenger = factory.getDav().getDataModel().getObject(idVorgaenger);
							if (soVorgaenger == null) {
									tmpVorgaenger = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.impl.UmfeldDatenMessStelleUngueltig(idVorgaenger);
							} else {
								tmpVorgaenger = factory.getModellobjekt(soVorgaenger);
							}
						}
						setVorgaenger((	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
						) tmpVorgaenger);
					// ObjektReferenzAttributTyp
						final long idNachfolger = daten.getReferenceValue("Nachfolger").getId();
						final SystemObjekt tmpNachfolger;
						if (idNachfolger == 0) {
							tmpNachfolger = null;
						} else {
							final SystemObject soNachfolger = factory.getDav().getDataModel().getObject(idNachfolger);
							if (soNachfolger == null) {
									tmpNachfolger = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.impl.UmfeldDatenMessStelleUngueltig(idNachfolger);
							} else {
								tmpNachfolger = factory.getModellobjekt(soNachfolger);
							}
						}
						setNachfolger((	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle
						) tmpNachfolger);
					// ObjektReferenzAttributTyp
						final long idErsatzSensor = daten.getReferenceValue("ErsatzSensor").getId();
						final SystemObjekt tmpErsatzSensor;
						if (idErsatzSensor == 0) {
							tmpErsatzSensor = null;
						} else {
							final SystemObject soErsatzSensor = factory.getDav().getDataModel().getObject(idErsatzSensor);
							if (soErsatzSensor == null) {
									tmpErsatzSensor = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.impl.UmfeldDatenSensorUngueltig(idErsatzSensor);
							} else {
								tmpErsatzSensor = factory.getModellobjekt(soErsatzSensor);
							}
						}
						setErsatzSensor((	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
						) tmpErsatzSensor);
					// ObjektReferenzAttributTyp
						final long idUmfeldDatenSensorQuelle = daten.getReferenceValue("UmfeldDatenSensorQuelle").getId();
						final SystemObjekt tmpUmfeldDatenSensorQuelle;
						if (idUmfeldDatenSensorQuelle == 0) {
							tmpUmfeldDatenSensorQuelle = null;
						} else {
							final SystemObject soUmfeldDatenSensorQuelle = factory.getDav().getDataModel().getObject(idUmfeldDatenSensorQuelle);
							if (soUmfeldDatenSensorQuelle == null) {
									tmpUmfeldDatenSensorQuelle = new BaseUngueltigesSystemObjekt(idUmfeldDatenSensorQuelle);
							} else {
								tmpUmfeldDatenSensorQuelle = factory.getModellobjekt(soUmfeldDatenSensorQuelle);
							}
						}
						setUmfeldDatenSensorQuelle((	Object
						) tmpUmfeldDatenSensorQuelle);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Typ").isState()) {
								setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTyp
								.getZustand(daten.getScaledValue("Typ").getText()));
							} else {
							setTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTyp
							(daten.
								getUnscaledValue
							("Typ").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setVorgaenger(getVorgaenger());
							klon.setNachfolger(getNachfolger());
							klon.setErsatzSensor(getErsatzSensor());
							klon.setUmfeldDatenSensorQuelle(getUmfeldDatenSensorQuelle());
							klon.setTyp(getTyp());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.umfeldDatenSensor";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdUmfeldDatenSensor(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
