/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Werte für den Sensor des Luftdrucks.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class UfdsLuftDruckImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsLuftDruck { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public UfdsLuftDruckImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public UfdsLuftDruckImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein UfdsLuftDruck.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsKlassifizierungLuftDruck getPdUfdsKlassifizierungLuftDruck() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsKlassifizierungLuftDruck.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMeteorologischeKontrolleLuftDruck getPdUfdsMeteorologischeKontrolleLuftDruck() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMeteorologischeKontrolleLuftDruck.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMessWertErsetzung getPdUfdsMessWertErsetzung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMessWertErsetzung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsDifferenzialKontrolleLuftDruck getPdUfdsDifferenzialKontrolleLuftDruck() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsDifferenzialKontrolleLuftDruck.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAusfallUeberwachung getPdUfdsAusfallUeberwachung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAusfallUeberwachung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenSensor getKdUmfeldDatenSensor() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenSensor.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAnstiegAbstiegKontrolleLuftDruck getPdUfdsAnstiegAbstiegKontrolleLuftDruck() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAnstiegAbstiegKontrolleLuftDruck.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsLuftDruck getOdUfdsLuftDruck() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsLuftDruck.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsStufeLuftDruck getOdUfdsStufeLuftDruck() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsStufeLuftDruck.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAggregationLuftDruck getPdUfdsAggregationLuftDruck() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAggregationLuftDruck.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsLangzeitPLPruefungLuftDruck getPdUfdsLangzeitPLPruefungLuftDruck() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsLangzeitPLPruefungLuftDruck.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
