/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eine Umfelddatenmessstelle fasst beliebige Umfelddatensensoren zusammen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class UmfeldDatenMessStelleImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public UmfeldDatenMessStelleImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public UmfeldDatenMessStelleImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein UmfeldDatenMessStelle.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> umfeldDatenSensoren;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getUmfeldDatenSensoren() {
		if (umfeldDatenSensoren == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("UmfeldDatenSensoren") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("UmfeldDatenSensoren").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor) getObjektFactory().getModellobjekt(so));
			}
			umfeldDatenSensoren = Collections.unmodifiableCollection(menge);
		}
		return umfeldDatenSensoren;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterFahrBahnZustandFuzzy getPdUfdmsParameterFahrBahnZustandFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterFahrBahnZustandFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterMeteorologischeKontrolle getPdUfdmsParameterMeteorologischeKontrolle() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterMeteorologischeKontrolle.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsSichtVerhaeltnisseFuzzy getOdUfdmsSichtVerhaeltnisseFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsSichtVerhaeltnisseFuzzy.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsAbtrockungsPhasen getPdUfdmsAbtrockungsPhasen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsAbtrockungsPhasen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterSichtVerhaeltnisseFuzzy getPdUfdmsParameterSichtVerhaeltnisseFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterSichtVerhaeltnisseFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsGlaette getOdUfdmsGlaette() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsGlaette.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterGlaetteFuzzy getPdUfdmsParameterGlaetteFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdmsParameterGlaetteFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsGlaetteFuzzy getOdUfdmsGlaetteFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsGlaetteFuzzy.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsTaupunktTemperaturLuft getOdUfdmsTaupunktTemperaturLuft() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsTaupunktTemperaturLuft.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsTaupunktTemperaturFahrBahn getOdUfdmsTaupunktTemperaturFahrBahn() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsTaupunktTemperaturFahrBahn.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsFahrBahnZustandFuzzy getOdUfdmsFahrBahnZustandFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsFahrBahnZustandFuzzy.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsNaesseStufe getOdUfdmsNaesseStufe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdmsNaesseStufe.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenMessStelle getKdUmfeldDatenMessStelle() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenMessStelle.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis getPdFuzzyRegelbasis() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
