/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnisse der Glättewarnung und Prognose für diese Umfelddatenmessstelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 20
 */
public class OdUfdmsGlaette extends AbstractOnlineDatensatz<OdUfdmsGlaette.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Prognose,
				};
			}
	
			/**
			 * Prognosewerte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Prognose = new Aspekte("Prognose", "asp.prognose");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 _aktuellerZustand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 _prognoseZustandIn5Minuten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 _prognoseZustandIn15Minuten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 _prognoseZustandIn30Minuten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 _prognoseZustandIn60Minuten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 _prognoseZustandIn90Minuten
				;
		
			/**
			Aktueller Wert der Glätteprognose.
			<p>
			
			</p>
			
			@return der Wert von AktuellerZustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 getAktuellerZustand() {
				return _aktuellerZustand;
			}
		
			/**
			Aktueller Wert der Glätteprognose.
			<p>
			
			</p>
			
			@param _aktuellerZustand der neue Wert von AktuellerZustand.
			*/
			public void setAktuellerZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			 _aktuellerZustand) {
				this._aktuellerZustand = _aktuellerZustand;
			}
		
			/**
			Wert der Glätteprognose für den Prognosehorizont 5 Minuten.
			<p>
			
			</p>
			
			@return der Wert von PrognoseZustandIn5Minuten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 getPrognoseZustandIn5Minuten() {
				return _prognoseZustandIn5Minuten;
			}
		
			/**
			Wert der Glätteprognose für den Prognosehorizont 5 Minuten.
			<p>
			
			</p>
			
			@param _prognoseZustandIn5Minuten der neue Wert von PrognoseZustandIn5Minuten.
			*/
			public void setPrognoseZustandIn5Minuten(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			 _prognoseZustandIn5Minuten) {
				this._prognoseZustandIn5Minuten = _prognoseZustandIn5Minuten;
			}
		
			/**
			Wert der Glätteprognose für den Prognosehorizont 15 Minuten.
			<p>
			
			</p>
			
			@return der Wert von PrognoseZustandIn15Minuten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 getPrognoseZustandIn15Minuten() {
				return _prognoseZustandIn15Minuten;
			}
		
			/**
			Wert der Glätteprognose für den Prognosehorizont 15 Minuten.
			<p>
			
			</p>
			
			@param _prognoseZustandIn15Minuten der neue Wert von PrognoseZustandIn15Minuten.
			*/
			public void setPrognoseZustandIn15Minuten(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			 _prognoseZustandIn15Minuten) {
				this._prognoseZustandIn15Minuten = _prognoseZustandIn15Minuten;
			}
		
			/**
			Wert der Glätteprognose für den Prognosehorizont 30 Minuten.
			<p>
			
			</p>
			
			@return der Wert von PrognoseZustandIn30Minuten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 getPrognoseZustandIn30Minuten() {
				return _prognoseZustandIn30Minuten;
			}
		
			/**
			Wert der Glätteprognose für den Prognosehorizont 30 Minuten.
			<p>
			
			</p>
			
			@param _prognoseZustandIn30Minuten der neue Wert von PrognoseZustandIn30Minuten.
			*/
			public void setPrognoseZustandIn30Minuten(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			 _prognoseZustandIn30Minuten) {
				this._prognoseZustandIn30Minuten = _prognoseZustandIn30Minuten;
			}
		
			/**
			Wert der Glätteprognose für den Prognosehorizont 60 Minuten.
			<p>
			
			</p>
			
			@return der Wert von PrognoseZustandIn60Minuten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 getPrognoseZustandIn60Minuten() {
				return _prognoseZustandIn60Minuten;
			}
		
			/**
			Wert der Glätteprognose für den Prognosehorizont 60 Minuten.
			<p>
			
			</p>
			
			@param _prognoseZustandIn60Minuten der neue Wert von PrognoseZustandIn60Minuten.
			*/
			public void setPrognoseZustandIn60Minuten(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			 _prognoseZustandIn60Minuten) {
				this._prognoseZustandIn60Minuten = _prognoseZustandIn60Minuten;
			}
		
			/**
			Wert der Glätteprognose für den Prognosehorizont 90 Minuten.
			<p>
			
			</p>
			
			@return der Wert von PrognoseZustandIn90Minuten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
				 getPrognoseZustandIn90Minuten() {
				return _prognoseZustandIn90Minuten;
			}
		
			/**
			Wert der Glätteprognose für den Prognosehorizont 90 Minuten.
			<p>
			
			</p>
			
			@param _prognoseZustandIn90Minuten der neue Wert von PrognoseZustandIn90Minuten.
			*/
			public void setPrognoseZustandIn90Minuten(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
			 _prognoseZustandIn90Minuten) {
				this._prognoseZustandIn90Minuten = _prognoseZustandIn90Minuten;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getAktuellerZustand() != null) {
		                if (getAktuellerZustand().isZustand()) {
		                    datum.getUnscaledValue("AktuellerZustand").setText(getAktuellerZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AktuellerZustand").set(getAktuellerZustand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPrognoseZustandIn5Minuten() != null) {
		                if (getPrognoseZustandIn5Minuten().isZustand()) {
		                    datum.getUnscaledValue("PrognoseZustandIn5Minuten").setText(getPrognoseZustandIn5Minuten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PrognoseZustandIn5Minuten").set(getPrognoseZustandIn5Minuten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPrognoseZustandIn15Minuten() != null) {
		                if (getPrognoseZustandIn15Minuten().isZustand()) {
		                    datum.getUnscaledValue("PrognoseZustandIn15Minuten").setText(getPrognoseZustandIn15Minuten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PrognoseZustandIn15Minuten").set(getPrognoseZustandIn15Minuten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPrognoseZustandIn30Minuten() != null) {
		                if (getPrognoseZustandIn30Minuten().isZustand()) {
		                    datum.getUnscaledValue("PrognoseZustandIn30Minuten").setText(getPrognoseZustandIn30Minuten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PrognoseZustandIn30Minuten").set(getPrognoseZustandIn30Minuten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPrognoseZustandIn60Minuten() != null) {
		                if (getPrognoseZustandIn60Minuten().isZustand()) {
		                    datum.getUnscaledValue("PrognoseZustandIn60Minuten").setText(getPrognoseZustandIn60Minuten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PrognoseZustandIn60Minuten").set(getPrognoseZustandIn60Minuten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPrognoseZustandIn90Minuten() != null) {
		                if (getPrognoseZustandIn90Minuten().isZustand()) {
		                    datum.getUnscaledValue("PrognoseZustandIn90Minuten").setText(getPrognoseZustandIn90Minuten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PrognoseZustandIn90Minuten").set(getPrognoseZustandIn90Minuten().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AktuellerZustand").isState()) {
								setAktuellerZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
								.getZustand(daten.getScaledValue("AktuellerZustand").getText()));
							} else {
							setAktuellerZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
							(daten.
								getUnscaledValue
							("AktuellerZustand").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PrognoseZustandIn5Minuten").isState()) {
								setPrognoseZustandIn5Minuten(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
								.getZustand(daten.getScaledValue("PrognoseZustandIn5Minuten").getText()));
							} else {
							setPrognoseZustandIn5Minuten(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
							(daten.
								getUnscaledValue
							("PrognoseZustandIn5Minuten").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PrognoseZustandIn15Minuten").isState()) {
								setPrognoseZustandIn15Minuten(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
								.getZustand(daten.getScaledValue("PrognoseZustandIn15Minuten").getText()));
							} else {
							setPrognoseZustandIn15Minuten(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
							(daten.
								getUnscaledValue
							("PrognoseZustandIn15Minuten").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PrognoseZustandIn30Minuten").isState()) {
								setPrognoseZustandIn30Minuten(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
								.getZustand(daten.getScaledValue("PrognoseZustandIn30Minuten").getText()));
							} else {
							setPrognoseZustandIn30Minuten(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
							(daten.
								getUnscaledValue
							("PrognoseZustandIn30Minuten").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PrognoseZustandIn60Minuten").isState()) {
								setPrognoseZustandIn60Minuten(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
								.getZustand(daten.getScaledValue("PrognoseZustandIn60Minuten").getText()));
							} else {
							setPrognoseZustandIn60Minuten(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
							(daten.
								getUnscaledValue
							("PrognoseZustandIn60Minuten").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PrognoseZustandIn90Minuten").isState()) {
								setPrognoseZustandIn90Minuten(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
								.getZustand(daten.getScaledValue("PrognoseZustandIn90Minuten").getText()));
							} else {
							setPrognoseZustandIn90Minuten(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttGlaette
							(daten.
								getUnscaledValue
							("PrognoseZustandIn90Minuten").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAktuellerZustand(getAktuellerZustand());
							klon.setPrognoseZustandIn5Minuten(getPrognoseZustandIn5Minuten());
							klon.setPrognoseZustandIn15Minuten(getPrognoseZustandIn15Minuten());
							klon.setPrognoseZustandIn30Minuten(getPrognoseZustandIn30Minuten());
							klon.setPrognoseZustandIn60Minuten(getPrognoseZustandIn60Minuten());
							klon.setPrognoseZustandIn90Minuten(getPrognoseZustandIn90Minuten());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ufdmsGlätte";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdUfdmsGlaette(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
