/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für die Abbildung der Abtrocknungsphasen beim Übergang zwischen verschiedenen NässeStufen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 18
 */
public class PdUfdmsAbtrockungsPhasen extends AbstractParameterDatensatz<PdUfdmsAbtrockungsPhasen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private 	RelativerZeitstempel
				 _zeitNass4Nass3
				;
				private 	RelativerZeitstempel
				 _zeitNass3Nass2
				;
				private 	RelativerZeitstempel
				 _zeitNass2Nass1
				;
				private 	RelativerZeitstempel
				 _zeitNass1Trocken
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Verzögerungszeit für den Übergang von nass4 auf nass3.
			<p>
			
			</p>
			
			@return der Wert von ZeitNass4Nass3.
			*/
				public 	RelativerZeitstempel
				 getZeitNass4Nass3() {
				return _zeitNass4Nass3;
			}
		
			/**
			Verzögerungszeit für den Übergang von nass4 auf nass3.
			<p>
			
			</p>
			
			@param _zeitNass4Nass3 der neue Wert von ZeitNass4Nass3.
			*/
			public void setZeitNass4Nass3(	RelativerZeitstempel
			 _zeitNass4Nass3) {
				this._zeitNass4Nass3 = _zeitNass4Nass3;
			}
		
			/**
			Verzögerungszeit für den Übergang von nass3 auf nass2.
			<p>
			
			</p>
			
			@return der Wert von ZeitNass3Nass2.
			*/
				public 	RelativerZeitstempel
				 getZeitNass3Nass2() {
				return _zeitNass3Nass2;
			}
		
			/**
			Verzögerungszeit für den Übergang von nass3 auf nass2.
			<p>
			
			</p>
			
			@param _zeitNass3Nass2 der neue Wert von ZeitNass3Nass2.
			*/
			public void setZeitNass3Nass2(	RelativerZeitstempel
			 _zeitNass3Nass2) {
				this._zeitNass3Nass2 = _zeitNass3Nass2;
			}
		
			/**
			Verzögerungszeit für den Übergang von nass2 auf nass1.
			<p>
			
			</p>
			
			@return der Wert von ZeitNass2Nass1.
			*/
				public 	RelativerZeitstempel
				 getZeitNass2Nass1() {
				return _zeitNass2Nass1;
			}
		
			/**
			Verzögerungszeit für den Übergang von nass2 auf nass1.
			<p>
			
			</p>
			
			@param _zeitNass2Nass1 der neue Wert von ZeitNass2Nass1.
			*/
			public void setZeitNass2Nass1(	RelativerZeitstempel
			 _zeitNass2Nass1) {
				this._zeitNass2Nass1 = _zeitNass2Nass1;
			}
		
			/**
			Verzögerungszeit für den Übergang von nass1 auf trocken.
			<p>
			
			</p>
			
			@return der Wert von ZeitNass1Trocken.
			*/
				public 	RelativerZeitstempel
				 getZeitNass1Trocken() {
				return _zeitNass1Trocken;
			}
		
			/**
			Verzögerungszeit für den Übergang von nass1 auf trocken.
			<p>
			
			</p>
			
			@param _zeitNass1Trocken der neue Wert von ZeitNass1Trocken.
			*/
			public void setZeitNass1Trocken(	RelativerZeitstempel
			 _zeitNass1Trocken) {
				this._zeitNass1Trocken = _zeitNass1Trocken;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						datum.getTimeValue("ZeitNass4Nass3").setMillis(getZeitNass4Nass3().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("ZeitNass3Nass2").setMillis(getZeitNass3Nass2().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("ZeitNass2Nass1").setMillis(getZeitNass2Nass1().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("ZeitNass1Trocken").setMillis(getZeitNass1Trocken().getTime());
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						setZeitNass4Nass3(new
							RelativerZeitstempel
							(daten.getTimeValue("ZeitNass4Nass3").getMillis()));
					// ZeitstempelAttributTyp
						setZeitNass3Nass2(new
							RelativerZeitstempel
							(daten.getTimeValue("ZeitNass3Nass2").getMillis()));
					// ZeitstempelAttributTyp
						setZeitNass2Nass1(new
							RelativerZeitstempel
							(daten.getTimeValue("ZeitNass2Nass1").getMillis()));
					// ZeitstempelAttributTyp
						setZeitNass1Trocken(new
							RelativerZeitstempel
							(daten.getTimeValue("ZeitNass1Trocken").getMillis()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setZeitNass4Nass3(getZeitNass4Nass3());
							klon.setZeitNass3Nass2(getZeitNass3Nass2());
							klon.setZeitNass2Nass1(getZeitNass2Nass1());
							klon.setZeitNass1Trocken(getZeitNass1Trocken());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ufdmsAbtrockungsPhasen";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdUfdmsAbtrockungsPhasen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
