/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für die meteorologische Kontrolle der Pl Prüfung Logisch UFD ab Version 2.0.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class PdUfdmsParameterMeteorologischeKontrolle extends AbstractParameterDatensatz<PdUfdmsParameterMeteorologischeKontrolle.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _erzeugeBetriebsmeldungMeteorologischeKontrolle
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
				 _nIgrenzNS
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
				 _nIgrenzWFD
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 _wFDgrenzTrocken
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
				 _lTgrenzRegen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
				 _lTgrenzSchnee
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
				 _rLFgrenzTrocken
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
				 _rLFgrenzNass
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
				 _sWgrenz
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von ErzeugeBetriebsmeldungMeteorologischeKontrolle.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getErzeugeBetriebsmeldungMeteorologischeKontrolle() {
				return _erzeugeBetriebsmeldungMeteorologischeKontrolle;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _erzeugeBetriebsmeldungMeteorologischeKontrolle der neue Wert von ErzeugeBetriebsmeldungMeteorologischeKontrolle.
			*/
			public void setErzeugeBetriebsmeldungMeteorologischeKontrolle(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _erzeugeBetriebsmeldungMeteorologischeKontrolle) {
				this._erzeugeBetriebsmeldungMeteorologischeKontrolle = _erzeugeBetriebsmeldungMeteorologischeKontrolle;
			}
		
			/**
			Liegt NI über NIgrenzNS und ist NS = "kein Niederschlag", so ist NI implausibel.
			<p>
			
			</p>
			
			@return der Wert von NIgrenzNS.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
				 getNIgrenzNS() {
				return _nIgrenzNS;
			}
		
			/**
			Liegt NI über NIgrenzNS und ist NS = "kein Niederschlag", so ist NI implausibel.
			<p>
			
			</p>
			
			@param _nIgrenzNS der neue Wert von NIgrenzNS.
			*/
			public void setNIgrenzNS(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
			 _nIgrenzNS) {
				this._nIgrenzNS = _nIgrenzNS;
			}
		
			/**
			Liegt NI über NIgrenzWFD und ist die Fahrbahn trocken, so ist NI implausibel.
			<p>
			
			</p>
			
			@return der Wert von NIgrenzWFD.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
				 getNIgrenzWFD() {
				return _nIgrenzWFD;
			}
		
			/**
			Liegt NI über NIgrenzWFD und ist die Fahrbahn trocken, so ist NI implausibel.
			<p>
			
			</p>
			
			@param _nIgrenzWFD der neue Wert von NIgrenzWFD.
			*/
			public void setNIgrenzWFD(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
			 _nIgrenzWFD) {
				this._nIgrenzWFD = _nIgrenzWFD;
			}
		
			/**
			Liegt WFD unter WFDgrenzTrocken git die Fahrbahn als trocken.
			<p>
			
			</p>
			
			@return der Wert von WFDgrenzTrocken.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 getWFDgrenzTrocken() {
				return _wFDgrenzTrocken;
			}
		
			/**
			Liegt WFD unter WFDgrenzTrocken git die Fahrbahn als trocken.
			<p>
			
			</p>
			
			@param _wFDgrenzTrocken der neue Wert von WFDgrenzTrocken.
			*/
			public void setWFDgrenzTrocken(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
			 _wFDgrenzTrocken) {
				this._wFDgrenzTrocken = _wFDgrenzTrocken;
			}
		
			/**
			Liegt LT unter LTgrenzRegen, und is NS = "Regen" so ist NS implausibel.
			<p>
			
			</p>
			
			@return der Wert von LTgrenzRegen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
				 getLTgrenzRegen() {
				return _lTgrenzRegen;
			}
		
			/**
			Liegt LT unter LTgrenzRegen, und is NS = "Regen" so ist NS implausibel.
			<p>
			
			</p>
			
			@param _lTgrenzRegen der neue Wert von LTgrenzRegen.
			*/
			public void setLTgrenzRegen(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
			 _lTgrenzRegen) {
				this._lTgrenzRegen = _lTgrenzRegen;
			}
		
			/**
			Liegt LT über LTgrenzSchnee und ist NS = "Schnee", so ist NS implausibel.
			<p>
			
			</p>
			
			@return der Wert von LTgrenzSchnee.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
				 getLTgrenzSchnee() {
				return _lTgrenzSchnee;
			}
		
			/**
			Liegt LT über LTgrenzSchnee und ist NS = "Schnee", so ist NS implausibel.
			<p>
			
			</p>
			
			@param _lTgrenzSchnee der neue Wert von LTgrenzSchnee.
			*/
			public void setLTgrenzSchnee(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
			 _lTgrenzSchnee) {
				this._lTgrenzSchnee = _lTgrenzSchnee;
			}
		
			/**
			Grenzwert Trocken relative Luftfeuchte.
			<p>
			
			</p>
			
			@return der Wert von RLFgrenzTrocken.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
				 getRLFgrenzTrocken() {
				return _rLFgrenzTrocken;
			}
		
			/**
			Grenzwert Trocken relative Luftfeuchte.
			<p>
			
			</p>
			
			@param _rLFgrenzTrocken der neue Wert von RLFgrenzTrocken.
			*/
			public void setRLFgrenzTrocken(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
			 _rLFgrenzTrocken) {
				this._rLFgrenzTrocken = _rLFgrenzTrocken;
			}
		
			/**
			Grenzwert Nass relative Luftfeuchte.
			<p>
			
			</p>
			
			@return der Wert von RLFgrenzNass.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
				 getRLFgrenzNass() {
				return _rLFgrenzNass;
			}
		
			/**
			Grenzwert Nass relative Luftfeuchte.
			<p>
			
			</p>
			
			@param _rLFgrenzNass der neue Wert von RLFgrenzNass.
			*/
			public void setRLFgrenzNass(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
			 _rLFgrenzNass) {
				this._rLFgrenzNass = _rLFgrenzNass;
			}
		
			/**
			Wenn SW &lt;= SWgrenz und und RLF &lt; RLFGrenztrocken und kein Niederschlag ist, so ist SW implausibel.
			<p>
			
			</p>
			
			@return der Wert von SWgrenz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
				 getSWgrenz() {
				return _sWgrenz;
			}
		
			/**
			Wenn SW &lt;= SWgrenz und und RLF &lt; RLFGrenztrocken und kein Niederschlag ist, so ist SW implausibel.
			<p>
			
			</p>
			
			@param _sWgrenz der neue Wert von SWgrenz.
			*/
			public void setSWgrenz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
			 _sWgrenz) {
				this._sWgrenz = _sWgrenz;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getErzeugeBetriebsmeldungMeteorologischeKontrolle() != null) {
		                if (getErzeugeBetriebsmeldungMeteorologischeKontrolle().isZustand()) {
		                    datum.getUnscaledValue("erzeugeBetriebsmeldungMeteorologischeKontrolle").setText(getErzeugeBetriebsmeldungMeteorologischeKontrolle().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("erzeugeBetriebsmeldungMeteorologischeKontrolle").set(getErzeugeBetriebsmeldungMeteorologischeKontrolle().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNIgrenzNS() != null) {
		                if (getNIgrenzNS().isZustand()) {
		                    datum.getUnscaledValue("NIgrenzNS").setText(getNIgrenzNS().toString());
		                } else {
							datum.
							getScaledValue
		                	("NIgrenzNS").set(getNIgrenzNS().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNIgrenzWFD() != null) {
		                if (getNIgrenzWFD().isZustand()) {
		                    datum.getUnscaledValue("NIgrenzWFD").setText(getNIgrenzWFD().toString());
		                } else {
							datum.
							getScaledValue
		                	("NIgrenzWFD").set(getNIgrenzWFD().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getWFDgrenzTrocken() != null) {
		                if (getWFDgrenzTrocken().isZustand()) {
		                    datum.getUnscaledValue("WFDgrenzTrocken").setText(getWFDgrenzTrocken().toString());
		                } else {
							datum.
							getScaledValue
		                	("WFDgrenzTrocken").set(getWFDgrenzTrocken().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLTgrenzRegen() != null) {
		                if (getLTgrenzRegen().isZustand()) {
		                    datum.getUnscaledValue("LTgrenzRegen").setText(getLTgrenzRegen().toString());
		                } else {
							datum.
							getScaledValue
		                	("LTgrenzRegen").set(getLTgrenzRegen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLTgrenzSchnee() != null) {
		                if (getLTgrenzSchnee().isZustand()) {
		                    datum.getUnscaledValue("LTgrenzSchnee").setText(getLTgrenzSchnee().toString());
		                } else {
							datum.
							getScaledValue
		                	("LTgrenzSchnee").set(getLTgrenzSchnee().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRLFgrenzTrocken() != null) {
		                if (getRLFgrenzTrocken().isZustand()) {
		                    datum.getUnscaledValue("RLFgrenzTrocken").setText(getRLFgrenzTrocken().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RLFgrenzTrocken").set(getRLFgrenzTrocken().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRLFgrenzNass() != null) {
		                if (getRLFgrenzNass().isZustand()) {
		                    datum.getUnscaledValue("RLFgrenzNass").setText(getRLFgrenzNass().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RLFgrenzNass").set(getRLFgrenzNass().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSWgrenz() != null) {
		                if (getSWgrenz().isZustand()) {
		                    datum.getUnscaledValue("SWgrenz").setText(getSWgrenz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SWgrenz").set(getSWgrenz().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("erzeugeBetriebsmeldungMeteorologischeKontrolle").isState()) {
								setErzeugeBetriebsmeldungMeteorologischeKontrolle(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("erzeugeBetriebsmeldungMeteorologischeKontrolle").getText()));
							} else {
							setErzeugeBetriebsmeldungMeteorologischeKontrolle(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("erzeugeBetriebsmeldungMeteorologischeKontrolle").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("NIgrenzNS").isState()) {
								setNIgrenzNS(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
								.getZustand(daten.getScaledValue("NIgrenzNS").getText()));
							} else {
							setNIgrenzNS(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
							(daten.
								getScaledValue
							("NIgrenzNS").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("NIgrenzWFD").isState()) {
								setNIgrenzWFD(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
								.getZustand(daten.getScaledValue("NIgrenzWFD").getText()));
							} else {
							setNIgrenzWFD(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
							(daten.
								getScaledValue
							("NIgrenzWFD").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("WFDgrenzTrocken").isState()) {
								setWFDgrenzTrocken(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
								.getZustand(daten.getScaledValue("WFDgrenzTrocken").getText()));
							} else {
							setWFDgrenzTrocken(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
							(daten.
								getScaledValue
							("WFDgrenzTrocken").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LTgrenzRegen").isState()) {
								setLTgrenzRegen(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
								.getZustand(daten.getScaledValue("LTgrenzRegen").getText()));
							} else {
							setLTgrenzRegen(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
							(daten.
								getScaledValue
							("LTgrenzRegen").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LTgrenzSchnee").isState()) {
								setLTgrenzSchnee(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
								.getZustand(daten.getScaledValue("LTgrenzSchnee").getText()));
							} else {
							setLTgrenzSchnee(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
							(daten.
								getScaledValue
							("LTgrenzSchnee").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RLFgrenzTrocken").isState()) {
								setRLFgrenzTrocken(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
								.getZustand(daten.getScaledValue("RLFgrenzTrocken").getText()));
							} else {
							setRLFgrenzTrocken(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
							(daten.
								getUnscaledValue
							("RLFgrenzTrocken").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RLFgrenzNass").isState()) {
								setRLFgrenzNass(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
								.getZustand(daten.getScaledValue("RLFgrenzNass").getText()));
							} else {
							setRLFgrenzNass(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
							(daten.
								getUnscaledValue
							("RLFgrenzNass").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SWgrenz").isState()) {
								setSWgrenz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
								.getZustand(daten.getScaledValue("SWgrenz").getText()));
							} else {
							setSWgrenz(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSichtWeite
							(daten.
								getUnscaledValue
							("SWgrenz").
									intValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setErzeugeBetriebsmeldungMeteorologischeKontrolle(getErzeugeBetriebsmeldungMeteorologischeKontrolle());
							klon.setNIgrenzNS(getNIgrenzNS());
							klon.setNIgrenzWFD(getNIgrenzWFD());
							klon.setWFDgrenzTrocken(getWFDgrenzTrocken());
							klon.setLTgrenzRegen(getLTgrenzRegen());
							klon.setLTgrenzSchnee(getLTgrenzSchnee());
							klon.setRLFgrenzTrocken(getRLFgrenzTrocken());
							klon.setRLFgrenzNass(getRLFgrenzNass());
							klon.setSWgrenz(getSWgrenz());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ufdmsParameterMeteorologischeKontrolle";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdUfdmsParameterMeteorologischeKontrolle(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
