/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für die Differentialkontrolle (Prüfung. ob Sensorwert innerhalb eines parametrierbaren Zeitbereichs Schwankungen aufweist, ansonsten ist Sensorwert inplausibel).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 18
 */
public class PdUfdsDifferenzialKontrolleTemperaturInTiefe1 extends AbstractParameterDatensatz<PdUfdsDifferenzialKontrolleTemperaturInTiefe1.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsVergleichsOperator
				 _operator
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe1
				 _tT1Grenz
				;
				private 	RelativerZeitstempel
				 _tT1maxZeit
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Zu verwendender Operator zum Vergleich des Messwerts mit dem Grenzwert, der eingehalten werden muss, damit Differenzialkontrolle durchgeführt werden darf.
			<p>
			
			</p>
			
			@return der Wert von Operator.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsVergleichsOperator
				 getOperator() {
				return _operator;
			}
		
			/**
			Zu verwendender Operator zum Vergleich des Messwerts mit dem Grenzwert, der eingehalten werden muss, damit Differenzialkontrolle durchgeführt werden darf.
			<p>
			
			</p>
			
			@param _operator der neue Wert von Operator.
			*/
			public void setOperator(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsVergleichsOperator
			 _operator) {
				this._operator = _operator;
			}
		
			/**
			Grenzwert, der eingehalten werden muss, damit Differenzialkontrolle durchgeführt werden darf.
			<p>
			
			</p>
			
			@return der Wert von TT1Grenz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe1
				 getTT1Grenz() {
				return _tT1Grenz;
			}
		
			/**
			Grenzwert, der eingehalten werden muss, damit Differenzialkontrolle durchgeführt werden darf.
			<p>
			
			</p>
			
			@param _tT1Grenz der neue Wert von TT1Grenz.
			*/
			public void setTT1Grenz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe1
			 _tT1Grenz) {
				this._tT1Grenz = _tT1Grenz;
			}
		
			/**
			Maximal zulässige Zeitdauer der Ergebniskonstanz.
			<p>
			
			</p>
			
			@return der Wert von TT1maxZeit.
			*/
				public 	RelativerZeitstempel
				 getTT1maxZeit() {
				return _tT1maxZeit;
			}
		
			/**
			Maximal zulässige Zeitdauer der Ergebniskonstanz.
			<p>
			
			</p>
			
			@param _tT1maxZeit der neue Wert von TT1maxZeit.
			*/
			public void setTT1maxZeit(	RelativerZeitstempel
			 _tT1maxZeit) {
				this._tT1maxZeit = _tT1maxZeit;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getOperator() != null) {
		                if (getOperator().isZustand()) {
		                    datum.getUnscaledValue("Operator").setText(getOperator().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Operator").set(getOperator().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTT1Grenz() != null) {
		                if (getTT1Grenz().isZustand()) {
		                    datum.getUnscaledValue("TT1Grenz").setText(getTT1Grenz().toString());
		                } else {
							datum.
							getScaledValue
		                	("TT1Grenz").set(getTT1Grenz().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("TT1maxZeit").setMillis(getTT1maxZeit().getTime());
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Operator").isState()) {
								setOperator(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsVergleichsOperator
								.getZustand(daten.getScaledValue("Operator").getText()));
							} else {
							setOperator(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsVergleichsOperator
							(daten.
								getUnscaledValue
							("Operator").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TT1Grenz").isState()) {
								setTT1Grenz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe1
								.getZustand(daten.getScaledValue("TT1Grenz").getText()));
							} else {
							setTT1Grenz(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsTemperaturInTiefe1
							(daten.
								getScaledValue
							("TT1Grenz").
								doubleValue
							()));
							}
					// ZeitstempelAttributTyp
						setTT1maxZeit(new
							RelativerZeitstempel
							(daten.getTimeValue("TT1maxZeit").getMillis()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setOperator(getOperator());
							klon.setTT1Grenz(getTT1Grenz());
							klon.setTT1maxZeit(getTT1maxZeit());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ufdsDifferenzialKontrolleTemperaturInTiefe1";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdUfdsDifferenzialKontrolleTemperaturInTiefe1(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
