/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter mit den Hysteresschwellwerten zur Abbildung des Sensorwertes auf eine Stufe.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class PdUfdsKlassifizierungNiederschlagsIntensitaet extends AbstractParameterDatensatz<PdUfdsKlassifizierungNiederschlagsIntensitaet.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				> _klassifizierungNiederschlagsIntensitaet = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				> _klassifizierungNiederschlagsIntensitaetRegen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				> _klassifizierungNiederschlagsIntensitaetSchnee = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				> _klassifizierungNiederschlagsIntensitaetPlatzregen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				> _klassifizierungNiederschlagsIntensitaetGlaette = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Parametersatz zur Festlegung der Hysteresegrenzwerte für die Klassifizierung von Sensorwerten mittels Hysterese (Default-Werte für alle NI-FBZ-Klassen).
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungNiederschlagsIntensitaet.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				> getKlassifizierungNiederschlagsIntensitaet() {
				return _klassifizierungNiederschlagsIntensitaet;
			}
		
		
			/**
			Parametersatz zur Festlegung der Hysteresegrenzwerte für die Klassifizierung von Sensorwerten mittels Hysterese für NI-FBZ-Klasse Regen. Falls leer wird die Default-Liste benutzt.
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungNiederschlagsIntensitaetRegen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				> getKlassifizierungNiederschlagsIntensitaetRegen() {
				return _klassifizierungNiederschlagsIntensitaetRegen;
			}
		
		
			/**
			Parametersatz zur Festlegung der Hysteresegrenzwerte für die Klassifizierung von Sensorwerten mittels Hysterese für NI-FBZ-Klasse Schnee. Falls leer wird die Default-Liste benutzt.
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungNiederschlagsIntensitaetSchnee.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				> getKlassifizierungNiederschlagsIntensitaetSchnee() {
				return _klassifizierungNiederschlagsIntensitaetSchnee;
			}
		
		
			/**
			Parametersatz zur Festlegung der Hysteresegrenzwerte für die Klassifizierung von Sensorwerten mittels Hysterese für NI-FBZ-Klasse Platzregen. Falls leer wird die Default-Liste benutzt.
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungNiederschlagsIntensitaetPlatzregen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				> getKlassifizierungNiederschlagsIntensitaetPlatzregen() {
				return _klassifizierungNiederschlagsIntensitaetPlatzregen;
			}
		
		
			/**
			Parametersatz zur Festlegung der Hysteresegrenzwerte für die Klassifizierung von Sensorwerten mittels Hysterese für NI-FBZ-Klasse Glätte. Falls leer wird die Default-Liste benutzt.
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungNiederschlagsIntensitaetGlaette.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
				> getKlassifizierungNiederschlagsIntensitaetGlaette() {
				return _klassifizierungNiederschlagsIntensitaetGlaette;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungNiederschlagsIntensitaet = datum.getArray("KlassifizierungNiederschlagsIntensität");
						arrayKlassifizierungNiederschlagsIntensitaet.setLength(getKlassifizierungNiederschlagsIntensitaet().size());
						for (int i = 0; i < arrayKlassifizierungNiederschlagsIntensitaet.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 atl = getKlassifizierungNiederschlagsIntensitaet().get(i);
							atl.bean2Atl(arrayKlassifizierungNiederschlagsIntensitaet.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungNiederschlagsIntensitaetRegen = datum.getArray("KlassifizierungNiederschlagsIntensitätRegen");
						arrayKlassifizierungNiederschlagsIntensitaetRegen.setLength(getKlassifizierungNiederschlagsIntensitaetRegen().size());
						for (int i = 0; i < arrayKlassifizierungNiederschlagsIntensitaetRegen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 atl = getKlassifizierungNiederschlagsIntensitaetRegen().get(i);
							atl.bean2Atl(arrayKlassifizierungNiederschlagsIntensitaetRegen.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungNiederschlagsIntensitaetSchnee = datum.getArray("KlassifizierungNiederschlagsIntensitätSchnee");
						arrayKlassifizierungNiederschlagsIntensitaetSchnee.setLength(getKlassifizierungNiederschlagsIntensitaetSchnee().size());
						for (int i = 0; i < arrayKlassifizierungNiederschlagsIntensitaetSchnee.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 atl = getKlassifizierungNiederschlagsIntensitaetSchnee().get(i);
							atl.bean2Atl(arrayKlassifizierungNiederschlagsIntensitaetSchnee.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungNiederschlagsIntensitaetPlatzregen = datum.getArray("KlassifizierungNiederschlagsIntensitätPlatzregen");
						arrayKlassifizierungNiederschlagsIntensitaetPlatzregen.setLength(getKlassifizierungNiederschlagsIntensitaetPlatzregen().size());
						for (int i = 0; i < arrayKlassifizierungNiederschlagsIntensitaetPlatzregen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 atl = getKlassifizierungNiederschlagsIntensitaetPlatzregen().get(i);
							atl.bean2Atl(arrayKlassifizierungNiederschlagsIntensitaetPlatzregen.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungNiederschlagsIntensitaetGlaette = datum.getArray("KlassifizierungNiederschlagsIntensitätGlätte");
						arrayKlassifizierungNiederschlagsIntensitaetGlaette.setLength(getKlassifizierungNiederschlagsIntensitaetGlaette().size());
						for (int i = 0; i < arrayKlassifizierungNiederschlagsIntensitaetGlaette.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 atl = getKlassifizierungNiederschlagsIntensitaetGlaette().get(i);
							atl.bean2Atl(arrayKlassifizierungNiederschlagsIntensitaetGlaette.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungNiederschlagsIntensitaet = daten.getArray("KlassifizierungNiederschlagsIntensität");
						for (int i = 0; i < arrayKlassifizierungNiederschlagsIntensitaet.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 ();
							atl.atl2Bean(arrayKlassifizierungNiederschlagsIntensitaet.getItem(i), factory);
							getKlassifizierungNiederschlagsIntensitaet().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungNiederschlagsIntensitaetRegen = daten.getArray("KlassifizierungNiederschlagsIntensitätRegen");
						for (int i = 0; i < arrayKlassifizierungNiederschlagsIntensitaetRegen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 ();
							atl.atl2Bean(arrayKlassifizierungNiederschlagsIntensitaetRegen.getItem(i), factory);
							getKlassifizierungNiederschlagsIntensitaetRegen().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungNiederschlagsIntensitaetSchnee = daten.getArray("KlassifizierungNiederschlagsIntensitätSchnee");
						for (int i = 0; i < arrayKlassifizierungNiederschlagsIntensitaetSchnee.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 ();
							atl.atl2Bean(arrayKlassifizierungNiederschlagsIntensitaetSchnee.getItem(i), factory);
							getKlassifizierungNiederschlagsIntensitaetSchnee().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungNiederschlagsIntensitaetPlatzregen = daten.getArray("KlassifizierungNiederschlagsIntensitätPlatzregen");
						for (int i = 0; i < arrayKlassifizierungNiederschlagsIntensitaetPlatzregen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 ();
							atl.atl2Bean(arrayKlassifizierungNiederschlagsIntensitaetPlatzregen.getItem(i), factory);
							getKlassifizierungNiederschlagsIntensitaetPlatzregen().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungNiederschlagsIntensitaetGlaette = daten.getArray("KlassifizierungNiederschlagsIntensitätGlätte");
						for (int i = 0; i < arrayKlassifizierungNiederschlagsIntensitaetGlaette.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungNiederschlagsIntensitaet
							 ();
							atl.atl2Bean(arrayKlassifizierungNiederschlagsIntensitaetGlaette.getItem(i), factory);
							getKlassifizierungNiederschlagsIntensitaetGlaette().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._klassifizierungNiederschlagsIntensitaet = getKlassifizierungNiederschlagsIntensitaet().clone();
						klon._klassifizierungNiederschlagsIntensitaetRegen = getKlassifizierungNiederschlagsIntensitaetRegen().clone();
						klon._klassifizierungNiederschlagsIntensitaetSchnee = getKlassifizierungNiederschlagsIntensitaetSchnee().clone();
						klon._klassifizierungNiederschlagsIntensitaetPlatzregen = getKlassifizierungNiederschlagsIntensitaetPlatzregen().clone();
						klon._klassifizierungNiederschlagsIntensitaetGlaette = getKlassifizierungNiederschlagsIntensitaetGlaette().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ufdsKlassifizierungNiederschlagsIntensität";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdUfdsKlassifizierungNiederschlagsIntensitaet(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
