/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für die Langzeit-PL-Prüfung des Sensorwertes. Neben der Prüfung für das eingestellte Vergleichsintervall wird zusätzlich auch die PL-Prüfung jeweils für den Tag durchgeführt. Die zusätzlichen Parameter gelten somit sowohl für das Tagesintervall als auch für das Vergleichsintervall.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 18
 */
public class PdUfdsLangzeitPLPruefungSchneeHoehe extends AbstractParameterDatensatz<PdUfdsLangzeitPLPruefungSchneeHoehe.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStundenIntervallAnteile12h
				 _vergleichsIntervall
				;
				private 	RelativerZeitstempel
				 _maxAusfallZeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeHoehe
				 _maxAbweichungSH
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Vergleichsintervall, für das die Langzeit-PL-Prüfung durchgeführt wird.
			<p>
			
			</p>
			
			@return der Wert von VergleichsIntervall.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStundenIntervallAnteile12h
				 getVergleichsIntervall() {
				return _vergleichsIntervall;
			}
		
			/**
			Vergleichsintervall, für das die Langzeit-PL-Prüfung durchgeführt wird.
			<p>
			
			</p>
			
			@param _vergleichsIntervall der neue Wert von VergleichsIntervall.
			*/
			public void setVergleichsIntervall(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStundenIntervallAnteile12h
			 _vergleichsIntervall) {
				this._vergleichsIntervall = _vergleichsIntervall;
			}
		
			/**
			Maximal zulässige Ausfallzeitdauer. Ist die Summer der Ausfallzeiten für diesen Sensor, bei dem keine Daten im Vergleichszeitraum vorlagen, größer als msxAusfallZeit, so wird für dieses Intervall keine PL-Langzeitprüfung durchgeführt.
			<p>
			
			</p>
			
			@return der Wert von MaxAusfallZeit.
			*/
				public 	RelativerZeitstempel
				 getMaxAusfallZeit() {
				return _maxAusfallZeit;
			}
		
			/**
			Maximal zulässige Ausfallzeitdauer. Ist die Summer der Ausfallzeiten für diesen Sensor, bei dem keine Daten im Vergleichszeitraum vorlagen, größer als msxAusfallZeit, so wird für dieses Intervall keine PL-Langzeitprüfung durchgeführt.
			<p>
			
			</p>
			
			@param _maxAusfallZeit der neue Wert von MaxAusfallZeit.
			*/
			public void setMaxAusfallZeit(	RelativerZeitstempel
			 _maxAusfallZeit) {
				this._maxAusfallZeit = _maxAusfallZeit;
			}
		
			/**
			Maximal zulässige Abweichung der Werte des Sensors im Vergleich zu den Nachbarsensoren über das Vergleichsintervall.
			<p>
			
			</p>
			
			@return der Wert von MaxAbweichungSH.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeHoehe
				 getMaxAbweichungSH() {
				return _maxAbweichungSH;
			}
		
			/**
			Maximal zulässige Abweichung der Werte des Sensors im Vergleich zu den Nachbarsensoren über das Vergleichsintervall.
			<p>
			
			</p>
			
			@param _maxAbweichungSH der neue Wert von MaxAbweichungSH.
			*/
			public void setMaxAbweichungSH(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeHoehe
			 _maxAbweichungSH) {
				this._maxAbweichungSH = _maxAbweichungSH;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getVergleichsIntervall() != null) {
		                if (getVergleichsIntervall().isZustand()) {
		                    datum.getUnscaledValue("VergleichsIntervall").setText(getVergleichsIntervall().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VergleichsIntervall").set(getVergleichsIntervall().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("maxAusfallZeit").setMillis(getMaxAusfallZeit().getTime());
					// GanzzahlAttributTyp
					if (getMaxAbweichungSH() != null) {
		                if (getMaxAbweichungSH().isZustand()) {
		                    datum.getUnscaledValue("maxAbweichungSH").setText(getMaxAbweichungSH().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maxAbweichungSH").set(getMaxAbweichungSH().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VergleichsIntervall").isState()) {
								setVergleichsIntervall(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStundenIntervallAnteile12h
								.getZustand(daten.getScaledValue("VergleichsIntervall").getText()));
							} else {
							setVergleichsIntervall(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStundenIntervallAnteile12h
							(daten.
								getUnscaledValue
							("VergleichsIntervall").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setMaxAusfallZeit(new
							RelativerZeitstempel
							(daten.getTimeValue("maxAusfallZeit").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("maxAbweichungSH").isState()) {
								setMaxAbweichungSH(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeHoehe
								.getZustand(daten.getScaledValue("maxAbweichungSH").getText()));
							} else {
							setMaxAbweichungSH(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsSchneeHoehe
							(daten.
								getUnscaledValue
							("maxAbweichungSH").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setVergleichsIntervall(getVergleichsIntervall());
							klon.setMaxAusfallZeit(getMaxAusfallZeit());
							klon.setMaxAbweichungSH(getMaxAbweichungSH());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ufdsLangzeitPLPrüfungSchneeHöhe";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdUfdsLangzeitPLPruefungSchneeHoehe(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
