/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Werte für den Sensor der Fahrbahnglätte.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class UfdsGlaettewarnungHerstellerImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.objekte.UfdsGlaettewarnungHersteller { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public UfdsGlaettewarnungHerstellerImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public UfdsGlaettewarnungHerstellerImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein UfdsGlättewarnungHersteller.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsLangzeitPLPruefungGlaettewarnungHersteller getPdUfdsLangzeitPLPruefungGlaettewarnungHersteller() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsLangzeitPLPruefungGlaettewarnungHersteller.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsAggregationGlaettewarnungHersteller getPdUfdsAggregationGlaettewarnungHersteller() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsAggregationGlaettewarnungHersteller.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsMeteorologischeKontrolleGlaettewarnungHersteller getPdUfdsMeteorologischeKontrolleGlaettewarnungHersteller() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsMeteorologischeKontrolleGlaettewarnungHersteller.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.onlinedaten.OdUfdsStufeGlaettewarnungHersteller getOdUfdsStufeGlaettewarnungHersteller() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.onlinedaten.OdUfdsStufeGlaettewarnungHersteller.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMessWertErsetzung getPdUfdsMessWertErsetzung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMessWertErsetzung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAusfallUeberwachung getPdUfdsAusfallUeberwachung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAusfallUeberwachung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenSensor getKdUmfeldDatenSensor() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenSensor.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsAnstiegAbstiegKontrolleGlaettewarnungHersteller getPdUfdsAnstiegAbstiegKontrolleGlaettewarnungHersteller() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsAnstiegAbstiegKontrolleGlaettewarnungHersteller.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsDifferenzialKontrolleGlaettewarnungHersteller getPdUfdsDifferenzialKontrolleGlaettewarnungHersteller() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsDifferenzialKontrolleGlaettewarnungHersteller.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.onlinedaten.OdUfdsGlaettewarnungHersteller getOdUfdsGlaettewarnungHersteller() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.onlinedaten.OdUfdsGlaettewarnungHersteller.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsKlassifizierungGlaettewarnungHersteller getPdUfdsKlassifizierungGlaettewarnungHersteller() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.parameter.PdUfdsKlassifizierungGlaettewarnungHersteller.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
