/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Sensorwert des Umfelddatensensors mit Statusinformationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlUfdsZeitreserveGlaetteVaisala implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
			 _wert
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
			 _zeitreserveReifglaette
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
			 _zeitreserveRegenwarnung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsStatus
			 _status
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsStatus
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 _guete
			= new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			()
			;
	
		/**
		Zeitreserve Eisglätte in Minuten. Der Attributname Wert wird aus Kompatibilitätsgründen gewählt.
		<p>
		
		</p>
		
		@return der Wert von Wert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
			 getWert() {
			return _wert;
		}
	
		/**
		Zeitreserve Eisglätte in Minuten. Der Attributname Wert wird aus Kompatibilitätsgründen gewählt.
		<p>
		
		</p>
		
		@param _wert der neue Wert von Wert.
		*/
		public void setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
		 _wert) {
			this._wert = _wert;
		}
	
		/**
		Zeitreserve Reifglätte in Minuten.
		<p>
		
		</p>
		
		@return der Wert von ZeitreserveReifglaette.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
			 getZeitreserveReifglaette() {
			return _zeitreserveReifglaette;
		}
	
		/**
		Zeitreserve Reifglätte in Minuten.
		<p>
		
		</p>
		
		@param _zeitreserveReifglaette der neue Wert von ZeitreserveReifglaette.
		*/
		public void setZeitreserveReifglaette(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
		 _zeitreserveReifglaette) {
			this._zeitreserveReifglaette = _zeitreserveReifglaette;
		}
	
		/**
		Zeitreserve Regenwarnung in Minuten.
		<p>
		
		</p>
		
		@return der Wert von ZeitreserveRegenwarnung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
			 getZeitreserveRegenwarnung() {
			return _zeitreserveRegenwarnung;
		}
	
		/**
		Zeitreserve Regenwarnung in Minuten.
		<p>
		
		</p>
		
		@param _zeitreserveRegenwarnung der neue Wert von ZeitreserveRegenwarnung.
		*/
		public void setZeitreserveRegenwarnung(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
		 _zeitreserveRegenwarnung) {
			this._zeitreserveRegenwarnung = _zeitreserveRegenwarnung;
		}
	
		/**
		Statusinformationen zum Wert, der sich aus
								unterschiedlichen Zwischenberechnungen ergibt.
		<p>
		
		</p>
		
		@return der Wert von Status.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsStatus
			 getStatus() {
			return _status;
		}
	
		/**
		Statusinformationen zum Wert, der sich aus
								unterschiedlichen Zwischenberechnungen ergibt.
		<p>
		
		</p>
		
		@param _status der neue Wert von Status.
		*/
		public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsStatus
		 _status) {
			this._status = _status;
		}
	
		/**
		Güteinformationen zum Wert (Güte und Verfahren, welches
								zur Güteermittlung verwendet wurde).
		<p>
		
		</p>
		
		@return der Wert von Guete.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 getGuete() {
			return _guete;
		}
	
		/**
		Güteinformationen zum Wert (Güte und Verfahren, welches
								zur Güteermittlung verwendet wurde).
		<p>
		
		</p>
		
		@param _guete der neue Wert von Guete.
		*/
		public void setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
		 _guete) {
			this._guete = _guete;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getWert() != null) {
	                if (getWert().isZustand()) {
	                    datum.getUnscaledValue("Wert").setText(getWert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Wert").set(getWert().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZeitreserveReifglaette() != null) {
	                if (getZeitreserveReifglaette().isZustand()) {
	                    datum.getUnscaledValue("ZeitreserveReifglätte").setText(getZeitreserveReifglaette().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ZeitreserveReifglätte").set(getZeitreserveReifglaette().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZeitreserveRegenwarnung() != null) {
	                if (getZeitreserveRegenwarnung().isZustand()) {
	                    datum.getUnscaledValue("ZeitreserveRegenwarnung").setText(getZeitreserveRegenwarnung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ZeitreserveRegenwarnung").set(getZeitreserveRegenwarnung().getValue());
	                }
				}
				// AttributListenDefinition
					getStatus().bean2Atl(datum.getItem("Status"), factory);
				// AttributListenDefinition
					getGuete().bean2Atl(datum.getItem("Güte"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Wert").isState()) {
							setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
							.getZustand(daten.getScaledValue("Wert").getText()));
						} else {
						setWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
						(daten.
							getUnscaledValue
						("Wert").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ZeitreserveReifglätte").isState()) {
							setZeitreserveReifglaette(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
							.getZustand(daten.getScaledValue("ZeitreserveReifglätte").getText()));
						} else {
						setZeitreserveReifglaette(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
						(daten.
							getUnscaledValue
						("ZeitreserveReifglätte").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ZeitreserveRegenwarnung").isState()) {
							setZeitreserveRegenwarnung(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
							.getZustand(daten.getScaledValue("ZeitreserveRegenwarnung").getText()));
						} else {
						setZeitreserveRegenwarnung(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenvaisala.attribute.AttUfdsZeitreserveVaisala
						(daten.
							getUnscaledValue
						("ZeitreserveRegenwarnung").
								shortValue
						()));
						}
				// AttributListenDefinition
					getStatus().atl2Bean(daten.getItem("Status"), factory);
				// AttributListenDefinition
					getGuete().atl2Bean(daten.getItem("Güte"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUfdsZeitreserveGlaetteVaisala clone() {
		AtlUfdsZeitreserveGlaetteVaisala klon = new AtlUfdsZeitreserveGlaetteVaisala();
		
						klon.setWert(getWert());
						klon.setZeitreserveReifglaette(getZeitreserveReifglaette());
						klon.setZeitreserveRegenwarnung(getZeitreserveRegenwarnung());
						klon._status = getStatus().clone();
						klon._guete = getGuete().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
